/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.CRL;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.Generatorbindingref;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyInfoSignature;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonext.AddTimestamp;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.Nonce;
import com.ibm.etools.webservice.wscommonext.SecurityToken;
import com.ibm.etools.webservice.wscommonext.Timestamp;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.EngineFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSEMFRequestGeneratorConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSEMFRequestGeneratorConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFRequestGeneratorConfig.class.getName();
    private String origin = "non-ws-security";

    public WSEMFRequestGeneratorConfig(SecurityRequestGeneratorBindingConfig reqGenBnd, SecurityRequestGeneratorServiceConfig reqGenExt, String actorURI, VariableMap varMap, WSSecurityService service) throws SoapSecurityException {
        this(reqGenBnd, reqGenExt, actorURI, varMap, service, null);
    }

    public WSEMFRequestGeneratorConfig(SecurityRequestGeneratorBindingConfig reqGenBnd, SecurityRequestGeneratorServiceConfig reqGenExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestGeneratorConfig(SecurityRequestGeneratorBindingConfig, SecurityRequestGeneratorServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{reqGenBnd, reqGenExt, actorURI, varMap, service, appClassLoader});
        }
        this.init(reqGenBnd, reqGenExt, actorURI, varMap, service, appClassLoader);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFRequestGeneratorConfig(SecurityRequestGeneratorBindingConfig, SecurityRequestGeneratorServiceConfig, actorURI, VariableMap, Object, ClassLoader)");
        }
    }

    protected WSEMFRequestGeneratorConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestGeneratorConfig()");
            Tr.exit(tc, "WSEMFRequestGeneratorConfig()");
        }
    }

    protected final void init(SecurityRequestGeneratorBindingConfig reqGenBnd, SecurityRequestGeneratorServiceConfig reqGenExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl kigconfig;
        PrivateCommonConfig.AlgorithmConfImpl aconfig;
        String keyStoreName;
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl kicgconfig;
        int k;
        int kMax;
        PrivateCommonConfig.KeyInformationConfImpl kiconfig;
        PrivateCommonConfig.KeyStoreConfImpl ksconfig;
        Set mappings;
        PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig;
        String porder;
        Iterator it;
        boolean processed;
        EList nonces;
        Timestamp timestamp;
        EList timestamps;
        PrivateCommonConfig.PartConfImpl pconfig;
        MessageParts messagePart;
        int j;
        int jMax;
        EList messageParts;
        PrivateCommonConfig.ReferencePartConfImpl rpconfig;
        int i;
        int iMax;
        String tmpActor;
        EList p;
        String value;
        Generatorbindingref gref;
        boolean useDefault;
        Object dconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityRequestGeneratorBindingConfig, SecurityRequestGeneratorServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{reqGenBnd, reqGenExt, actorURI, varMap, service, appClassLoader});
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig());
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<String, Object> type = new HashMap<String, Object>();
        HashMap<String, PrivateCommonConfig.ReferencePartConfImpl> nameIntegrity = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
        HashMap<String, PrivateCommonConfig.ReferencePartConfImpl> nameConfidentiality = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
        HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl> nameToken = new HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
        HashMap<String, PrivateCommonConfig.KeyLocatorConfImpl> nameKeyLocator = new HashMap<String, PrivateCommonConfig.KeyLocatorConfImpl>();
        HashMap<String, PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl> nameKeyInfo = new HashMap<String, PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl>();
        ArrayList<PrivateCommonConfig.ReferencePartConfImpl> order = new ArrayList<PrivateCommonConfig.ReferencePartConfImpl>();
        HashMap<String, String> orderMap = new HashMap<String, String>();
        EList integrities = null;
        EList confidentialities = null;
        EList securityTokens = null;
        AddTimestamp addTimestamp = null;
        String actor = null;
        String hwConfigName = null;
        String hwKeyStoreName = null;
        if (varMap == null) {
            varMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration config = null;
        if (service != null && (dconfig = service.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            config = (WSSecurityDefaultConfiguration)dconfig;
        }
        boolean bl = useDefault = reqGenBnd == null;
        if (!useDefault && (gref = reqGenBnd.getGeneratorbindingref()) != null && "DEFAULT".equals(value = ConfigUtil.trim((String)gref.getRef()))) {
            useDefault = true;
        }
        WSSGeneratorConfig dgconfig = null;
        Map defaultProps = null;
        Map extProperties = null;
        Map bndProperties = null;
        this._properties = new HashMap();
        if (config != null) {
            dgconfig = config.getDefaultGeneratorBinding();
            if (dgconfig != null) {
                defaultProps = dgconfig.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            } else {
                defaultProps = config.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            }
        }
        if (reqGenExt != null && (p = reqGenExt.getProperties()) != null && (extProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(extProperties);
        }
        if (!useDefault && (p = reqGenBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndProperties);
        }
        if (reqGenExt != null) {
            integrities = reqGenExt.getIntegrity();
            confidentialities = reqGenExt.getConfidentiality();
            securityTokens = reqGenExt.getSecurityToken();
            addTimestamp = reqGenExt.getAddTimestamp();
            actor = reqGenExt.getActor();
            if (tc.isDebugEnabled()) {
                if (extProperties != null) {
                    Tr.debug(tc, "Request Generator Deployment Descriptor (Integrities, Confidentialities, SecurityTokens, AddTimestamp, Actor, Property):", new Object[]{integrities, confidentialities, securityTokens, addTimestamp, actor, extProperties});
                } else {
                    Tr.debug(tc, "Request Generator Deployment Descriptor (Integrities, Confidentialities, SecurityTokens, AddTimestamp, Actor):", new Object[]{integrities, confidentialities, securityTokens, addTimestamp, actor});
                }
            }
        }
        this._clientSetMustUnderstand = ConfigUtil.getIsFalseProperty((Map)this._properties, (String)Constants.WSSECURITY_SET_MUSTUNDERSTAND);
        if (actorURI != null) {
            tmpActor = actorURI.trim();
            if (tmpActor.length() != 0) {
                try {
                    URI checkURI = new URI(tmpActor);
                }
                catch (URISyntaxException uriex) {
                    throw new SoapSecurityException("Actor URI validation failed", uriex);
                }
                this._myActor = tmpActor;
            }
        } else {
            this._myActor = null;
        }
        if (actor != null) {
            tmpActor = actor.trim();
            if (tmpActor.length() != 0) {
                this._targetActor = tmpActor;
            }
        } else {
            this._targetActor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this._myActor + ", actor = " + this._targetActor);
        }
        if (integrities != null) {
            iMax = integrities.size();
            for (i = 0; i < iMax; ++i) {
                this._signatureEnabled = true;
                Integrity integrity = (Integrity)integrities.get(i);
                rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                rpconfig._oneOfIntegralParts = true;
                value = ConfigUtil.trim((String)integrity.getOrder());
                if (value != null && value.length() > 0) {
                    rpconfig._order = Integer.parseInt(value);
                }
                if ((messageParts = integrity.getMessageParts()) != null) {
                    jMax = messageParts.size();
                    for (j = 0; j < jMax; ++j) {
                        messagePart = (MessageParts)messageParts.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._dialect = ConfigUtil.trim((String)messagePart.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)messagePart.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((timestamps = integrity.getTimestamp()) != null) {
                    jMax = timestamps.size();
                    for (j = 0; j < jMax; ++j) {
                        timestamp = (Timestamp)timestamps.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._timestamp = true;
                        pconfig._dialect = ConfigUtil.trim((String)timestamp.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)timestamp.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((nonces = integrity.getNonce()) != null) {
                    jMax = nonces.size();
                    for (j = 0; j < jMax; ++j) {
                        Nonce nonce = (Nonce)nonces.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._nonce = true;
                        pconfig._dialect = ConfigUtil.trim((String)nonce.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)nonce.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                processed = false;
                it = order.iterator();
                j = 0;
                while (it.hasNext()) {
                    if (rpconfig._order < ((PrivateCommonConfig.ReferencePartConfImpl)it.next())._order) {
                        processed = true;
                        order.add(j, rpconfig);
                        break;
                    }
                    ++j;
                }
                if (!processed) {
                    order.add(rpconfig);
                }
                this._integralParts.add(rpconfig);
                value = ConfigUtil.trim((String)integrity.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                }
                porder = Integer.toString(rpconfig.getOrder());
                if (orderMap.containsKey(porder)) {
                    String name = orderMap.get(porder).toString();
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s22", new String[]{porder, name, value});
                }
                orderMap.put(porder, value);
                if (nameIntegrity.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: integrity [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding integrity: " + value);
                }
                nameIntegrity.put(value, rpconfig);
            }
        }
        if (confidentialities != null) {
            iMax = confidentialities.size();
            for (i = 0; i < iMax; ++i) {
                this._encryptionEnabled = true;
                Confidentiality confidentiality = (Confidentiality)confidentialities.get(i);
                rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                value = confidentiality.getOrder();
                if (value != null) {
                    rpconfig._order = Integer.parseInt(value);
                }
                if ((messageParts = confidentiality.getMessageParts()) != null) {
                    jMax = messageParts.size();
                    for (j = 0; j < jMax; ++j) {
                        messagePart = (MessageParts)messageParts.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._dialect = ConfigUtil.trim((String)messagePart.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)messagePart.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((timestamps = confidentiality.getTimestamp()) != null) {
                    jMax = timestamps.size();
                    for (j = 0; j < jMax; ++j) {
                        timestamp = (Timestamp)timestamps.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._timestamp = true;
                        pconfig._dialect = ConfigUtil.trim((String)timestamp.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)timestamp.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((nonces = confidentiality.getNonce()) != null) {
                    jMax = nonces.size();
                    for (j = 0; j < jMax; ++j) {
                        Nonce nonce = (Nonce)nonces.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._nonce = true;
                        pconfig._dialect = ConfigUtil.trim((String)nonce.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)nonce.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                processed = false;
                it = order.iterator();
                j = 0;
                while (it.hasNext()) {
                    if (rpconfig._order < ((PrivateCommonConfig.ReferencePartConfImpl)it.next())._order) {
                        processed = true;
                        order.add(j, rpconfig);
                        break;
                    }
                    ++j;
                }
                if (!processed) {
                    order.add(rpconfig);
                }
                this._confidentialParts.add(rpconfig);
                value = ConfigUtil.trim((String)confidentiality.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                }
                porder = Integer.toString(rpconfig.getOrder());
                if (orderMap.containsKey(porder)) {
                    String name = orderMap.get(porder).toString();
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s22", new String[]{porder, name, value});
                }
                orderMap.put(porder, value);
                if (nameConfidentiality.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: confidentiality [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding confidentiality: " + value);
                }
                nameConfidentiality.put(value, rpconfig);
            }
        }
        if (securityTokens != null) {
            iMax = securityTokens.size();
            for (i = 0; i < iMax; ++i) {
                this._tokenEnabled = true;
                SecurityToken securityToken = (SecurityToken)securityTokens.get(i);
                tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                tconfig._standAlone = true;
                tconfig._type = new QName(ConfigUtil.trim((String)securityToken.getUri()), ConfigUtil.trim((String)securityToken.getLocalName()));
                this._securityTokens.add(tconfig);
                value = ConfigUtil.trim((String)securityToken.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                }
                if (nameToken.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: security token [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding security token: " + value);
                }
                nameToken.put(value, tconfig);
                tconfig._name = value;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_securityTokens =" + this._securityTokens);
            }
        }
        if (addTimestamp != null) {
            this._timestampEnabled = true;
            PrivateGeneratorConfig.TimestampGeneratorConfImpl tsconfig = new PrivateGeneratorConfig.TimestampGeneratorConfImpl();
            tsconfig._myActor = this._myActor;
            tsconfig._targetActor = this._targetActor;
            value = addTimestamp.getExpires();
            if (value != null && value.length() > 0) {
                try {
                    tsconfig._duration = Duration.parse((String)value);
                }
                catch (ParseException pe) {
                    String msgKey = "security.wssecurity.PrivateGeneratorConfig.s24";
                    FFDCFilter.processException((Throwable)pe, clsName + ".WSEMFRequestSenderConfig", "614", this);
                    Tr.error(tc, msgKey, value);
                    throw SoapSecurityException.format(msgKey, value, (Throwable)pe);
                }
            }
            ConfigConstants.getProperties(tsconfig._properties, addTimestamp.getProperties(), varMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding timestamp: " + this._timestampEnabled);
            }
            this._timestampGenerator = tsconfig;
        }
        this._nonceManager = NonceManagerFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NonceManager = " + this._nonceManager);
        }
        if (config != null && (mappings = config.getAlgorithmMappings()) != null && !mappings.isEmpty()) {
            for (PrivateCommonConfig.AlgorithmMappingConfImpl amconfig : mappings) {
                EngineFactory efactory;
                String factoryName = amconfig.getFactoryName();
                Set algorithmURIs = amconfig.getAlgorithmURIs();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instanciating a EngineFactory: " + factoryName);
                }
                if ((efactory = this._algorithmFactory.addPluggableFactory(factoryName, algorithmURIs, appClassLoader)) == null) {
                    if (ConfigValidation.isFipsEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "addPluggableFactory() returned null for factory " + factoryName + " because FIPS mode is enabled");
                        }
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0147E", new Object[]{factoryName});
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiated EngineFactory: " + efactory);
                }
                if (efactory == null) continue;
                this._userDefinedComponentsUsed = true;
                Set set = efactory.getSignatureAlgorithms();
                if (set != null && !set.isEmpty()) {
                    this._allowedSignatureMethods.addAll(set);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the allowed signature algorithms: " + set);
                }
                if ((set = efactory.getDigestAlgorithms()) != null && !set.isEmpty()) {
                    this._allowedDigestMethods.addAll(set);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the allowed digest algorithms: " + set);
                }
                if ((set = efactory.getDataEncryptionAlgorithms()) != null && !set.isEmpty()) {
                    this._allowedDataEncryptionMethods.addAll(set);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the allowed data encryption algorithms: " + set);
                }
                if ((set = efactory.getKeyEncryptionAlgorithms()) != null && !set.isEmpty()) {
                    this._allowedKeyEncryptionMethods.addAll(set);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding the allowed key encryption algorithms: " + set);
            }
        }
        if (config != null) {
            hwConfigName = config.getHardwareConfigName();
            if (hwConfigName != null && hwConfigName.length() != 0) {
                this._properties.put("HWCONFIG", hwConfigName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware Acceleration is Enabled " + hwConfigName);
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.OffloadAllCryptography", config.getUseOffloadAllCrypto());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware Acceleration is Enabled :" + hwConfigName + ", OFFLOAD_ALL_CRYPTO is: " + config.getUseOffloadAllCrypto());
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.hardwareCacheSize", new Integer(config.getHardwareCacheSize()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware cache size = " + config.getHardwareCacheSize());
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography", new Boolean(config.getOffloadRSAPublicKeyCrypto()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Offload RSA Public Key crypto = " + config.getOffloadRSAPublicKeyCrypto());
                }
            }
            if ((hwKeyStoreName = config.getHardwareKeyStoreName()) != null) {
                this._properties.put("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore", hwKeyStoreName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware Keystore is specified in default bindings " + hwKeyStoreName);
                }
            }
        }
        CertStoreList certStoreList = null;
        EList encryptionInfos = null;
        EList keyInfos = null;
        EList keyLocators = null;
        EList signingInfos = null;
        EList tokenGenerators = null;
        EList trustAnchors = null;
        if (useDefault) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default binding...");
            }
            if (config == null) {
                Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s25");
            } else {
                if (dgconfig == null) {
                    dgconfig = config.getDefaultGeneratorBinding();
                }
                if (dgconfig != null) {
                    this.initDefaultConfig(dgconfig, nameToken, order);
                }
            }
            this.validate(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.getLogProperties(defaultProps, extProperties, null, "request"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "init(SecurityRequestGeneratorBindingConfig, SecurityRequestGeneratorServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader)");
            }
            return;
        }
        certStoreList = reqGenBnd.getCertStoreList();
        encryptionInfos = reqGenBnd.getEncryptionInfo();
        keyInfos = reqGenBnd.getKeyInfo();
        keyLocators = reqGenBnd.getKeyLocator();
        signingInfos = reqGenBnd.getSigningInfo();
        tokenGenerators = reqGenBnd.getTokenGenerator();
        trustAnchors = reqGenBnd.getTrustAnchor();
        if (tc.isDebugEnabled()) {
            if (bndProperties != null) {
                Tr.debug(tc, "Request Generator Binding (CertStoreList, EncryptionInfos, KeyInfos, KeyLocators, SigningInfos, TokenGenerators, TrustAnchors, Property):", new Object[]{certStoreList, encryptionInfos, keyInfos, keyLocators, signingInfos, tokenGenerators, trustAnchors, bndProperties});
            } else {
                Tr.debug(tc, "Request Generator Binding (CertStoreList, EncryptionInfos, KeyInfos, KeyLocators, SigningInfos, TokenGenerators, TrustAnchors):", new Object[]{certStoreList, encryptionInfos, keyInfos, keyLocators, signingInfos, tokenGenerators, trustAnchors});
            }
        }
        if (tokenGenerators != null) {
            HashMap nameToken2 = new HashMap(nameToken);
            iMax = tokenGenerators.size();
            for (i = 0; i < iMax; ++i) {
                CertStoreRef certStoreRef;
                CertPathSettings certPathSettings;
                CallbackHandler callbackHandler;
                TokenGenerator tokenGenerator = (TokenGenerator)tokenGenerators.get(i);
                ValueType valueType = tokenGenerator.getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token generator named " + tokenGenerator.getName() + " is missing");
                }
                QName qn = new QName(ConfigUtil.trim((String)valueType.getUri()), ConfigUtil.trim((String)valueType.getLocalName()));
                PartReference pref = tokenGenerator.getPartReference();
                tconfig = null;
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)nameToken2.get(value);
                    if (tconfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (!tconfig.getType().equals(qn)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s30", tconfig.getType().toString(), qn.toString());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                if (tconfig == null) {
                    tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                    tconfig._type = qn;
                }
                tconfig._className = ConfigUtil.trim((String)tokenGenerator.getClassname());
                if (!this._defaultTokenGenerators.contains(tconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                if ((callbackHandler = tokenGenerator.getCallbackHandler()) != null) {
                    KeyStore keystore;
                    PrivateGeneratorConfig.CallbackHandlerConfImpl cconfig = new PrivateGeneratorConfig.CallbackHandlerConfImpl();
                    cconfig._className = ConfigUtil.trim((String)callbackHandler.getClassname());
                    if (!this._defaultCallbackHandlers.contains(cconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    if ((keystore = callbackHandler.getKeyStore()) != null) {
                        ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                        ksconfig._type = ConfigUtil.trim((String)keystore.getType());
                        ksconfig._path = varMap == null ? ConfigUtil.trim((String)keystore.getPath()) : varMap.expand(ConfigUtil.trim((String)keystore.getPath()));
                        ksconfig._password = ConfigUtil.trim((String)keystore.getStorepass());
                        ksconfig._ksRef = ConfigUtil.trim((String)keystore.getKeyStoreRef());
                        cconfig._keyStoreConfig = ksconfig;
                        if (ksconfig._ksRef != null && ksconfig._ksRef.length() != 0) {
                            tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksconfig._ksRef);
                        }
                    }
                    EList keys = callbackHandler.getKey();
                    jMax = keys.size();
                    for (j = 0; j < jMax; ++j) {
                        Key key = (Key)keys.get(j);
                        kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                        kiconfig._alias = ConfigUtil.trim((String)key.getAlias());
                        kiconfig._keypass = ConfigUtil.trim((String)key.getKeypass());
                        kiconfig._name = ConfigUtil.trim((String)key.getName());
                        cconfig._keyInformationList.add(kiconfig);
                    }
                    BasicAuth basicAuth = callbackHandler.getBasicAuth();
                    if (basicAuth != null) {
                        value = ConfigUtil.trim((String)basicAuth.getUserid());
                        if (value != null && value.length() > 0) {
                            cconfig._userId = value;
                        }
                        if ((value = ConfigUtil.trim((String)basicAuth.getPassword())) != null && value.length() > 0) {
                            cconfig._userPassword = value.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(cconfig._properties, callbackHandler.getProperties(), varMap);
                    tconfig._callbackHandler = cconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + cconfig.getClassName());
                    }
                }
                if ((certPathSettings = tokenGenerator.getCertPathSettings()) != null && (certStoreRef = certPathSettings.getCertStoreRef()) != null) {
                    ArrayList<Object> certStores = new ArrayList<Object>();
                    Provider provider = null;
                    if (certStoreRef != null) {
                        value = ConfigUtil.trim((String)certStoreRef.getRef());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CertStoreRef = " + value);
                        }
                        boolean certStoreFound = false;
                        if (certStoreList != null) {
                            CertStore certStore;
                            EList collectionCertStores = certStoreList.getCollectionCertStores();
                            jMax = collectionCertStores.size();
                            for (j = 0; j < jMax; ++j) {
                                String msgKey;
                                CollectionCertStore collectionStore = (CollectionCertStore)collectionCertStores.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "collectionCertStores.get(" + j + ") = " + collectionStore.getName());
                                }
                                if (value == null || !value.equals(ConfigUtil.trim((String)collectionStore.getName()))) continue;
                                provider = Security.getProvider(ConfigUtil.trim((String)collectionStore.getProvider()));
                                HashMap<String, CertificateFactory> cache = new HashMap<String, CertificateFactory>();
                                HashSet<X509Extension> eeCerts = new HashSet<X509Extension>();
                                EList x509s = collectionStore.getX509Certificates();
                                kMax = x509s.size();
                                for (k = 0; k < kMax; ++k) {
                                    X509Certificate x509 = (X509Certificate)x509s.get(k);
                                    String path = null;
                                    path = varMap == null ? ConfigUtil.trim((String)x509.getPath()) : varMap.expand(ConfigUtil.trim((String)x509.getPath()));
                                    String provider2 = "";
                                    CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                    if (cfac == null) {
                                        cfac = ConfigUtil.createCertificateFactory((String)provider2);
                                        cache.put(provider2, cfac);
                                    }
                                    File f = new File(path);
                                    eeCerts.add(ConfigUtil.getX509Certificate((File)f, (CertificateFactory)cfac));
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Adding the X509 certificate: " + path);
                                }
                                EList crls = collectionStore.getCRL();
                                kMax = crls.size();
                                for (k = 0; k < kMax; ++k) {
                                    CRL crl = (CRL)crls.get(k);
                                    String path = null;
                                    path = varMap == null ? ConfigUtil.trim((String)crl.getPath()) : varMap.expand(ConfigUtil.trim((String)crl.getPath()));
                                    String provider2 = "";
                                    CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                    if (cfac == null) {
                                        cfac = ConfigUtil.createCertificateFactory((String)provider2);
                                        cache.put(provider2, cfac);
                                    }
                                    File f = new File(path);
                                    eeCerts.add(ConfigUtil.getX509CRL((File)f, (CertificateFactory)cfac));
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Adding the X509 CRL: " + path);
                                }
                                String algorithm = "Collection";
                                CollectionCertStoreParameters cparams = null;
                                try {
                                    cparams = new CollectionCertStoreParameters(eeCerts);
                                    certStore = null;
                                    certStore = provider == null ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                    certStores.add(certStore);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found CertStore for " + value);
                                    }
                                    certStoreFound = true;
                                    break;
                                }
                                catch (NoSuchAlgorithmException e) {
                                    msgKey = "security.wssecurity.CommonReceiverConfig.s20";
                                    Tr.error(tc, msgKey, new Object[]{algorithm});
                                    throw SoapSecurityException.format(msgKey, algorithm, (Throwable)e);
                                }
                                catch (InvalidAlgorithmParameterException e) {
                                    msgKey = "security.wssecurity.CommonReceiverConfig.s21";
                                    Tr.error(tc, msgKey, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                    throw SoapSecurityException.format(msgKey, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                                }
                                catch (Throwable e) {
                                    msgKey = "security.wssecurity.load.collectioncertstore.failed";
                                    Tr.error(tc, msgKey, new Object[]{collectionStore.getName(), e});
                                    throw SoapSecurityException.format(msgKey, collectionStore.getName(), e);
                                }
                            }
                            if (!certStoreFound) {
                                EList ldapCertStores = certStoreList.getLdapCertStores();
                                int length = ldapCertStores.size();
                                for (j = 0; j < length; ++j) {
                                    int port;
                                    LDAPCertStore ldapCertStore = (LDAPCertStore)ldapCertStores.get(j);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "ldapCertStores.get(" + j + ") = " + ldapCertStore.getName());
                                    }
                                    if (value == null || !value.equals(ConfigUtil.trim((String)ldapCertStore.getName()))) continue;
                                    LDAPServer ldapServer = ldapCertStore.getLdapServer();
                                    String host = ConfigUtil.trim((String)ldapServer.getHost());
                                    try {
                                        port = Integer.parseInt(ldapServer.getPort());
                                    }
                                    catch (NumberFormatException e) {
                                        String msgKey = "security.wssecurity.CommonReceiverConfig.s19";
                                        String arg = ldapServer.getPort();
                                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestGeneratorConfig", "997", this);
                                        Tr.error(tc, msgKey, arg);
                                        throw SoapSecurityException.format(msgKey, arg, (Throwable)e);
                                    }
                                    String algorithm = "LDAP";
                                    provider = Security.getProvider(ConfigUtil.trim((String)ldapCertStore.getProvider()));
                                    LDAPCertStoreParameters ldapParams = new LDAPCertStoreParameters(host, port);
                                    try {
                                        certStore = provider == null ? CertStore.getInstance(algorithm, ldapParams) : CertStore.getInstance(algorithm, (CertStoreParameters)ldapParams, provider);
                                    }
                                    catch (NoSuchAlgorithmException e) {
                                        String msgKey = "security.wssecurity.CommonReceiverConfig.s20";
                                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestGeneratorConfig", "1014", this);
                                        Tr.error(tc, msgKey, algorithm);
                                        throw SoapSecurityException.format(msgKey, algorithm);
                                    }
                                    catch (InvalidAlgorithmParameterException e) {
                                        String msgKey = "security.wssecurity.CommonReceiverConfig.s21";
                                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestGeneratorConfig", "1019", this);
                                        Tr.error(tc, msgKey, ldapParams.toString());
                                        throw SoapSecurityException.format(msgKey, ldapParams.toString());
                                    }
                                    certStores.add(certStore);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found CertStore for " + value);
                                    }
                                    certStoreFound = true;
                                    break;
                                }
                            }
                        }
                        if (!certStoreFound && value != null && config != null) {
                            Object cs = config.getWSCertStore(value);
                            if (cs == null) {
                                String msgKey = "security.wssecurity.ConfigValidation.csref.notfound";
                                Tr.error(tc, msgKey, new Object[]{value});
                                throw SoapSecurityException.format(msgKey, value);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found CertStore for " + value);
                            }
                            certStores.add(cs);
                        }
                    }
                    tconfig._provider = provider;
                    tconfig._certStores = certStores;
                }
                ConfigConstants.getProperties(tconfig._properties, tokenGenerator.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tconfig._className);
                if (appClassLoader != null) {
                    type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", appClassLoader);
                }
                HashMap properties = new HashMap();
                try {
                    tconfig._instance = (TokenGeneratorComponent)factory.createGenerator(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{tconfig._className});
                }
                this._tokenGenerators.add(tconfig);
                value = ConfigUtil.trim((String)tokenGenerator.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (nameToken.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: token generator [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token generator: " + value);
                }
                nameToken.put(value, tconfig);
                tconfig._name = value;
            }
        }
        if (keyLocators != null) {
            iMax = keyLocators.size();
            for (i = 0; i < iMax; ++i) {
                KeyLocator keyLocator = (KeyLocator)keyLocators.get(i);
                PrivateCommonConfig.KeyLocatorConfImpl klconfig = new PrivateCommonConfig.KeyLocatorConfImpl();
                klconfig._className = ConfigUtil.trim((String)keyLocator.getClassname());
                if ("com.ibm.wsspi.wssecurity.keyinfo.X509TokenKeyLocator".equals(klconfig._className)) {
                    throw new SoapSecurityException("The " + klconfig._className + " key locator cannot be used in the request generator. It can only be used on the consumer side.");
                }
                if (!this._defaultKeyLocators.contains(klconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                KeyStore keystore = keyLocator.getKeyStore();
                String keyStoreName2 = null;
                if (keystore != null) {
                    ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                    ksconfig._type = ConfigUtil.trim((String)keystore.getType());
                    ksconfig._path = varMap == null ? ConfigUtil.trim((String)keystore.getPath()) : varMap.expand(ConfigUtil.trim((String)keystore.getPath()));
                    ksconfig._password = ConfigUtil.trim((String)keystore.getStorepass());
                    keyStoreName2 = ksconfig._ksRef = ConfigUtil.trim((String)keystore.getKeyStoreRef());
                    klconfig._keyStore = ksconfig;
                }
                if (keyStoreName2 != null && keyStoreName2.length() != 0) {
                    klconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName2);
                }
                EList keys = keyLocator.getKeys();
                jMax = keys.size();
                for (j = 0; j < jMax; ++j) {
                    Key key = (Key)keys.get(j);
                    kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                    kiconfig._alias = ConfigUtil.trim((String)key.getAlias());
                    kiconfig._keypass = ConfigUtil.trim((String)key.getKeypass());
                    kiconfig._name = ConfigUtil.trim((String)key.getName());
                    klconfig._keyInformationList.add(kiconfig);
                }
                ConfigConstants.getProperties(klconfig._properties, keyLocator.getProperties(), varMap);
                value = ConfigUtil.trim((String)keyLocator.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s27");
                }
                if (nameKeyLocator.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key locator [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key locator: " + value);
                }
                nameKeyLocator.put(value, klconfig);
            }
        }
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (i = 0; i < iMax; ++i) {
                TokenReference tokenReference;
                KeyInfo keyInfo = (KeyInfo)keyInfos.get(i);
                kicgconfig = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
                kicgconfig._className = ConfigUtil.trim((String)keyInfo.getClassname());
                boolean defaultSystemKeyInfoGenerator = true;
                boolean ksExist = false;
                if (!this._defaultKeyInfoContentGenerators.contains(kicgconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                    defaultSystemKeyInfoGenerator = false;
                }
                kicgconfig._keyInfoType = ConfigUtil.trim((String)keyInfo.getType());
                KeyLocatorMapping keyLocatorMapping = keyInfo.getKeyLocatorMapping();
                if (keyLocatorMapping != null) {
                    value = ConfigUtil.trim((String)keyLocatorMapping.getLocatorRef());
                    if (value != null && value.length() > 0) {
                        PrivateCommonConfig.KeyLocatorConfImpl klConf = (PrivateCommonConfig.KeyLocatorConfImpl)nameKeyLocator.get(value);
                        if (klConf != null) {
                            kicgconfig._keyLocator = new KeyLocatorProxy(klConf).getKeyLocator6(appClassLoader);
                            keyStoreName = (String)klConf._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                            if (keyStoreName != null) {
                                kicgconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                                ksExist = true;
                            }
                        } else if (config != null) {
                            KeyLocatorProxy klproxy = config.getKeyLocator(value);
                            if (klproxy == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            kicgconfig._keyLocator = klproxy.getKeyLocator6(appClassLoader);
                            klConf = (PrivateCommonConfig.KeyLocatorConfImpl)klproxy.getKeyLocatorConfig();
                            if (klConf != null && (keyStoreName = (String)klConf._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef")) != null && keyStoreName.length() != 0) {
                                kicgconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                                ksExist = true;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key locator mapping: " + value);
                        }
                    }
                    kicgconfig._keyName = ConfigUtil.trim((String)keyLocatorMapping.getKeynameRef());
                }
                if ((tokenReference = keyInfo.getTokenReference()) != null) {
                    value = ConfigUtil.trim((String)tokenReference.getTokenRef());
                    if (value != null && value.length() > 0) {
                        kicgconfig._tokenGenerator = (PrivateGeneratorConfig.TokenGeneratorConfImpl)nameToken.get(value);
                        if (kicgconfig._tokenGenerator == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the token reference: " + value);
                        }
                        if (!ksExist) {
                            tconfig = kicgconfig._tokenGenerator;
                            String ksRef = (String)tconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                            if (ksRef != null) {
                                kicgconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksRef);
                            }
                        }
                    } else if (kicgconfig._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                    }
                } else if (kicgconfig._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                }
                ConfigConstants.getProperties(kicgconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", kicgconfig._className);
                if (kicgconfig._className == null || kicgconfig._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyInfoContentGenerator classname = " + kicgconfig._className);
                }
                if (defaultSystemKeyInfoGenerator) {
                    type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (appClassLoader != null) {
                    type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", appClassLoader);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClassLoader used = " + type.get("com.ibm.wsspi.wssecurity.core.wssfactory.classloader"));
                }
                HashMap properties = new HashMap();
                try {
                    kicgconfig._instance = (KeyInfoContentGeneratorComponent)factory.createGenerator(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{kicgconfig._className});
                }
                value = ConfigUtil.trim((String)keyInfo.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (nameKeyInfo.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key info [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + value);
                }
                nameKeyInfo.put(value, kicgconfig);
            }
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (i = 0; i < iMax; ++i) {
                PartReference pref;
                EncryptionKeyInfo encryptionKey;
                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(i);
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl econfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                DataEncryptionMethod dataEncryption = encryptionInfo.getEncryptionMethod();
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = ConfigUtil.trim((String)dataEncryption.getAlgorithm());
                ConfigConstants.getProperties(aconfig._properties, dataEncryption.getProperties(), varMap);
                econfig._dataEncryptionMethod = aconfig;
                KeyEncryptionMethod keyEncryption = encryptionInfo.getKeyEncryptionMethod();
                if (keyEncryption != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)keyEncryption.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, keyEncryption.getProperties(), varMap);
                    econfig._keyEncryptionMethod = aconfig;
                }
                kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                String keyStoreName3 = null;
                EList encryptionKeys = encryptionInfo.getEncryptionKeyInfo();
                if (encryptionKeys != null && encryptionKeys.size() == 1 && (value = ConfigUtil.trim((String)(encryptionKey = (EncryptionKeyInfo)encryptionKeys.get(0)).getKeyinfoRef())) != null && value.length() > 0) {
                    kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameKeyInfo.get(value);
                    if (kicgconfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    keyStoreName3 = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    tconfig = kicgconfig._tokenGenerator;
                    if (tconfig != null) {
                        tconfig._usedForEncryption = true;
                    }
                    kigconfig._contentGenerator = kicgconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                econfig._encryptionKeyInfo = kigconfig;
                if (keyStoreName3 != null && ConfigUtil.isHWKeyStore(keyStoreName3)) {
                    econfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hardware KeyStore is selected : " + keyStoreName3);
                    }
                }
                if ((pref = encryptionInfo.getPartReference()) != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(value);
                    if (econfig._reference == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                j = ConfigUtil.getPosition(order, (ReferencePartConfig)econfig._reference);
                ConfigUtil.insertGenerator((List)this._operationGenerators, order, (int)j, (Configuration)econfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption generator.");
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (i = 0; i < iMax; ++i) {
                EList prefs;
                SigningKeyInfo signingKey;
                SigningInfo signingInfo = (SigningInfo)signingInfos.get(i);
                PrivateGeneratorConfig.SignatureGeneratorConfImpl sconfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                CanonicalizationMethod c14n = signingInfo.getCanonicalizationMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)c14n.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, c14n.getProperties(), varMap);
                    sconfig._canonicalizationMethod = aconfig;
                }
                SignatureMethod signature = signingInfo.getSignatureMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)signature.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, signature.getProperties(), varMap);
                    sconfig._signatureMethod = aconfig;
                }
                KeyInfoSignature kiSignature = signingInfo.getKeyInfoSignature();
                if (kiSignature != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)kiSignature.getType());
                    ConfigConstants.getProperties(aconfig._properties, kiSignature.getProperties(), varMap);
                    sconfig._keyInfoSignature = aconfig;
                }
                kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                EList signingKeys = signingInfo.getSigningKeyInfo();
                keyStoreName = null;
                if ((signingKeys != null || signingKeys.size() == 1) && (value = ConfigUtil.trim((String)(signingKey = (SigningKeyInfo)signingKeys.get(0)).getKeyinfoRef())) != null && value.length() > 0) {
                    kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameKeyInfo.get(value);
                    if (kicgconfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    tconfig = kicgconfig._tokenGenerator;
                    if (tconfig != null) {
                        tconfig._usedForSignature = true;
                    }
                    kigconfig._contentGenerator = kicgconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                sconfig._signingKeyInfo = kigconfig;
                if (keyStoreName != null && ConfigUtil.isHWKeyStore(keyStoreName)) {
                    sconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hardware KeyStore is selected: " + keyStoreName);
                    }
                }
                if ((prefs = signingInfo.getPartReference()) != null) {
                    jMax = prefs.size();
                    for (j = 0; j < jMax; ++j) {
                        DigestMethod digest;
                        PartReference pref = (PartReference)prefs.get(j);
                        PrivateCommonConfig.SigningReferenceConfImpl srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        value = ConfigUtil.trim((String)pref.getPart());
                        if (value != null && value.length() > 0) {
                            srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(value);
                            if (srconfig._reference == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + value);
                            }
                        }
                        if ((digest = pref.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = ConfigUtil.trim((String)digest.getAlgorithm());
                            ConfigConstants.getProperties(aconfig._properties, digest.getProperties(), varMap);
                            srconfig._digestMethod = aconfig;
                        }
                        EList transforms = pref.getTransform();
                        if (transforms != null) {
                            kMax = transforms.size();
                            for (k = 0; k < kMax; ++k) {
                                Transform transform = (Transform)transforms.get(k);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = ConfigUtil.trim((String)transform.getAlgorithm());
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(aconfig._algorithm)) {
                                    srconfig._transforms.add(0, aconfig);
                                    continue;
                                }
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                    }
                }
                sconfig.putInclusiveNsProperty(this._properties);
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                j = ConfigUtil.getMinimumPosition(order, (List)sconfig._references);
                ConfigUtil.insertGenerator((List)this._operationGenerators, order, (int)j, (Configuration)sconfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature generator.");
            }
        }
        this.validate();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties(defaultProps, extProperties, bndProperties, "request"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(SecurityRequestGeneratorBindingConfig, SecurityRequestGeneratorServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader)");
        }
    }

    private final void initDefaultConfig(WSSGeneratorConfig dgconfig, Map nameToken, List order) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSGeneratorConfig, Map, List):", new Object[]{dgconfig, nameToken, order});
        }
        HashMap<QName, PrivateGeneratorConfig.TokenGeneratorConfImpl> key2obj = new HashMap<QName, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
        for (Object obj : nameToken.values()) {
            if (!(obj instanceof PrivateGeneratorConfig.TokenGeneratorConfImpl)) continue;
            PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)obj;
            key2obj.put(tconfig.getType(), tconfig);
        }
        Set set = dgconfig.getTokenGenerators();
        Iterator<Object> i = set.iterator();
        while (i.hasNext()) {
            PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig2 = new PrivateGeneratorConfig.TokenGeneratorConfImpl((PrivateGeneratorConfig.TokenGeneratorConfImpl)i.next());
            PrivateGeneratorConfig.TokenGeneratorConfImpl tc2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)key2obj.get(tconfig2.getType());
            if (tc2 != null) {
                tconfig2._standAlone = tc2._standAlone;
            }
            this._tokenGenerators.add(tconfig2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_tokenGenerators =" + this._tokenGenerators);
        }
        List list = dgconfig.getOperationGenerators();
        for (Object obj : list) {
            int pos;
            if (obj instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl econfig = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)obj;
                Iterator j = this._confidentialParts.iterator();
                if (j.hasNext()) {
                    econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)j.next();
                }
                pos = ConfigUtil.getPosition((List)order, (ReferencePartConfig)econfig._reference);
                ConfigUtil.insertGenerator((List)this._operationGenerators, (List)order, (int)pos, (Configuration)econfig);
                continue;
            }
            PrivateGeneratorConfig.SignatureGeneratorConfImpl sconfig = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)obj;
            for (PrivateCommonConfig.SigningReferenceConfImpl srconfig : sconfig._references) {
                Iterator k = this._integralParts.iterator();
                if (!k.hasNext()) continue;
                srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)k.next();
            }
            pos = ConfigUtil.getMinimumPosition((List)order, (List)sconfig._references);
            ConfigUtil.insertGenerator((List)this._operationGenerators, (List)order, (int)pos, (Configuration)sconfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDefaultConfig(WSSConsumerConfig, Map, List)");
        }
    }

    final String getOrigin() {
        return this.origin;
    }
}

