/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.util.CORBAHelper;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public class GlobalSecurityResponseHandler
extends GenericHandler
implements SystemHandler {
    private Map configMap;
    private boolean isServer = true;
    private static final TraceComponent tc = Tr.register(GlobalSecurityResponseHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public GlobalSecurityResponseHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GlobalSecurityResponseHandler()");
            Tr.exit(tc, "GlobalSecurityResponseHandler()");
        }
    }

    public void init(HandlerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        super.init(info);
        this.configMap = info.getHandlerConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigMap=" + this.configMap);
        }
        if (this.configMap != null) {
            this.isServer = this.configMap.get(HANDLER_PARAM_ROLE).equals(HANDLER_PARAM_ROLE_SERVER);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public boolean handleRequest(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    private boolean cleanUp(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUp", context);
        }
        if (this.isServer) {
            Exception e1 = null;
            try {
                CORBAHelper.popCredential((com.ibm.ws.webservices.engine.MessageContext)context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed credential from the thread");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception: ", e);
                }
                e1 = e;
            }
            JAXRPCException e2 = null;
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (ctxMgr == null) {
                e2 = new JAXRPCException(ConfigConstants.getMessage("security.wssecurity.ctxmgr.isnull"));
            } else {
                Subject s1 = (Subject)ctxMgr.put("wssecurity.initial.sender.id", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Sender Removed", s1);
                }
                X509Certificate certX509 = (X509Certificate)ctxMgr.put("com.ibm.ws.wssecurity.OriginalCert", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Sender Certificate Removed", certX509);
                }
            }
            Exception e3 = null;
            if (e2 == null) {
                try {
                    String str;
                    Subject s1 = (Subject)context.getProperty("com.ibm.ws.webservices.wssecurity.constants.callerSubject");
                    ctxMgr.setCallerSubject(s1);
                    if (tc.isDebugEnabled()) {
                        str = s1 == null ? "null" : "not null";
                        Tr.debug(tc, "Restored the caller subject [" + str + "]");
                    }
                    s1 = (Subject)context.getProperty("com.ibm.ws.webservices.wssecurity.constants.invocationSubject");
                    ctxMgr.setInvocationSubject(s1);
                    if (tc.isDebugEnabled()) {
                        str = s1 == null ? "null" : "not null";
                        Tr.debug(tc, "Restored the invocation subject [" + str + "]");
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception: ", e);
                    }
                    e3 = e;
                }
            }
            if (e1 != null) {
                throw new JAXRPCException(e1.getMessage(), e1);
            }
            if (e2 != null) {
                throw e2;
            }
            if (e3 != null) {
                throw new JAXRPCException(e3.getMessage(), e3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUp", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", context);
        }
        this.cleanUp(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse", Boolean.TRUE);
        }
        return true;
    }

    public void handleClosure(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleClosure", context);
        }
        this.cleanUp(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleClosure", Boolean.TRUE);
        }
    }

    public boolean handleFault(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", context);
        }
        this.cleanUp(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault", Boolean.TRUE);
        }
        return true;
    }

    public void preHandleIncoming(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preHandleIncoming", context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preHandleIncoming");
        }
    }
}

