/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.enc;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.DecryptionResult;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DecryptedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(DecryptedPartChecker.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DecryptedPartChecker.class.getName();
    private Map _selectors = null;
    private IDResolver _idResolver = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.VerifiedPartChecker.s05");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        Document doc = null;
        doc = target.getNodeType() == 9 ? (Document)target : target.getOwnerDocument();
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        NonceManager nmanager = gconfig.getNonceManager();
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put(NonceManager.class, nmanager);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", this._idResolver);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.config", gconfig.getTokenConsumers());
        Set requiredParts = DecryptedPartChecker.preprocess(doc, gconfig.getRequiredConfidentialParts(), this._selectors, selectorMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Processing the decrypted results...");
        }
        Result[] results = ResultPool.get((Map)context, DecryptionResult.class);
        HashSet<ReferencePartConfig> rset = new HashSet<ReferencePartConfig>();
        if (results != null && results.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(results.length + " decrypted results found."));
            }
            for (int i = 0; i < results.length; ++i) {
                DecryptionResult result = (DecryptionResult)results[i];
                rset.clear();
                for (DecryptionResult.DecryptedPart dpart : result._decryptedParts) {
                    RequiredPart rpart = DecryptedPartChecker.getRelatedPart(result, dpart, requiredParts);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("DecryptedPart [" + dpart + "], RequiredPart [" + rpart + "]"));
                    }
                    if (rpart == null) continue;
                    if (rpart._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking required nonce...");
                        }
                        if (dpart._nonce == null) {
                            String expression = rpart._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", expression);
                        }
                        NonceUtil.checkNonce(dpart._nonce, nsWsse, nmanager);
                    }
                    if (rpart._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking required timestamp...");
                        }
                        if (dpart._timestamp == null) {
                            String expression = rpart._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s03", expression);
                        }
                        NonceUtil.checkTimestamp(dpart._timestamp, nsWsu, gconfig.getTimestampMaxAge(), gconfig.getTimestampClockSkew(), false);
                    }
                    rpart._processed = true;
                    rpart._tokens.add(result._token);
                    rset.add(rpart._rconfig);
                }
                DecryptedPartChecker.checkCaller(result, rset, gconfig, context);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking whether all required confidentiality is processed...");
        }
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] rpart = rparts._parts;
            for (int j = 0; j < rpart.length; ++j) {
                String usage = rpart[j]._pconfig.getUsage();
                String keyword = rpart[j]._pconfig.getKeyword();
                if (!rpart[j]._processed) {
                    if (ConfigUtil.isUsageRequired((String)usage)) {
                        throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.DecryptedPartChecker.s01", keyword);
                    }
                    if (!ConfigUtil.isUsageOptional((String)usage) && !ConfigUtil.isUsageObserved((String)usage) || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Optionally encrypted message part [" + keyword + "] is not encrypted."));
                    continue;
                }
                if (!ConfigUtil.isUsageRejected((String)usage)) continue;
                throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.DecryptedPartChecker.s02", keyword);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static Set preprocess(Document doc, Set requiredConfidentiality, Map selectors, Map selectorMap) throws SoapSecurityException {
        RequiredPart rpart;
        int k;
        Element el;
        int j;
        boolean found;
        String keyword;
        String dialect;
        PartList parts;
        Map cpSelectorMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("preprocess(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Set requiredConfidentiality[" + requiredConfidentiality + "]," + "Set selectors," + "Map selectorMap)"));
        }
        HashSet<RequiredParts> requiredParts = new HashSet<RequiredParts>();
        HashSet<ReferencePartConfig.PartConfig> nonces = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap nonces2 = new HashMap();
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> nonces3 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
        for (ReferencePartConfig rconfig : requiredConfidentiality) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing ReferencePartConfig [" + rconfig + "]..."));
            }
            cpSelectorMap = new HashMap(selectorMap);
            for (ReferencePartConfig.PartConfig pconfig : rconfig.getParts()) {
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    nonces.add(pconfig);
                    nonces2.put(pconfig, cpSelectorMap);
                    nonces3.put(pconfig, rconfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing PartConfig [" + pconfig + "]..."));
                }
                if ((parts = (PartList)SignatureGenerator.getMessagePart(doc, dialect = pconfig.getDialect(), keyword = pconfig.getKeyword(), "decryption_mode", selectors, ConfidentialDialectElementSelector.class, cpSelectorMap)) != null && parts.getLength() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                    }
                    found = false;
                    for (j = 0; j < parts.getLength(); ++j) {
                        RequiredParts rparts2;
                        el = (Element)parts.item(j);
                        block3: for (RequiredParts rparts2 : requiredParts) {
                            for (k = 0; k < rparts2._parts.length; ++k) {
                                rpart = rparts2._parts[k];
                                if (!DOMUtil.equals((Node)el, (Node)rpart._element)) continue;
                                found = true;
                                continue block3;
                            }
                        }
                        if (found) continue;
                        RequiredPart[] rpartList = new RequiredPart[]{new RequiredPart(rconfig, pconfig, el)};
                        rparts2 = new RequiredParts(rpartList, parts.getType());
                        requiredParts.add(rparts2);
                    }
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
            }
        }
        for (ReferencePartConfig.PartConfig pconfig : nonces) {
            ReferencePartConfig rconfig;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing PartConfig [" + pconfig + "]..."));
            }
            cpSelectorMap = (Map)nonces2.get(pconfig);
            rconfig = (ReferencePartConfig)nonces3.get(pconfig);
            if (!pconfig.isTimestamp() && !pconfig.isNonce()) continue;
            dialect = pconfig.getDialect();
            keyword = pconfig.getKeyword();
            parts = (PartList)SignatureGenerator.getNoncePart(doc, null, pconfig, "decryption_mode", selectors, ConfidentialDialectElementSelector.class, cpSelectorMap);
            if (parts != null && parts.getLength() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                }
                found = false;
                for (j = 0; j < parts.getLength(); ++j) {
                    el = (Element)parts.item(j);
                    block7: for (RequiredParts rparts2 : requiredParts) {
                        for (k = 0; k < rparts2._parts.length; ++k) {
                            rpart = rparts2._parts[k];
                            if (!DOMUtil.equals((Node)el, (Node)rpart._element)) continue;
                            if (pconfig.isTimestamp()) {
                                rpart._requiredTimestamp = pconfig.isTimestamp();
                            }
                            if (pconfig.isNonce()) {
                                rpart._requiredNonce = pconfig.isNonce();
                            }
                            found = true;
                            continue block7;
                        }
                    }
                    if (found) continue;
                    throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
                }
                continue;
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("preprocess(Document doc,Set requiredConfidentiality,Set selectors,Map selectorMap) returns Set[" + requiredParts + "]"));
        }
        return requiredParts;
    }

    private static RequiredPart getRelatedPart(DecryptionResult dresult, DecryptionResult.DecryptedPart dpart, Set requiredParts) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRelatedPart(DecryptionResult dresult,DecryptedPart dpart[" + dpart + "]," + "Set requiredParts[" + requiredParts + "])"));
        }
        SoapSecurityException lastException = null;
        RequiredPart rpart = null;
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] part = rparts._parts;
            for (int j = 0; j < part.length; ++j) {
                if (part[j]._processed) continue;
                SoapSecurityException sse = DecryptedPartChecker.checkBinding(part[j]._rconfig.getBindings(), dresult);
                if (sse == null) {
                    if (!DecryptedPartChecker.hasSameUri(part[j]._element, dpart._object) && !DOMUtil.equals((Node)part[j]._element, (Node)dpart._object)) continue;
                    rpart = part[j];
                    break;
                }
                lastException = sse;
            }
            if (rpart == null) continue;
            lastException = null;
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRelatedPart(DecryptionResult dresult,DecryptedPart dpart,Set requiredParts) returns RequiredPart[" + rpart + "]"));
        }
        return rpart;
    }

    private static boolean hasSameUri(Element rpart, Element dpart) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("hasSameUri(Element rpart[" + DOMUtil.getDisplayName((Node)rpart) + "]," + "Element dpart[" + DOMUtil.getDisplayName((Node)dpart) + "])"));
        }
        boolean ret = false;
        String ruri = IdUtil.getInstance().getId(rpart);
        String duri = IdUtil.getInstance().getId(dpart);
        if (ruri != null && ruri.length() > 0 && duri != null && duri.length() > 0 && ruri.equals(duri)) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("hasSameUri(Element rpart,Element dpart) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    private static void checkCaller(DecryptionResult dresult, Set rpconfigs, WSSConsumerConfig gconfig, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCaller(DecryptionResult vresult[" + dresult + "]," + "Set rpconfigs[" + rpconfigs + "]," + "WSSConsumerConfig gconfig," + "Map context)"));
        }
        Set cconfigs = gconfig.getCallers();
        boolean isOK = true;
        if (cconfigs != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(cconfigs.size() + " Callers found, so start to process it..."));
            }
            if (dresult._token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The token used for decryption not found...");
                }
            } else {
                boolean trusted = dresult._token.isTrusted();
                for (WSSConsumerConfig.CallerConfig cconfig : cconfigs) {
                    if (!trusted) {
                        QName qn = cconfig.getTokenType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Checking the value type of the caller[" + qn + "]"));
                        }
                        if (qn != null && !qn.equals(dresult._token.getType())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("The value types are different: Caller config[" + qn + "] and decrypted result[" + dresult._token.getType() + "]"));
                            }
                            isOK = false;
                        }
                        if (isOK) {
                            ReferencePartConfig rpconfig = cconfig.getPart();
                            if (rpconfig == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ReferencePart of Caller config is null.");
                                }
                            } else if (rpconfig.isOneOfIntegralParts()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ReferencePart of Caller config is not confidential part.");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Checking the ReferencePart of Caller config[" + rpconfig + "]"));
                                }
                                if (rpconfigs.contains(rpconfig)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Linked the token[" + dresult._token + "] and the Caller[" + cconfig + "]."));
                                    }
                                    AuthResult aresult = new AuthResult(dresult._token, cconfig);
                                    ResultPool.add((Map)context, (Result)aresult);
                                }
                            }
                        }
                    }
                    isOK = true;
                    WSSConsumerConfig.CallerConfig tmconfig = cconfig.getTrustMethod();
                    if (tmconfig == null || !trusted) continue;
                    QName qn = tmconfig.getTokenType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the value type of the TrustMethod[" + qn + "]"));
                    }
                    if (qn != null && !qn.equals(dresult._token.getType())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The value types are different: TrustMethod config[" + qn + "] and decrypted result[" + dresult._token.getType() + "]"));
                        }
                        isOK = false;
                    }
                    if (!isOK) continue;
                    ReferencePartConfig rpconfig = tmconfig.getPart();
                    if (rpconfig == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ReferencePart of TrustMethod config is null.");
                        continue;
                    }
                    if (rpconfig.isOneOfIntegralParts()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ReferencePart of TrustMethod config is not confidential part.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the ReferencePart of TrustMethod config[" + rpconfig + "]"));
                    }
                    if (!rpconfigs.contains(rpconfig)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Linked the token [" + dresult._token + "] and the TrustMethod [" + tmconfig + "]."));
                    }
                    AuthResult aresult = new AuthResult(dresult._token, tmconfig);
                    ResultPool.add((Map)context, (Result)aresult);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Document doc,DecryptionResult dresult,WSSConsumerConfig gconfig,Map selectors,Map context)");
        }
    }

    private static SoapSecurityException checkBinding(Set bindings, DecryptionResult dresult) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkBinding(Set bindings[" + bindings + "]," + "DecryptionResult dresult[" + dresult + "])"));
        }
        Throwable lastException = null;
        boolean ret = bindings.contains(dresult._config);
        if (ret) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The configuration of encryption consumer used for decryption was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The configuration of encryption consumer used for decryption was NOT found in the bindings.");
            }
            Iterator i = bindings.iterator();
            while (!ret && i.hasNext()) {
                EncryptionConsumerConfig config = (EncryptionConsumerConfig)i.next();
                KeyInfoResult r = (KeyInfoResult)dresult._identities.get(config);
                if (r == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"There is no keyinfo result corresponding to the EncryptionConsumerConfig.");
                    continue;
                }
                Exception e = r.getError();
                if (e == null) {
                    Token t;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The keyinfo result has no exception.");
                    }
                    if ((t = (Token)dresult._kresults.get(r)) == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"There is no token corresponding to the keyinfo result.");
                        continue;
                    }
                    if (t.getError() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The token [" + t + "] has no exception."));
                        }
                        ret = true;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The token [" + t + "] has the exception [" + e.getMessage() + "]."));
                    }
                    lastException = t.getError();
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The keyinfo result has the exception [" + e.getMessage() + "]."));
                }
                if (e instanceof SoapSecurityException) {
                    lastException = (SoapSecurityException)e;
                    continue;
                }
                lastException = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", e);
            }
            if (ret) {
                lastException = null;
            }
        }
        if (tc.isEntryEnabled()) {
            String exMes = lastException == null ? "null" : lastException.toString();
            Tr.exit((TraceComponent)tc, (String)("checkBinding(Set bindings,DecryptionResult dresult) returns SoapSecurityException[" + exMes + "]"));
        }
        return lastException;
    }

    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private Element _element;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private Set _tokens;
        private boolean _processed;

        RequiredPart(ReferencePartConfig rconfig, ReferencePartConfig.PartConfig pconfig, Element element) {
            this._rconfig = rconfig;
            this._pconfig = pconfig;
            this._element = element;
            this._tokens = new HashSet();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;
        private String _type;

        RequiredParts(RequiredPart[] parts, String type) {
            this._parts = parts;
            this._type = type;
        }
    }
}

