/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.XMLDecryptionTransformer2;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDecryptionTransformer
extends XMLDecryptionTransformer2 {
    private static final TraceComponent tc = Tr.register(XMLDecryptionTransformer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDecryptionTransformer.class.getName();
    private String _nsWsse;
    private String _nsWsu;

    public void transform(TransformContext context) throws TransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("transform(TransformContext context[" + context + "])"));
        }
        super.transform(context);
        SignatureContext scontext = context.getSignatureContext();
        if (scontext instanceof WSSSignatureContext) {
            WSSSignatureContext wsssc = (WSSSignatureContext)scontext;
            int wssVersion = wsssc.getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][wssVersion];
            this._nsWsu = Constants.NAMESPACES[1][wssVersion];
        }
        NodeList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset((Node)context.getDocument(), null, (boolean)true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset((Node)context.getNode(), null, (boolean)true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        if (nl != null) {
            nl = this.removeNonce(nl, this._nsWsse, this._nsWsu);
        }
        context.setContent(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"transform(TransformContext context)");
        }
    }

    private NodeList removeNonce(NodeList nl, String nsWsse, String nsWsu) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeNonce(NodeList nl[" + nl + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        int iLast = nl.getLength();
        for (int i = 0; i < iLast; ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                Element el = (Element)node;
                if (DOMUtil.equals((Node)node, (String)nsWsse, (String)"Nonce")) {
                    if ("weenc".equals(el.getAttribute("wasextention"))) {
                        i = this.removeNodes(nl, i + 1, el);
                        continue;
                    }
                } else if (DOMUtil.equals((Node)node, (String)nsWsu, (String)"Timestamp") && "weenc".equals(el.getAttribute("wasextention"))) {
                    i = this.removeNodes(nl, i + 1, el);
                    continue;
                }
            }
            list.add(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeNonce(NodeList nl,String nsWsse,String nsWsu) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private int removeNodes(NodeList nl, int start, Node root) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeNodes(NodeList nl[" + nl + "]," + "int start[" + start + "]," + "Node root[" + DOMUtil.getDisplayName((Node)root) + "])"));
        }
        boolean finish = false;
        int iLast = nl.getLength();
        for (i = start; i < iLast; ++i) {
            Node node = nl.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    if (node.getParentNode().equals(root)) {
                        i = this.removeNodes(nl, i + 1, node);
                        break;
                    }
                    finish = true;
                }
            }
            if (finish) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNodes(NodeList nl,int start,Node root)");
        }
        return i - 1;
    }
}

