/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ExclusiveCanonicalizer {
    private static final boolean DEBUG = false;

    private ExclusiveCanonicalizer() {
    }

    public static void serializeSubset(Hashtable prefixList, NodeList nodeList, boolean withComments, Map replNodeSets, Writer wr) throws IOException {
        ExclusiveCanonicalizer.serializeSubset(prefixList, nodeList, withComments, replNodeSets, wr, null);
    }

    private static void serializeSubset(Hashtable prefixList, NodeList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node = nodeList.item(i);
            if (replNodeSets.containsKey(node)) {
                nodeVector.add(new Canonicalizer.ReplacedNode(node));
                int l = nodeList.getLength();
                for (int j = i + 1; j <= l; ++j) {
                    if (j < l && DOMUtil.isDescendantNode((Node)nodeList.item(j), (Node)node)) continue;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (node.getNodeType() != 2) {
                Node attr;
                nodeVector.addElement(node);
                if (node.getNodeType() != 1) continue;
                Hashtable<String, Node> attributes = new Hashtable<String, Node>();
                if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                    ++i;
                    while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && node == ((Attr)node2).getOwnerElement()) {
                        attributes.put(node2.getNodeName(), node2);
                        ++i;
                    }
                    if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                        attributes.remove("xmlns");
                    }
                    --i;
                }
                nodeVector.addElement(new Canonicalizer.Attributes(node, attributes));
                continue;
            }
            Element owner = ((Attr)node).getOwnerElement();
            Hashtable<String, Node> attributes = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && owner == ((Attr)node2).getOwnerElement()) {
                attributes.put(node2.getNodeName(), node2);
                ++i;
            }
            nodeVector.addElement(new Canonicalizer.Attributes(owner, attributes));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            ExclusiveCanonicalizer.serializeSubset(stack, prefixList, nodeVector, i, withComments, replNodeSets, wr, apexNodes);
        }
    }

    private static void serializeSubset(Stack stack, Hashtable prefixList, Vector nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof Canonicalizer.Attributes) {
            nodeVector.setElementAt(null, i);
            ((Canonicalizer.Attributes)obj).serialize(null, prefixList, null, wr);
            return;
        }
        if (obj instanceof Canonicalizer.ReplacedNode) {
            Node n = ((Canonicalizer.ReplacedNode)obj).getNode();
            NodeList nl = (NodeList)replNodeSets.get(n);
            HashSet<Node> s = new HashSet<Node>();
            int j = 0;
            int l = nl.getLength();
            block0: while (j < l) {
                Node n2 = nl.item(j);
                s.add(n2);
                for (int k = j + 1; k <= l; ++k) {
                    if (k < l && DOMUtil.isDescendantNode((Node)nl.item(k), (Node)n2)) continue;
                    j = k;
                    continue block0;
                }
            }
            ExclusiveCanonicalizer.serializeSubset(prefixList, nl, false, replNodeSets, wr, s);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            Canonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        Canonicalizer.Attributes ancestorAttrs = stack.empty() ? null : (Canonicalizer.Attributes)stack.peek();
        Canonicalizer.Attributes attrs = null;
        int next = i + 1;
        boolean printXmlns = prefixList == null || prefixList.get("") == null ? node.getPrefix() == null : true;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node || nodeVector.elementAt(next) instanceof Canonicalizer.ReplacedNode) {
            parent = node.getParentNode();
            if (apexNodes != null && apexNodes.contains(node) || printXmlns && parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            String prefix;
            attrs = (Canonicalizer.Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns")) {
                parent = node.getParentNode();
                if (apexNodes != null && apexNodes.contains(node) || printXmlns && parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                    wr.write(" xmlns=\"\"");
                }
            }
            if ((prefix = node.getPrefix()) == null) {
                prefix = "";
            }
            attrs.serialize(stack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!Canonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            ExclusiveCanonicalizer.serializeSubset(stack, prefixList, nodeVector, next, withComments, replNodeSets, wr, apexNodes);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    public static byte[] serializeSubset(Hashtable prefixList, NodeList nodeList, boolean withComments, Map replNodeSets) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            ExclusiveCanonicalizer.serializeSubset(prefixList, nodeList, withComments, replNodeSets, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static Hashtable parsePrefixList(String ssv) {
        Hashtable<String, String> prefixList = null;
        if (ssv == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(ssv, " \t\r\n");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (prefixList == null) {
                prefixList = new Hashtable<String, String>();
            }
            if (tok.equals("#default")) {
                tok = "";
            }
            prefixList.put(tok, tok);
        }
        return prefixList;
    }

    public static String serializePrefixList(Hashtable prefixList) {
        String ssv = null;
        if (prefixList != null && !prefixList.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            boolean b = false;
            Enumeration e = prefixList.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if ("".equals(s)) {
                    s = "#default";
                }
                if (b) {
                    sb.append(" ");
                } else {
                    b = true;
                }
                sb.append(s);
            }
            ssv = sb.toString();
        }
        return ssv;
    }
}

