/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextImpl;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import java.security.Permission;

public final class WSSecurityPlatformContextFactory {
    private static final TraceComponent tc = Tr.register(WSSecurityPlatformContextFactory.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final Permission SETSERVER_PERM = new WebSphereRuntimePermission("wssecurity.setServer");
    private static boolean initialized = false;

    public static final WSSecurityPlatformContext getInstance() {
        return WSSecurityPlatformContextHolder.instance;
    }

    static final void setServer() throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SETSERVER_PERM);
        }
        if (initialized) {
            throw SoapSecurityException.format("security.wssecurity.WSEC0133E");
        }
        initialized = true;
        ((WSSecurityPlatformContextImpl)WSSecurityPlatformContextHolder.instance).setServer();
    }

    private WSSecurityPlatformContextFactory() {
    }

    private static class WSSecurityPlatformContextHolder {
        private static final WSSecurityPlatformContext instance = new WSSecurityPlatformContextImpl();

        private WSSecurityPlatformContextHolder() {
        }

        static {
            initialized = true;
        }
    }
}

