/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.JAASConfig;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyInfoSignature;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSSecurityDefaultConsumerConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConsumerConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultConsumerConfig.class.getName();

    public WSSecurityDefaultConsumerConfig(Consumer conBnd, VariableMap varMap, WSSecurityDefaultConfiguration config) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultConsumerConfig(Consumer, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{conBnd, varMap, config});
        }
        if (varMap == null) {
            varMap = ClientVariableMap.getInstance();
        }
        this.init(conBnd, varMap, config);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultConsumerConfig(Consumer, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }

    protected final void init(Consumer conBnd, VariableMap varMap, WSSecurityDefaultConfiguration config) throws SoapSecurityException {
        int j;
        int jMax;
        PrivateConsumerConfig.KeyInfoConsumerConfImpl kicconfig;
        PrivateCommonConfig.AlgorithmConfImpl aconfig;
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl kiccconfig;
        String value;
        int i;
        int iMax;
        Map defProps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Consumer, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{conBnd, varMap, config});
        }
        ClassLoader appClassLoader = null;
        boolean fipsMode = false;
        WebServicesSecurityAlgorithmHelper algoHelper = null;
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<String, String> type = new HashMap<String, String>();
        HashMap<String, Configuration> nameMapping = new HashMap<String, Configuration>();
        fipsMode = ConfigValidation.isFipsEnabled();
        if (fipsMode) {
            algoHelper = new WebServicesSecurityAlgorithmHelper();
        }
        EList encryptionInfos = null;
        EList keyInfos = null;
        EList signingInfos = null;
        List tokenConsumers = null;
        Map bndProperties = null;
        this._properties = new HashMap();
        if (config != null && (defProps = config.getProperties()) != null) {
            this._properties.putAll(defProps);
        }
        if (conBnd != null) {
            encryptionInfos = conBnd.getEncryptionInfo();
            keyInfos = conBnd.getKeyInfo();
            signingInfos = conBnd.getSigningInfo();
            tokenConsumers = conBnd.getTokenConsumer();
            EList p = conBnd.getProperties();
            if (p != null) {
                bndProperties = ConfigConstants.getProperties(p, varMap);
                this._properties.putAll(bndProperties);
            }
            if (tc.isDebugEnabled()) {
                if (bndProperties != null) {
                    Tr.debug(tc, "Default Consumer Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers, Property):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenConsumers, bndProperties});
                } else {
                    Tr.debug(tc, "Default Consumer Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenConsumers});
                }
            }
        }
        this._bypassSecurityHeader = ConfigUtil.getIsTruePropertyEnv((Map)this._properties, (String)"com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled");
        if (tokenConsumers != null) {
            iMax = tokenConsumers.size();
            for (i = 0; i < iMax; ++i) {
                TrustedIDEvaluatorRef trustedIDEvaluatorRef;
                CertPathSettings certPathSettings;
                TokenConsumer tokenConsumer = (TokenConsumer)tokenConsumers.get(i);
                ValueType valueType = tokenConsumer.getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token consumer named " + tokenConsumer.getName() + " is missing");
                }
                QName qn = new QName(ConfigUtil.trim((String)valueType.getUri()), ConfigUtil.trim((String)valueType.getLocalName()));
                PartReference pref = tokenConsumer.getPartReference();
                PrivateConsumerConfig.TokenConsumerConfImpl tconfig = null;
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)nameMapping.get(value);
                    if (tconfig == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    }
                    if (!tconfig.getType().equals(qn)) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s30", new Object[]{tconfig.getType().toString(), qn.toString()});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                if (tconfig == null) {
                    tconfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    tconfig._type = qn;
                }
                tconfig._name = ConfigUtil.trim((String)tokenConsumer.getName());
                ConfigConstants.getProperties(tconfig._properties, tokenConsumer.getProperties(), varMap);
                tconfig._className = ConfigUtil.trim((String)tokenConsumer.getClassname());
                JAASConfig jaasConfig = tokenConsumer.getJAASConfig();
                if (jaasConfig != null) {
                    tconfig._jaasConfig = ConfigUtil.trim((String)jaasConfig.getConfigName());
                    ConfigConstants.getProperties(tconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                }
                if ((certPathSettings = tokenConsumer.getCertPathSettings()) != null) {
                    TrustAnyCertificate trustAnyCertificate = certPathSettings.getTrustAnyCertificate();
                    if (trustAnyCertificate != null) {
                        tconfig._trustAny = true;
                    } else {
                        TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                        CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                        if (trustAnchorRef != null || certStoreRef != null) {
                            Object kstore = null;
                            if (trustAnchorRef != null) {
                                Object pkixBuilderParams = null;
                                Object provider = null;
                                value = ConfigUtil.trim((String)trustAnchorRef.getRef());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "TrustAnchorRef = " + value);
                                }
                                tconfig._trustAnchorRef = value;
                                tconfig._trustAnchorKeyStore = (KeyStore)config.trustAnchors.get(value);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "_trustAnchorKeyStore = " + tconfig._trustAnchorKeyStore);
                                }
                                if (certStoreRef != null) {
                                    Object cs;
                                    value = ConfigUtil.trim((String)certStoreRef.getRef());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CertStoreRef = " + value);
                                    }
                                    if ((cs = config.getWSCertStore(value)) == null) {
                                        String msgKey = "security.wssecurity.ConfigValidation.csref.notfound";
                                        Tr.error(tc, msgKey, new Object[]{value});
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found CertStore for " + value);
                                        }
                                        tconfig._certStores.add(cs);
                                    }
                                }
                                tconfig._provider = provider;
                                tconfig._pkixBuilderParams = pkixBuilderParams;
                            }
                        }
                    }
                    if (tconfig._trustAnchorRef != null && tconfig._provider == null) {
                        tconfig._provider = ConfigUtil.setupCertStoreProvider((Map)this._properties, (Map)tconfig._properties, (String)tconfig._name);
                    }
                }
                if ((trustedIDEvaluatorRef = tokenConsumer.getTrustedIDEvaluatorRef()) != null) {
                    String tieRef = ConfigUtil.trim((String)trustedIDEvaluatorRef.getRef());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding TrustID Evaluator Reference: " + tieRef);
                    }
                    tconfig._trustedIDEvaluator = config.getTrustedIDEvaluator(tieRef);
                }
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tconfig._className);
                HashMap properties = new HashMap();
                try {
                    tconfig._instance = (TokenConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{tconfig._className});
                }
                this._tokenConsumers.add(tconfig);
                value = ConfigUtil.trim((String)tokenConsumer.getName());
                if (value == null || value.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s26");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + value);
                }
                nameMapping.put(value, tconfig);
            }
        }
        ArrayList<PrivateConsumerConfig.KeyInfoContentConsumerConfImpl> kicontentList = new ArrayList<PrivateConsumerConfig.KeyInfoContentConsumerConfImpl>();
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (i = 0; i < iMax; ++i) {
                TokenReference tokenReference;
                KeyInfo keyInfo = (KeyInfo)keyInfos.get(i);
                kiccconfig = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                kiccconfig._className = ConfigUtil.trim((String)keyInfo.getClassname());
                kiccconfig._keyInfoType = ConfigUtil.trim((String)keyInfo.getType());
                KeyLocatorMapping keyLocatorMapping = keyInfo.getKeyLocatorMapping();
                if (keyLocatorMapping != null) {
                    value = ConfigUtil.trim((String)keyLocatorMapping.getLocatorRef());
                    if (value != null && value.length() > 0) {
                        KeyLocatorProxy klproxy = config.getKeyLocator(value);
                        if (klproxy == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                        } else {
                            try {
                                kiccconfig._keyLocator = klproxy.getKeyLocator6(appClassLoader);
                            }
                            catch (SoapSecurityException sse) {
                                Tr.warning(tc, "security.wssecurity.keylocator.is.null", new Object[]{sse});
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the key locator mapping: " + value);
                            }
                        }
                    }
                    kiccconfig._keyName = ConfigUtil.trim((String)keyLocatorMapping.getKeynameRef());
                }
                if ((tokenReference = keyInfo.getTokenReference()) != null && (value = ConfigUtil.trim((String)tokenReference.getTokenRef())) != null && value.length() > 0) {
                    kiccconfig._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)nameMapping.get(value);
                    if (kiccconfig._tokenConsumer == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the token reference: " + value);
                    }
                }
                ConfigConstants.getProperties(kiccconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", kiccconfig._className);
                HashMap properties = new HashMap();
                try {
                    kiccconfig._instance = (KeyInfoContentConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{kiccconfig._className});
                }
                kicontentList.add(kiccconfig);
                value = ConfigUtil.trim((String)keyInfo.getName());
                if (value == null || value.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s28");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + value);
                }
                nameMapping.put(value, kiccconfig);
            }
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (i = 0; i < iMax; ++i) {
                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(i);
                PrivateConsumerConfig.EncryptionConsumerConfImpl econfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                DataEncryptionMethod dataEncryption = encryptionInfo.getEncryptionMethod();
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = ConfigUtil.trim((String)dataEncryption.getAlgorithm());
                if (!fipsMode || algoHelper.getFipsDataEncryptionAlgorithms().contains(aconfig._algorithm)) {
                    ConfigConstants.getProperties(aconfig._properties, dataEncryption.getProperties(), varMap);
                    econfig._dataEncryptionMethod = aconfig;
                } else {
                    Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DataEncryptionMethod", aconfig._algorithm});
                }
                KeyEncryptionMethod keyEncryption = encryptionInfo.getKeyEncryptionMethod();
                if (keyEncryption != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)keyEncryption.getAlgorithm());
                    if (!fipsMode || algoHelper.getFipsKeyEncryptionAlgorithms().contains(aconfig._algorithm)) {
                        ConfigConstants.getProperties(aconfig._properties, keyEncryption.getProperties(), varMap);
                        econfig._keyEncryptionMethod = aconfig;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"KeyEncryptionMethod", aconfig._algorithm});
                    }
                }
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                EList encryptionKeys = encryptionInfo.getEncryptionKeyInfo();
                if (encryptionKeys == null || encryptionKeys.size() == 0) {
                    kicconfig._contentConsumers = kicontentList;
                } else {
                    kicconfig._contentConsumers = new ArrayList();
                    jMax = encryptionKeys.size();
                    for (j = 0; j < jMax; ++j) {
                        EncryptionKeyInfo encryptionKey = (EncryptionKeyInfo)encryptionKeys.get(j);
                        value = ConfigUtil.trim((String)encryptionKey.getKeyinfoRef());
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameMapping.get(value);
                        if (kiccconfig == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                            continue;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                econfig._encryptionKeyInfo = kicconfig;
                PartReference pref = encryptionInfo.getPartReference();
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameMapping.get(value);
                    if (econfig._reference == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                this._encryptionConsumers.add(econfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption consumer.");
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (i = 0; i < iMax; ++i) {
                SigningInfo signingInfo = (SigningInfo)signingInfos.get(i);
                PrivateConsumerConfig.SignatureConsumerConfImpl sconfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                CanonicalizationMethod c14n = signingInfo.getCanonicalizationMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)c14n.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, c14n.getProperties(), varMap);
                    sconfig._canonicalizationMethod = aconfig;
                }
                SignatureMethod signature = signingInfo.getSignatureMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)signature.getAlgorithm());
                    if (!fipsMode || algoHelper.getFipsSignatureAlgorithms().contains(aconfig._algorithm)) {
                        ConfigConstants.getProperties(aconfig._properties, signature.getProperties(), varMap);
                        sconfig._signatureMethod = aconfig;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"SignatureMethod", aconfig._algorithm});
                    }
                }
                KeyInfoSignature kiSignature = signingInfo.getKeyInfoSignature();
                if (kiSignature != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)kiSignature.getType());
                    ConfigConstants.getProperties(aconfig._properties, kiSignature.getProperties(), varMap);
                    sconfig._keyInfoSignature = aconfig;
                }
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                EList signingKeys = signingInfo.getSigningKeyInfo();
                if (signingKeys == null || signingKeys.size() == 0) {
                    kicconfig._contentConsumers = kicontentList;
                } else {
                    kicconfig._contentConsumers = new ArrayList();
                    jMax = signingKeys.size();
                    for (j = 0; j < jMax; ++j) {
                        SigningKeyInfo signingKey = (SigningKeyInfo)signingKeys.get(j);
                        value = ConfigUtil.trim((String)signingKey.getKeyinfoRef());
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameMapping.get(value);
                        if (kiccconfig == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                            continue;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                sconfig._signingKeyInfo = kicconfig;
                EList prefs = signingInfo.getPartReference();
                if (prefs != null) {
                    jMax = prefs.size();
                    for (j = 0; j < jMax; ++j) {
                        DigestMethod digest;
                        PartReference pref = (PartReference)prefs.get(j);
                        PrivateCommonConfig.SigningReferenceConfImpl srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        value = ConfigUtil.trim((String)pref.getPart());
                        if (value != null && value.length() > 0) {
                            srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameMapping.get(value);
                            if (srconfig._reference == null) {
                                Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + value);
                            }
                        }
                        if ((digest = pref.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = ConfigUtil.trim((String)digest.getAlgorithm());
                            if (!fipsMode || algoHelper.getFipsDigestAlgorithms().contains(aconfig._algorithm)) {
                                ConfigConstants.getProperties(aconfig._properties, digest.getProperties(), varMap);
                                srconfig._digestMethod = aconfig;
                            } else {
                                Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DigestMethod", aconfig._algorithm});
                            }
                        }
                        EList transforms = pref.getTransform();
                        if (transforms != null) {
                            int kMax = transforms.size();
                            for (int k = 0; k < kMax; ++k) {
                                Transform transform = (Transform)transforms.get(k);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = ConfigUtil.trim((String)transform.getAlgorithm());
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                    }
                }
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                this._signatureConsumers.add(sconfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature consumer.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Consumer, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }
}

