/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmMapping;
import com.ibm.etools.webservice.wscommonbnd.CRL;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.NonceCaching;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.etools.webservice.wssecurity.Defaultbindings;
import com.ibm.etools.webservice.wssecurity.Generator;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.core.CertManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCacheFactory;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.TokenCacheManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityClientComponentImpl;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.core.WebServicesSecurityAdmin;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.Permission;
import java.security.cert.CertificateFactory;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class WSSecurityComponentImpl
extends ComponentImpl
implements WSSecurityService {
    private boolean ndEnvironment = false;
    private boolean standaloneServer = false;
    private WSSecurityDefaultConfiguration config = new WSSecurityDefaultConfiguration();
    private WebServicesSecurityAdmin wssecAdmin = null;
    private Object lock = new Object();
    private boolean initialized = false;
    private static final TraceComponent tc = Tr.register(WSSecurityComponentImpl.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = WSSecurityComponentImpl.class.getName();
    private ClassLoader appClassLoader = null;
    private static final String comp = "security.wssecurity";
    private static final Permission REFRESH_PERM = new WebSphereRuntimePermission("wssecurity.refreshConfig");

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering WebServicesSecurityAdmin MBean");
            }
            this.wssecAdmin = new WebServicesSecurityAdmin();
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(this.wssecAdmin, "WebServicesSecurityAdmin");
            mbeanFactory.activateMBean("WebServicesSecurityAdmin", collab, mbeanFactory.getConfigId("WebServicesSecurityAdmin"), "com/ibm/ws/management/descriptor/xml/WebServicesSecurityAdmin.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebServicesSecurityAdmin MBean registered");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, clsName + ".initialize", "118", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{e});
            throw new RuntimeError(ConfigConstants.getMessage("security.wssecurity.start.activate.failed"), e);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering WebServicesSecurityAlgorithmHelper MBean");
            }
            WebServicesSecurityAlgorithmHelper wssecAlgoHelper = new WebServicesSecurityAlgorithmHelper();
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(wssecAlgoHelper, "WebServicesSecurityAlgorithmHelper");
            mbeanFactory.activateMBean("WebServicesSecurityAlgorithmHelper", collab, mbeanFactory.getConfigId("WebServicesSecurityAlgorithmHelper"), "com/ibm/ws/management/descriptor/xml/WebServicesSecurityAlgorithmHelper.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebServicesSecurityAlgorithmHelper MBean registered");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, clsName + ".initialize", "136", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{e});
            throw new RuntimeError(ConfigConstants.getMessage("security.wssecurity.WSEC0145E"), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        HWKeyCache.removeAllEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        try {
            SecurityService securityService;
            WSSecurityPlatformContextFactory.setServer();
            AdminService adminService = AdminServiceFactory.getAdminService();
            String processType = adminService.getProcessType();
            if (processType == null || processType.length() == 0) {
                Tr.error(tc, "security.wssecurity.init.nullprocesstype");
                throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.init.nullprocesstype"));
            }
            if (processType.equals("JobManager")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wssecurity not initialized for job manager process since it is not needed");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize");
                }
                return;
            }
            if (processType.equals("ManagedProcess") || processType.equals("DeploymentManager") || processType.equals("NodeAgent") || processType.equals("AdminAgent")) {
                this.ndEnvironment = true;
            } else if (processType.equals("UnManagedProcess")) {
                this.standaloneServer = true;
            }
            Repository repository2 = null;
            String path = null;
            WSSecurity cell = null;
            WSSecurity server = null;
            try {
                Resource r2;
                block26: {
                    repository2 = (Repository)this.getService(Repository.class);
                    if (this.ndEnvironment) {
                        path = repository2.getConfigRoot().getAbsolutePath(0, "ws-security.xml");
                        WASResourceImpl r1 = null;
                        try {
                            r1 = new WASResourceImpl(URI.createFileURI(path));
                            r1.load(null);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".initialize", "200", this);
                            Tr.warning(tc, "security.wssecurity.load.cell.wssecurity.xml", new Object[]{path});
                            throw new ConfigurationWarning(MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.cell.wssecurity.xml"), path), e);
                        }
                        if (r1 != null && (cell = (WSSecurity)r1.getContents().get(0)) != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found document: " + path);
                        }
                    }
                    r2 = null;
                    try {
                        path = repository2.getConfigRoot().getAbsolutePath(4, "ws-security.xml");
                        r2 = new WASResourceImpl(URI.createFileURI(path));
                        r2.load(null);
                    }
                    catch (Exception e) {
                        r2 = null;
                        if (this.ndEnvironment || !this.standaloneServer) break block26;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Can not load server level configuration file: " + path, new Object[]{e});
                        }
                        Tr.warning(tc, "security.wssecurity.load.server.wssecurity.xml", new Object[]{path});
                    }
                }
                if (r2 != null && (server = (WSSecurity)r2.getContents().get(0)) != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found document: " + path);
                }
            }
            finally {
                if (repository2 != null) {
                    this.releaseService(repository2);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell WSSecurity: ", new Object[]{cell});
                Tr.debug(tc, "Server WSSecurity: ", new Object[]{server});
            }
            if ((securityService = (SecurityService)this.getService(SecurityService.class)) == null) {
                throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.secrutiyservice.isnull"));
            }
            securityService.addListener(new WSSecurityListener(cell, server));
            this.addService(WSSecurityService.class);
        }
        catch (ConfigurationError ce) {
            FFDCFilter.processException((Throwable)ce, this.getClass().getName() + ".initialize", "257", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{ce});
            throw ce;
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".initialize", "261", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{e});
            throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.init.startfail"), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfig");
            Tr.exit(tc, "getConfig", this.config);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(WSSecurity wssec, WSSecurityDefaultConfiguration newConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig", new Object[]{wssec, newConfig});
        }
        VariableMap varMap = null;
        try {
            Defaultbindings defaultBindings;
            NonceCaching nonceCaching;
            EList wAlgorithmMappings;
            CertStoreList csl;
            EList wKeyLocators;
            EList wTIDEvals;
            EList wTA;
            EList wLMS;
            EList p;
            varMap = (VariableMap)this.getService(VariableMap.class);
            boolean isHWAccEnabled = wssec.isUseHardwareAcceleration();
            if (isHWAccEnabled) {
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(isHWAccEnabled)});
                    isHWAccEnabled = false;
                } else if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
                    Tr.error(tc, "security.wssecurityHardware Crypto is not supported on this platform, continues to use software crypto provider");
                }
            }
            if (isHWAccEnabled) {
                newConfig.useHardwareAcceleration = isHWAccEnabled;
                Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(isHWAccEnabled)});
                String hwConfigName = wssec.getHardwareConfigRef();
                if (hwConfigName != null && hwConfigName.length() != 0) {
                    newConfig.hardwareConfigName = hwConfigName;
                    Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{hwConfigName});
                }
            }
            if ((p = wssec.getProperties()) != null) {
                Map map = ConfigConstants.getProperties(p, varMap);
                if (!this.initialized) {
                    String decoupleToken;
                    String clockSkew;
                    String maxAge;
                    String length;
                    String offloadRSAPubKeyCrypto;
                    String cryptoOffload;
                    String v;
                    String useCache;
                    block151: {
                        int i;
                        newConfig.addProperties(map);
                        useCache = (String)map.get("com.ibm.ws.wssecurity.handler.useConfigCache");
                        newConfig.useConfigCache = useCache != null ? ConfigUtil.isTrue((String)useCache) : true;
                        String hwKsRef = (String)map.get("com.ibm.ws.wssecurity.config.hwKeyStoreName");
                        if (hwKsRef != null && hwKsRef.length() != 0) {
                            newConfig.hardwareKeyStoreName = hwKsRef;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Hardware keystore name property is specified, value = " + hwKsRef);
                            }
                        }
                        if ((v = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout")) != null && (v = v.trim()).length() != 0) {
                            try {
                                i = Integer.parseInt(v);
                                newConfig.nonceCacheTimeout = ConfigConstants.validNonceCacheTimeout(i);
                            }
                            catch (NumberFormatException e) {
                                newConfig.nonceCacheTimeout = 600;
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "314", this);
                                Tr.warning(tc, "security.wssecurity.WSEC0115W", new Object[]{v, new Integer(600)});
                            }
                        }
                        if ((v = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout")) != null && (v = v.trim()).length() != 0) {
                            try {
                                i = Integer.parseInt(v);
                                newConfig.certCacheTimeOut = ConfigConstants.validCertCacheTimeout(i);
                            }
                            catch (NumberFormatException e) {
                                newConfig.certCacheTimeOut = 900;
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "330", this);
                                if (!tc.isDebugEnabled()) break block151;
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the certificate cache timeout " + v + "seconds, default " + 900 + " seconds is used instead.");
                            }
                        }
                    }
                    if ((v = (String)map.get("com.ibm.ws.wssecurity.handler.configCacheTimeToLive")) != null) {
                        if ((v = v.trim()).length() != 0) {
                            try {
                                int i;
                                newConfig.configCacheTimeToLive = i = Integer.parseInt(v);
                            }
                            catch (NumberFormatException e) {
                                newConfig.configCacheTimeToLive = 900;
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "349", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache timeToLive " + v + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        newConfig.configCacheTimeToLive = 900;
                    }
                    if ((v = (String)map.get("com.ibm.ws.wssecurity.handler.token.cacheTimeout")) != null) {
                        if ((v = v.trim()).length() != 0) {
                            try {
                                int i = Integer.parseInt(v);
                                newConfig.tokenCacheTimeOut = ConfigConstants.validTokenCacheTimeout(i);
                            }
                            catch (NumberFormatException e) {
                                newConfig.tokenCacheTimeOut = 900;
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "391", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cache timeout " + v + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        newConfig.tokenCacheTimeOut = 900;
                    }
                    if ((v = (String)map.get("com.ibm.ws.wssecurity.handler.token.cushion")) != null) {
                        if ((v = v.trim()).length() != 0) {
                            try {
                                int i = Integer.parseInt(v);
                                newConfig.tokenCacheCushion = ConfigConstants.validTokenCushion(i * 1000);
                            }
                            catch (NumberFormatException e) {
                                newConfig.tokenCacheCushion = 600000L;
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "412", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cushion " + v + "seconds, default " + 600 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        newConfig.tokenCacheCushion = 600000L;
                    }
                    if ((cryptoOffload = (String)map.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography")) != null) {
                        newConfig.useOffloadAllCrypto = cryptoOffload;
                    }
                    newConfig.offloadRSAPublicKeyCrypto = (offloadRSAPubKeyCrypto = (String)map.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography")) != null ? ConfigUtil.isTrue((String)offloadRSAPubKeyCrypto) : true;
                    String hardwareCacheSize = (String)map.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                    newConfig.hardwareCacheSize = hardwareCacheSize != null ? ConfigConstants.processHardwareCacheSize(hardwareCacheSize) : 1000;
                    String szHardwareCacheEntryRefresh = (String)map.get("com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours");
                    long hardwareCacheEntryRefresh = 8L;
                    if (szHardwareCacheEntryRefresh != null) {
                        hardwareCacheEntryRefresh = ConfigConstants.processHardwareCacheEntryRefresh(szHardwareCacheEntryRefresh);
                    }
                    HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
                    fHWKeyCache.setScanParameters(hardwareCacheEntryRefresh);
                    useCache = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.useCache");
                    if (useCache != null) {
                        newConfig.useCertCache = ConfigUtil.isTrue((String)useCache);
                    }
                    newConfig.useConfigCache = (useCache = (String)map.get("com.ibm.ws.wssecurity.handler.useConfigCache")) != null ? ConfigUtil.isTrue((String)useCache) : true;
                    useCache = (String)map.get("com.ibm.ws.wssecurity.handler.token.useCache");
                    newConfig.useTokenCache = useCache != null ? ConfigUtil.isTrue((String)useCache) : true;
                    String cacheName = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName");
                    if (cacheName != null) {
                        newConfig.nonceCacheName = cacheName;
                    }
                    if ((cacheName = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.cacheName")) != null) {
                        newConfig.certCacheName = cacheName;
                    }
                    newConfig.configCacheName = (cacheName = (String)map.get("com.ibm.ws.wssecurity.handler.configCacheName")) != null ? cacheName : "WSSReqGeneratorConfigMap";
                    cacheName = (String)map.get("com.ibm.ws.wssecurity.handler.token.cacheName");
                    newConfig.tokenCacheName = cacheName != null ? cacheName : "WSSTokenCache";
                    String cacheSize = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize");
                    if (cacheSize != null) {
                        newConfig.nonceCacheSize = ConfigConstants.processNonceCacheSize(cacheSize);
                    }
                    if ((cacheSize = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.cacheSize")) != null) {
                        newConfig.certCacheSize = ConfigConstants.processCertCacheSize(cacheSize);
                    }
                    if ((length = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length")) != null) {
                        newConfig.nonceCacheSize = ConfigConstants.processNonceLength(length);
                    }
                    if ((cacheSize = (String)map.get("com.ibm.ws.wssecurity.handler.configCacheSize")) != null) {
                        try {
                            int i;
                            newConfig.configCacheSize = i = Integer.parseInt(cacheSize);
                        }
                        catch (NumberFormatException e) {
                            newConfig.configCacheSize = 128;
                            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "420", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache size " + cacheSize + "default size" + 128 + " is used instead.");
                            }
                        }
                    } else {
                        newConfig.configCacheSize = 128;
                    }
                    if ((cacheSize = (String)map.get("com.ibm.ws.wssecurity.handler.token.cacheSize")) != null) {
                        newConfig.tokenCacheSize = ConfigConstants.processTokenCacheSize(cacheSize);
                    }
                    if ((maxAge = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge")) != null) {
                        newConfig.nonceMaxAge = ConfigConstants.processNonceMaxAge(maxAge, newConfig.nonceCacheTimeout);
                    }
                    if ((clockSkew = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                        newConfig.nonceClockSkew = ConfigConstants.processNonceClockSkew(clockSkew, newConfig.nonceMaxAge);
                    }
                    newConfig.decoupleToken = (decoupleToken = (String)map.get("com.ibm.websphere.wssecurity.util.decouple.token")) != null ? ConfigUtil.isTrue((String)decoupleToken) : true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce cache timeout = " + newConfig.nonceCacheTimeout + ", Nonce max age = " + newConfig.nonceMaxAge + ", Nonce clock skew = " + newConfig.nonceClockSkew);
                }
            }
            if ((wLMS = wssec.getLoginMappings()) == null || wLMS.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No LoginMappings found.");
                }
            } else {
                int size = wLMS.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " LoginMappings found.");
                }
                for (int i = 0; i < size; ++i) {
                    LoginMapping lm = (LoginMapping)wLMS.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing LoginMapping: ", new Object[]{lm});
                    }
                    try {
                        com.ibm.xml.soapsec.token.LoginMapping l = ConfigConstants.readLoginMapping(lm, varMap, this.appClassLoader);
                        newConfig.loginMappings.put(l.getAuthMethod(), l);
                        this.processNonceBindings(l.getAuthMethod(), l.getProperties(), newConfig);
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.error(tc, "security.wssecurity.load.loginmapping.failed", new Object[]{lm.getAuthMethod(), t});
                    }
                }
            }
            if ((wTA = wssec.getTrustAnchors()) == null || wTA.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No TrustAnchors found.");
                }
            } else {
                int size = wTA.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " TrustAnchors found.");
                }
                for (int i = 0; i < size; ++i) {
                    String keyStoreName = null;
                    TrustAnchor trustAnchor = (TrustAnchor)wTA.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing TrustAnchor: ", new Object[]{trustAnchor});
                    }
                    KeyStore keyStore = trustAnchor.getKeyStore();
                    keyStoreName = keyStore.getKeyStoreRef();
                    String path = keyStore.getPath();
                    com.ibm.ws.webservices.wssecurity.config.KeyStore ks = null;
                    if (keyStoreName != null && path != null) {
                        Tr.warning(tc, "Cannot refer to both keyStoreRef and keystore path in the configuration, continue to use keyStoreRef and ignore path information");
                    }
                    if (keyStoreName != null && keyStoreName.length() != 0) {
                        ks = (com.ibm.ws.webservices.wssecurity.config.KeyStore)newConfig.keyStores.get(keyStoreName);
                        if (ks == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating keystore instance with keystore reference: " + keyStoreName);
                            }
                            ks = new com.ibm.ws.webservices.wssecurity.config.KeyStore(keyStoreName);
                            newConfig.keyStores.put(keyStoreName, ks);
                        }
                    } else if (path != null && path.length() != 0) {
                        ks = (com.ibm.ws.webservices.wssecurity.config.KeyStore)newConfig.keyStores.get(path = varMap.expand(path));
                        if (ks == null) {
                            String type = keyStore.getType();
                            char[] storepass = keyStore.getStorepass().toCharArray();
                            keyStoreName = keyStore.getKeyStoreRef();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating keystore instance " + path + " of type " + type);
                            }
                            ks = new com.ibm.ws.webservices.wssecurity.config.KeyStore(type, path, storepass);
                            newConfig.keyStores.put(path, ks);
                        }
                    } else {
                        Tr.error(tc, "Missing keystore information in the trust anchor: " + trustAnchor.getName());
                    }
                    newConfig.trustAnchors.put(trustAnchor.getName(), ks);
                }
            }
            if ((wTIDEvals = wssec.getTrustedIDEvaluators()) == null || wTIDEvals.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No TrustedIDEvaluators found.");
                }
            } else {
                int size = wTIDEvals.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " TrustedIDEvaluators found.");
                }
                for (int i = 0; i < size; ++i) {
                    TrustedIDEvaluator tide = (TrustedIDEvaluator)wTIDEvals.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing TrustedIDEvaluator: ", new Object[]{tide});
                    }
                    try {
                        newConfig.trustedIDEvaluators.put(tide.getName(), ConfigConstants.readTrustedIDEvaluator(tide, varMap, this.appClassLoader));
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.error(tc, "security.wssecurity.load.trustedidevaluator.failed", new Object[]{tide.getName(), t});
                    }
                }
            }
            if ((wKeyLocators = wssec.getKeyLocators()) == null || wKeyLocators.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No KeyLocators found.");
                }
            } else {
                int size = wKeyLocators.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " KeyLocators found.");
                }
                for (int i = 0; i < size; ++i) {
                    KeyLocator kl = (KeyLocator)wKeyLocators.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing KeyLocator: ", new Object[]{kl});
                    }
                    try {
                        newConfig.keyLocators.put(kl.getName(), ConfigConstants.readKeyLocator(kl, varMap));
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.error(tc, "security.wssecurity.load.keylocator.failed", new Object[]{kl.getName(), t});
                    }
                }
            }
            if ((csl = wssec.getCertStoreList()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CertStoreList found.");
                }
            } else {
                EList collectionCertStore;
                EList ldapCertStores = csl.getLdapCertStores();
                if (ldapCertStores == null || ldapCertStores.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No LDAPCertStores found.");
                    }
                } else {
                    int size = ldapCertStores.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, size + " LDAPCertStores found.");
                    }
                    for (int i = 0; i < size; ++i) {
                        LDAPCertStore ldapCertStore = (LDAPCertStore)ldapCertStores.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing LDAPCertStore: ", new Object[]{ldapCertStore});
                        }
                        try {
                            com.ibm.ws.webservices.wssecurity.config.LDAPCertStore certStore = null;
                            certStore = new com.ibm.ws.webservices.wssecurity.config.LDAPCertStore(ldapCertStore, varMap);
                            newConfig.certStores.put(ldapCertStore.getName(), certStore);
                            continue;
                        }
                        catch (Throwable t) {
                            Tr.error(tc, "security.wssecurity.load.ldapcertstore.failed", new Object[]{ldapCertStore.getName(), t});
                        }
                    }
                }
                if ((collectionCertStore = csl.getCollectionCertStores()) == null || collectionCertStore.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No CollectionCertStores found.");
                    }
                } else {
                    int size = collectionCertStore.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, size + " collectionCertStores found.");
                    }
                    for (int i = 0; i < size; ++i) {
                        com.ibm.etools.webservice.wscommonbnd.CollectionCertStore ccs = (com.ibm.etools.webservice.wscommonbnd.CollectionCertStore)collectionCertStore.get(i);
                        if (ccs == null) {
                            Tr.error(tc, "security.wssecurity.collectioncertstore.is.null");
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Process CollectionCertStore: ", new Object[]{ccs});
                        }
                        String provider = ccs.getProvider();
                        HashSet<String> set = new HashSet<String>();
                        EList certificates = ccs.getX509Certificates();
                        EList crls = ccs.getCRL();
                        if ((certificates == null || certificates.isEmpty()) && (crls == null || crls.isEmpty())) {
                            Tr.error(tc, "security.wssecurity.x509certificates.is.null");
                            Tr.error(tc, "security.wssecurity.WSEC0134E");
                            continue;
                        }
                        String algorithm = "Collection";
                        Object params = null;
                        try {
                            String href;
                            int j;
                            CertificateFactory cfac = ConfigUtil.createCertificateFactory((String)"");
                            if (certificates == null || certificates.isEmpty()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "No X509 certificates in CollectionCertStore[" + ccs + "]");
                                }
                            } else {
                                int certificatesSize = certificates.size();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, certificatesSize + " certificates found.");
                                }
                                for (j = 0; j < certificatesSize; ++j) {
                                    X509Certificate x509Certificate = (X509Certificate)certificates.get(j);
                                    href = varMap.expand(x509Certificate.getPath());
                                    if (href == null) {
                                        Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{ccs.getName()});
                                        continue;
                                    }
                                    if (set.contains(href)) {
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "href already in HashSet: " + href);
                                        continue;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding href to HashSet: " + href);
                                    }
                                    set.add(href);
                                }
                            }
                            if (crls == null || crls.isEmpty()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "No X509 crls in CollectionCertStore[" + ccs + "]");
                                }
                            } else {
                                int crlsSize = crls.size();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, crlsSize + " CRLs found.");
                                }
                                for (j = 0; j < crlsSize; ++j) {
                                    CRL crl = (CRL)crls.get(j);
                                    href = varMap.expand(crl.getPath());
                                    if (href == null) {
                                        Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{ccs.getName()});
                                        continue;
                                    }
                                    if (set.contains(href)) {
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "href already in HashSet: " + href);
                                        continue;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding href to HashSet: " + href);
                                    }
                                    set.add(href);
                                }
                            }
                            CollectionCertStore certStore = null;
                            certStore = new CollectionCertStore(algorithm, set, provider, ccs.getName());
                            newConfig.certStores.put(ccs.getName(), certStore);
                            continue;
                        }
                        catch (Throwable e) {
                            Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{ccs.getName(), e});
                        }
                    }
                }
            }
            if ((wAlgorithmMappings = wssec.getAlgorithmMapping()) == null || wAlgorithmMappings.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No AlgorithmMappings found.");
                }
            } else {
                int size = wAlgorithmMappings.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " AlgorithmMappings found.");
                }
                for (int i = 0; i < size; ++i) {
                    AlgorithmMapping am = (AlgorithmMapping)wAlgorithmMappings.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process AlgorithmMapping: ", new Object[]{am});
                    }
                    try {
                        newConfig.algorithmMappings.add(ConfigConstants.readAlgorithmMapping(am, varMap));
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.error(tc, "security.wssecurity.load.algorithmmapping.failed", new Object[]{am.getFactoryname(), t});
                    }
                }
            }
            if ((nonceCaching = wssec.getNonceCaching()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No NonceCaching found.");
                }
            } else {
                newConfig.nonceCacheDistributed = nonceCaching.isDistributed();
            }
            if ((defaultBindings = wssec.getDefaultbindings()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default bindings found.");
                }
            } else {
                Generator generator;
                Consumer consumer = defaultBindings.getConsumer();
                if (consumer != null) {
                    newConfig.cconfig = new WSSecurityDefaultConsumerConfig(consumer, varMap, newConfig);
                }
                if ((generator = defaultBindings.getGenerator()) != null) {
                    newConfig.gconfig = null;
                    try {
                        newConfig.gconfig = new WSSecurityDefaultGeneratorConfig(generator, varMap, newConfig);
                    }
                    catch (SoapSecurityException sse) {
                        Tr.error(tc, "security.wssecurity.WSEC0135E", new Object[]{sse.getMessage()});
                    }
                }
            }
        }
        finally {
            if (varMap != null) {
                this.releaseService(varMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig", new Object[]{wssec, newConfig});
        }
    }

    private void processNonceBindings(String am, Map map, WSSecurityDefaultConfiguration newConfig) {
        boolean bBasicAuth;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processNonceBindings");
        }
        if (bBasicAuth = "BasicAuth".equals(am)) {
            String clockSkew;
            String maxAge = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            if (maxAge != null) {
                newConfig.nonceMaxAge = ConfigConstants.processNonceMaxAge(maxAge, newConfig.nonceCacheTimeout);
            }
            if ((clockSkew = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                newConfig.nonceClockSkew = ConfigConstants.processNonceClockSkew(clockSkew, newConfig.nonceMaxAge);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Nonce max age = " + newConfig.nonceMaxAge + ", Nonce clock skew = " + newConfig.nonceClockSkew);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonceBindings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RuntimeWarning {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        Repository repository2 = null;
        String path = null;
        WSSecurityDefaultConfiguration newConfig = new WSSecurityDefaultConfiguration();
        try {
            Resource r2;
            WSSecurity wssec;
            block23: {
                repository2 = (Repository)this.getService(Repository.class);
                if (this.ndEnvironment) {
                    WASResourceImpl r1 = null;
                    try {
                        path = repository2.getConfigRoot().getAbsolutePath(0, "ws-security.xml");
                        r1 = new WASResourceImpl(URI.createFileURI(path));
                        r1.load(null);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".refresh", "814", this);
                        String message = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.cell.wssecurity.xml"), path);
                        Tr.warning(tc, "security.wssecurity.load.cell.wssecurity.xml", new Object[]{path});
                        throw new RuntimeWarning(message, e);
                    }
                    if (r1 != null) {
                        wssec = (WSSecurity)r1.getContents().get(0);
                        if (wssec != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading the Cell level configuration: " + path);
                        }
                        this.loadConfig(wssec, newConfig);
                    }
                }
                r2 = null;
                try {
                    path = repository2.getConfigRoot().getAbsolutePath(4, "ws-security.xml");
                    r2 = new WASResourceImpl(URI.createFileURI(path));
                    r2.load(null);
                }
                catch (Exception e) {
                    r2 = null;
                    if (this.ndEnvironment || !this.standaloneServer) break block23;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not load server level configuration file: " + path, new Object[]{e});
                    }
                    Tr.warning(tc, "security.wssecurity.load.server.wssecurity.xml", new Object[]{path});
                }
            }
            if (r2 != null) {
                wssec = (WSSecurity)r2.getContents().get(0);
                if (wssec != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading the Server level configuration: " + path);
                }
                this.loadConfig(wssec, newConfig);
            }
            Object object = this.lock;
            synchronized (object) {
                newConfig.keyStores.clear();
                newConfig.certs.clear();
                this.config = newConfig;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration: ", new Object[]{this.config});
            }
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, WSSecurityClientComponentImpl.class.getName() + ".initialize", "865", this);
            Tr.error(tc, "security.wssecurity.WSEC0126E", e);
        }
        finally {
            if (repository2 != null) {
                this.releaseService(repository2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    private class WSSecurityListener
    implements SecurityServiceListener {
        private WSSecurity cell;
        private WSSecurity server;

        private WSSecurityListener(WSSecurity cell, WSSecurity server) {
            this.cell = cell;
            this.server = server;
        }

        public void stateChanged(SecurityServiceEvent e) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged");
            }
            if (e.getState() == 1) {
                WSSecurityDefaultConfiguration newConfig = new WSSecurityDefaultConfiguration();
                try {
                    if (WSSecurityComponentImpl.this.ndEnvironment && this.cell != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading the Cell level configuration");
                        }
                        WSSecurityComponentImpl.this.loadConfig(this.cell, newConfig);
                    }
                    if (this.server != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading the Server level configuration");
                        }
                        WSSecurityComponentImpl.this.loadConfig(this.server, newConfig);
                    }
                }
                catch (SoapSecurityException ex) {
                    FFDCFilter.processException((Throwable)ex, WSSecurityClientComponentImpl.class.getName() + ".initialize", "912", this);
                    Tr.error(tc, "security.wssecurity.WSEC0126E", ex);
                }
                newConfig.keyStores.clear();
                newConfig.certs.clear();
                WSSecurityComponentImpl.this.config = newConfig;
                if (!WSSecurityComponentImpl.this.initialized) {
                    NonceManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useNonceCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheTimeout, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceLength, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheDistributed);
                    CertManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useCertCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.certCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.certCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.certCacheTimeOut);
                    DistributedConfigCacheFactory.init_boot(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useConfigCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.configCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.configCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.configCacheTimeToLive);
                    TokenCacheManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useTokenCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheTimeOut, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheCushion);
                }
                WSSecurityComponentImpl.this.initialized = true;
                if (WSSecurityComponentImpl.this.wssecAdmin != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "(Start) set WSSecurityService to WebServicesSecurityAdmin MBean");
                    }
                    WSSecurityComponentImpl.this.wssecAdmin.setWSSecurityService(WSSecurityComponentImpl.this);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration: ", new Object[]{WSSecurityComponentImpl.this.config});
                }
            } else if (e.getState() == 2 && WSSecurityComponentImpl.this.wssecAdmin != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "(Stop) remove WSSecurityService from WebServicesSecurityAdmin MBean");
                }
                WSSecurityComponentImpl.this.wssecAdmin.setWSSecurityService(null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stateChanged");
            }
        }
    }
}

