/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmMapping;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.etools.webservice.wssecurity.Defaultbindings;
import com.ibm.etools.webservice.wssecurity.Generator;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.core.CertManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class WSSecurityClientComponentImpl
extends ComponentImpl
implements WSSecurityService {
    private WSSecurityDefaultConfiguration config = new WSSecurityDefaultConfiguration();
    private VariableMap varMap = null;
    private Object lock = new Object();
    private ClassLoader appClassLoader = null;
    private static final TraceComponent tc = Tr.register(WSSecurityClientComponentImpl.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
            Tr.exit(tc, "stop");
        }
    }

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        try {
            this.addService(WSSecurityService.class, this);
            this.varMap = ClientVariableMap.getInstance();
            this._refresh();
            NonceManagerFactory.init(true, "NonceDistributionCacheMap", 1024, 600, 128, false);
            CertManagerFactory.init(true, "NonceDistributionCacheMap", 1024, 600);
        }
        catch (ConfigurationError ce) {
            FFDCFilter.processException((Throwable)ce, this.getClass().getName() + ".initialize", "116", this);
            Tr.error(tc, "security.wssecurity.client.init.startfail", new Object[]{ce});
            throw ce;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".initialize", "120", this);
            Tr.error(tc, "security.wssecurity.client.init.startfail", new Object[]{e});
            throw new ConfigurationError(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    public void refresh() throws RuntimeWarning {
        throw new RuntimeWarning(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.no.refresh"));
    }

    private void _refresh() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_refresh");
        }
        WSSecurityDefaultConfiguration newConfig = new WSSecurityDefaultConfiguration();
        try {
            String xmlFilePath = null;
            String xmlFileURL = null;
            Resource res = null;
            Object obj = null;
            String configBindingsLocation = System.getProperty("wssecurity.defaultbindings.location");
            if (configBindingsLocation != null && configBindingsLocation.length() > 0) {
                xmlFilePath = configBindingsLocation;
            }
            if (xmlFilePath != null) {
                WSSecurity wssec;
                String message;
                xmlFileURL = this.getFileURL(xmlFilePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client xmlFileURL to load: " + xmlFileURL);
                }
                try {
                    WASResourceSetImpl resSet = new WASResourceSetImpl();
                    res = resSet.getResource(URI.createURI(xmlFileURL), true);
                }
                catch (Exception e) {
                    Tr.warning(tc, "security.wssecurity.client.wssecurity.xml.notfound", new Object[]{xmlFileURL});
                    FFDCFilter.processException((Throwable)e, WSSecurityClientComponentImpl.class.getName() + "._refresh", "174", this);
                    String message2 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.xml.notfound"), xmlFileURL);
                    throw new ConfigurationWarning(message2, e);
                }
                if (res == null) {
                    Tr.warning(tc, "security.wssecurity.client.wssecurity.xml.notfound", new Object[]{xmlFileURL});
                    message = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.xml.notfound"), xmlFileURL);
                    throw new ConfigurationWarning(message);
                }
                EList list = res.getContents();
                obj = list.get(0);
                if (obj != null && obj instanceof WSSecurity) {
                    wssec = (WSSecurity)obj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loading the client-side ws-security.xml configuration, type = " + obj.getClass().getName());
                    }
                } else {
                    Tr.error(tc, "security.wssecurity.load.client.wssecurity.xml", new Object[]{xmlFileURL});
                    message = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.client.wssecurity.xml"), xmlFileURL);
                    throw new ConfigurationError(message);
                }
                newConfig = new WSSecurityDefaultConfiguration();
                this.loadConfig(wssec, newConfig);
                newConfig.keyStores.clear();
                newConfig.certs.clear();
                newConfig.crls.clear();
                this.config = newConfig;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration: ", new Object[]{this.config});
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.loading.config"), e.getMessage());
            throw new ConfigurationError("Exception loading config: " + message, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_refresh");
        }
    }

    public String getFileURL(String path) {
        File f = new File(path);
        String fpath = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            fpath = fpath.replace(File.separatorChar, '/');
        }
        fpath = fpath.startsWith("/") ? "file:" + fpath : "file:/" + fpath;
        return fpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfig");
            Tr.exit(tc, "getConfig", this.config);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.config;
        }
    }

    private void loadConfig(WSSecurity wssec, WSSecurityDefaultConfiguration newConfig) throws SoapSecurityException {
        Defaultbindings defaultBindings;
        EList wAlgorithmMappings;
        CertStoreList csl;
        EList wKeyLocators;
        EList wTIDEvals;
        EList wTA;
        EList wLMS;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig", new Object[]{wssec, newConfig});
        }
        if ((wLMS = wssec.getLoginMappings()) == null || wLMS.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No LoginMappings found.");
            }
        } else {
            int size = wLMS.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, size + " LoginMappings found.");
            }
            for (int i = 0; i < size; ++i) {
                LoginMapping lm = (LoginMapping)wLMS.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing LoginMapping: ", new Object[]{lm});
                }
                try {
                    com.ibm.xml.soapsec.token.LoginMapping l = ConfigConstants.readLoginMapping(lm, this.varMap, this.appClassLoader);
                    newConfig.loginMappings.put(l.getAuthMethod(), l);
                    continue;
                }
                catch (Throwable t) {
                    Tr.error(tc, "security.wssecurity.load.loginmapping.failed", new Object[]{lm.getAuthMethod(), t});
                }
            }
        }
        if ((wTA = wssec.getTrustAnchors()) == null || wTA.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No TrustAnchors found.");
            }
        } else {
            int size = wTA.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, size + " TrustAnchors found.");
            }
            for (int i = 0; i < size; ++i) {
                KeyStore keyStore;
                String path;
                com.ibm.ws.webservices.wssecurity.config.KeyStore ks;
                TrustAnchor trustAnchor = (TrustAnchor)wTA.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing TrustAnchor: ", new Object[]{trustAnchor});
                }
                if ((ks = (com.ibm.ws.webservices.wssecurity.config.KeyStore)newConfig.keyStores.get(path = this.varMap.expand((keyStore = trustAnchor.getKeyStore()).getPath()))) == null) {
                    String type = keyStore.getType();
                    char[] storepass = keyStore.getStorepass().toCharArray();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating keystore instance " + path + " of type " + type);
                    }
                    ks = new com.ibm.ws.webservices.wssecurity.config.KeyStore(type, path, storepass);
                    newConfig.keyStores.put(path, ks);
                }
                newConfig.trustAnchors.put(trustAnchor.getName(), ks);
            }
        }
        if ((wTIDEvals = wssec.getTrustedIDEvaluators()) == null || wTIDEvals.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No TrustedIDEvaluators found.");
            }
        } else {
            int size = wTIDEvals.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, size + " TrustedIDEvaluators found.");
            }
            for (int i = 0; i < size; ++i) {
                TrustedIDEvaluator tide = (TrustedIDEvaluator)wTIDEvals.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing TrustedIDEvaluator: ", new Object[]{tide});
                }
                try {
                    newConfig.trustedIDEvaluators.put(tide.getName(), ConfigConstants.readTrustedIDEvaluator(tide, this.varMap, this.appClassLoader));
                    continue;
                }
                catch (Throwable t) {
                    Tr.error(tc, "security.wssecurity.load.trustedidevaluator.failed", new Object[]{tide.getName(), t});
                }
            }
        }
        if ((wKeyLocators = wssec.getKeyLocators()) == null || wKeyLocators.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No KeyLocators found.");
            }
        } else {
            int size = wKeyLocators.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, size + " KeyLocators found.");
            }
            for (int i = 0; i < size; ++i) {
                KeyLocator kl = (KeyLocator)wKeyLocators.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing KeyLocator: ", new Object[]{kl});
                }
                try {
                    newConfig.keyLocators.put(kl.getName(), ConfigConstants.readKeyLocator(kl, this.varMap));
                    continue;
                }
                catch (Throwable t) {
                    Tr.error(tc, "security.wssecurity.load.keylocator.failed", new Object[]{kl.getName(), t});
                }
            }
        }
        if ((csl = wssec.getCertStoreList()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No CertStoreList found.");
            }
        } else {
            EList collectionCertStore;
            EList ldapCertStores = csl.getLdapCertStores();
            if (ldapCertStores == null || ldapCertStores.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No LDAPCertStores found.");
                }
            } else {
                int size = ldapCertStores.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " LDAPCertStores found.");
                }
                for (int i = 0; i < size; ++i) {
                    LDAPCertStore ldapCertStore = (LDAPCertStore)ldapCertStores.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing LDAPCertStore: ", new Object[]{ldapCertStore});
                    }
                    try {
                        com.ibm.ws.webservices.wssecurity.config.LDAPCertStore certStore = null;
                        certStore = new com.ibm.ws.webservices.wssecurity.config.LDAPCertStore(ldapCertStore, this.varMap);
                        newConfig.certStores.put(ldapCertStore.getName(), certStore);
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.error(tc, "security.wssecurity.load.ldapcertstore.failed", new Object[]{ldapCertStore.getName(), t});
                    }
                }
            }
            if ((collectionCertStore = csl.getCollectionCertStores()) == null || collectionCertStore.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CollectionCertStores found.");
                }
            } else {
                int size = collectionCertStore.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, size + " collectionCertStores found.");
                }
                for (int i = 0; i < size; ++i) {
                    com.ibm.etools.webservice.wscommonbnd.CollectionCertStore ccs = (com.ibm.etools.webservice.wscommonbnd.CollectionCertStore)collectionCertStore.get(i);
                    if (ccs == null) {
                        Tr.error(tc, "security.wssecurity.collectioncertstore.is.null");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process CollectionCertStore: ", new Object[]{ccs});
                    }
                    String provider = ccs.getProvider();
                    HashSet<Object> set = new HashSet<Object>();
                    EList certificates = ccs.getX509Certificates();
                    EList crls = ccs.getCRL();
                    if ((certificates == null || certificates.isEmpty()) && (crls == null || crls.isEmpty())) {
                        Tr.error(tc, "security.wssecurity.x509certificates.is.null");
                        Tr.error(tc, "security.wssecurity.WSEC0134E");
                        continue;
                    }
                    String algorithm = "Collection";
                    CollectionCertStoreParameters params = null;
                    try {
                        Object cert;
                        String href;
                        int j;
                        CertificateFactory cfac = ConfigUtil.createCertificateFactory((String)"");
                        if (certificates == null || certificates.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No X509 certificates in CollectionCertStore[" + ccs + "]");
                            }
                        } else {
                            int certificatesSize = certificates.size();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, certificatesSize + " certificates found.");
                            }
                            for (j = 0; j < certificatesSize; ++j) {
                                X509Certificate x509Certificate = (X509Certificate)certificates.get(j);
                                href = this.varMap.expand(x509Certificate.getPath());
                                if (href == null) {
                                    Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{ccs.getName()});
                                    continue;
                                }
                                cert = null;
                                X509CRL crl = null;
                                if (newConfig.certs.containsKey(href)) {
                                    cert = (java.security.cert.X509Certificate)newConfig.certs.get(href);
                                } else if (newConfig.crls.containsKey(href)) {
                                    crl = (X509CRL)newConfig.crls.get(href);
                                }
                                if (cert == null && crl == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Creating certificate or CRL: " + href);
                                    }
                                    try {
                                        cert = ConfigUtil.getX509Certificate((File)new File(href), (CertificateFactory)cfac);
                                        newConfig.certs.put(href, cert);
                                    }
                                    catch (Exception ex) {
                                        crl = ConfigUtil.getX509CRL((File)new File(href), (CertificateFactory)cfac);
                                        newConfig.crls.put(href, crl);
                                    }
                                }
                                if (crl != null) {
                                    set.add(crl);
                                    continue;
                                }
                                set.add(cert);
                            }
                        }
                        if (crls == null || crls.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No X509 crls in CollectionCertStore[" + ccs + "]");
                            }
                        } else {
                            int crlsSize = crls.size();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, crlsSize + " CRLs found.");
                            }
                            for (j = 0; j < crlsSize; ++j) {
                                com.ibm.etools.webservice.wscommonbnd.CRL crl = (com.ibm.etools.webservice.wscommonbnd.CRL)crls.get(j);
                                href = this.varMap.expand(crl.getPath());
                                if (href == null) {
                                    Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{ccs.getName()});
                                    continue;
                                }
                                cert = (CRL)newConfig.crls.get(href);
                                if (cert == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Creating certificate: " + href);
                                    }
                                    cert = ConfigUtil.getX509CRL((File)new File(href), (CertificateFactory)cfac);
                                    newConfig.crls.put(href, cert);
                                }
                                set.add(cert);
                            }
                        }
                        params = new CollectionCertStoreParameters(set);
                        CollectionCertStore certStore = null;
                        certStore = new CollectionCertStore(algorithm, params, provider, ccs.getName());
                        newConfig.certStores.put(ccs.getName(), certStore);
                        continue;
                    }
                    catch (Throwable e) {
                        Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{ccs.getName(), e});
                    }
                }
            }
        }
        if ((wAlgorithmMappings = wssec.getAlgorithmMapping()) == null || wAlgorithmMappings.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No AlgorithmMappings found.");
            }
        } else {
            int size = wAlgorithmMappings.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, size + " AlgorithmMappings found.");
            }
            for (int i = 0; i < size; ++i) {
                AlgorithmMapping am = (AlgorithmMapping)wAlgorithmMappings.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process AlgorithmMapping: ", new Object[]{am});
                }
                try {
                    newConfig.algorithmMappings.add(ConfigConstants.readAlgorithmMapping(am, this.varMap));
                    continue;
                }
                catch (Throwable t) {
                    Tr.error(tc, "security.wssecurity.load.algorithmmapping.failed", new Object[]{am.getFactoryname(), t});
                }
            }
        }
        if ((defaultBindings = wssec.getDefaultbindings()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No default bindings found.");
            }
        } else {
            Generator generator;
            Consumer consumer = defaultBindings.getConsumer();
            if (consumer != null) {
                newConfig.cconfig = new WSSecurityDefaultConsumerConfig(consumer, this.varMap, newConfig);
            }
            if ((generator = defaultBindings.getGenerator()) != null) {
                newConfig.gconfig = null;
                try {
                    newConfig.gconfig = new WSSecurityDefaultGeneratorConfig(generator, this.varMap, newConfig);
                }
                catch (SoapSecurityException sse) {
                    Tr.error(tc, "security.wssecurity.WSEC0135E", new Object[]{sse.getMessage()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig", new Object[]{wssec, newConfig});
        }
    }
}

