/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class WSSGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSGenerator.class.getName();
    private Map _handlerOption = new HashMap();
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map _properties = new HashMap();
    private boolean _initialized = false;

    public void setHandlerOption(String key, Object value) {
        this._handlerOption.put(key, value);
    }

    public Object getHandlerOption(String key) {
        return this._handlerOption.get(key);
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap map = (HashMap)this._messageConfig.get();
        if (map == null) {
            map = new HashMap();
            this._messageConfig.set(map);
        }
        return map;
    }

    public void setMessageOption(String key, Object value) {
        this.getMessageConfig().put(key, value);
    }

    public Object getMessageOption(String key) {
        return this.getMessageConfig().get(key);
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        boolean doSecurity;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        this.clear();
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        RequestPool.initialize((Map)context);
        boolean externalRequests = WSSGenerator.adjustContext(messageContext, context);
        TokenManager.initializeSubject(context);
        RequestMessagePool.initialize(context);
        Object obj = messageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
            context.put("com.ibm.ws.webservices.wssecurity.constants.wssVersion", obj);
        }
        WSSGeneratorConfig config = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSSGeneratorConfig [" + config + "]."));
        }
        TimestampGeneratorConfig tsconfig = config.getTimestampGenerator();
        HashMap properties = new HashMap(this._properties);
        context.put(NonceManager.class, config.getNonceManager());
        boolean doTimestamp = config.isTimestampEnabled();
        boolean bl = doSecurity = config.isTokenEnabled() || config.isSignatureEnabled() || config.isEncryptionEnabled() || doTimestamp && !tsconfig.isSOAPHeaderElement() || externalRequests;
        if (!doTimestamp && !doSecurity) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
            }
            return;
        }
        this.setMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", messageContext.getProperty("javax.xml.rpc.service.endpoint.address"));
        this.setMessageOption("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
        SOAPMessage message = messageContext.getMessage();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope soapEnv = null;
        try {
            soapEnv = soapPart.getEnvelope();
        }
        catch (SOAPException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"262", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s01", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s01", e);
        }
        if (doc == null) {
            doc = soapEnv.getOwnerDocument();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The original message to be processed by WSSGenerator: " + DOMUtil.toString((Node)doc)));
        }
        if (parent == null) {
            parent = WSSGenerator.getHeader(doc, true);
        } else {
            int ret = NamespaceUtil.checkSoapVersion(parent, -1, "Header");
            if (ret < 0) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtil.getQualifiedName((Node)parent));
            }
        }
        int soapVersion = NamespaceUtil.isSoap(parent.getNamespaceURI());
        context.put("com.ibm.ws.webservices.wssecurity.constants.soapVersion", new Integer(soapVersion));
        boolean mustUnderstand = true;
        if (!doSecurity) {
            if (doTimestamp) {
                mustUnderstand = this.checkMustUnderstand(config, messageContext);
                WSSGenerator.callTimestampGenerator(tsconfig, properties, doc, parent, context);
            }
        } else {
            Set tokens;
            mustUnderstand = this.checkMustUnderstand(config, messageContext);
            Element security2 = WSSGenerator.addSecurityHeader(doc, parent, soapVersion, wssVersion, config.getTargetActor(), mustUnderstand);
            if (doTimestamp) {
                WSSGenerator.callTimestampGenerator(tsconfig, properties, doc, security2, context);
            }
            if ((tokens = config.getTokenGenerators()).size() > 0) {
                this.retrieveCachedInformation(messageContext);
            }
            for (Configuration conf : tokens) {
                if (conf instanceof TokenGeneratorConfig) {
                    WSSGenerator.callTokenGenerator((TokenGeneratorConfig)conf, doc, security2, context);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s04", conf.getClass().getName());
            }
            Set saTokens = TokenManager.getTokens(context);
            if (saTokens != null && saTokens.size() > 0) {
                HashSet<Element> set = new HashSet<Element>();
                for (Token t : saTokens) {
                    if (t.getElement() == null) continue;
                    set.add(t.getElement());
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the element of stand-alone token [" + t + "]."));
                }
                context.put("com.ibm.ws.webservices.wssecurity.constants.standAloneElements", set);
            }
            List operations = config.getOperationGenerators();
            for (Configuration conf : operations) {
                if (conf instanceof SignatureGeneratorConfig) {
                    WSSGenerator.callSignatureGenerator((SignatureGeneratorConfig)conf, properties, doc, security2, context);
                    continue;
                }
                if (conf instanceof EncryptionGeneratorConfig) {
                    WSSGenerator.callEncryptionGenerator((EncryptionGeneratorConfig)conf, properties, doc, security2, context);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s04", conf.getClass().getName());
            }
        }
        if (doTimestamp) {
            TimestampGenerator.moveTimestamp(doc, config.getTimestampGenerator(), properties, context);
        }
        if (config.isUserDefinedComponentsUsed()) {
            IdUtil.getInstance().checkIdUniqueness(doc);
        }
        RequestPool.finalize((Map)context);
        RequestMessagePool.finalize(context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    public void onFault(SOAPMessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onFault(SOAPMessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onFault(SOAPMessageContext context)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", IdUtil.getInstance());
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<String, String> type = new HashMap<String, String>();
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.timestamp");
        this._properties.put(TimestampGenerator.class, factory.createGenerator(type, this._properties));
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.signature");
        this._properties.put(SignatureGenerator.class, factory.createGenerator(type, this._properties));
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.encryption");
        this._properties.put(EncryptionGenerator.class, factory.createGenerator(type, this._properties));
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoGenerator.class, factory.createGenerator(type, this._properties));
    }

    private static boolean adjustContext(SOAPMessageContext context, Map ccontext) throws SoapSecurityException {
        return false;
    }

    public abstract void retrieveCachedInformation(SOAPMessageContext var1) throws SoapSecurityException;

    public static Element getHeader(Document doc, boolean creation) throws SoapSecurityException {
        String ns;
        Element root;
        Element header;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHeader(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "])"));
        }
        if ((header = DOMUtil.getFirstElement((Node)(root = doc.getDocumentElement()), (String)(ns = root.getNamespaceURI()), (String)"Header")) == null && creation) {
            String prefix = root.getPrefix();
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() > 0) {
                prefix = prefix + ":";
            }
            header = doc.createElementNS(ns, prefix + "Header");
            header = (Element)root.insertBefore(header, root.getFirstChild());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getheader(Document doc) returns Element[", (Object)(DOMUtil.getDisplayName((Node)header) + "]"));
        }
        return header;
    }

    private static Element addSecurityHeader(Document doc, Element header, int soapVersion, int wssVersion, String actor, boolean mustUnderstand) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addSecurityHeader(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element header[" + DOMUtil.getDisplayName((Node)header) + "]," + "int soapVersion[" + soapVersion + "]," + "int wssVersion[" + wssVersion + "]," + "String actor[" + actor + "]," + "boolean mustUnderstand[" + mustUnderstand + "])"));
        }
        Element security2 = null;
        security2 = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, mustUnderstand);
        if (security2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addSecurityHeader Uses existing wsse:Security element");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtil.getDisplayName((Node)security2) + "]"));
            }
            return security2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addSecurityHeader Creates new wsse:Security element");
        }
        security2 = doc.createElementNS(Constants.NS_WSSE, "wsse:Security");
        security2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", Constants.NS_WSSE);
        String prefix = header.getPrefix();
        if (actor != null) {
            String ac = soapVersion == 0 ? "actor" : "role";
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                security2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, Constants.NS_SOAP);
            }
            security2.setAttributeNS(Constants.NS_SOAP, prefix + ":" + ac, actor);
        }
        if (mustUnderstand) {
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                security2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, Constants.NS_SOAP);
            }
            security2.setAttributeNS(Constants.NS_SOAP, prefix + ":mustUnderstand", "1");
        }
        security2 = (Element)header.insertBefore(security2, header.getFirstChild());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtil.getDisplayName((Node)security2) + "]"));
        }
        return security2;
    }

    public static Element getSecurityHeader(Element header, int soapVersion, int wssVersion, String actor, boolean mustUnderstand) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("searchForSecurityHeader(Element header[" + DOMUtil.getDisplayName((Node)header) + "]," + "int soapVersion[" + soapVersion + "]," + "int wssVersion[" + wssVersion + "]," + "String actor[" + actor + "]," + "boolean mustUnderstand[" + mustUnderstand + "])"));
        }
        Element el = DOMUtil.getFirstElement((Node)header);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            if ((wssVersion < 0 || NamespaceUtil.isWsse(ns) == wssVersion) && "Security".equals(ln)) {
                String mu;
                String act;
                if (soapVersion == 1) {
                    act = el.getAttributeNS(Constants.NS_SOAP12, "role");
                    mu = el.getAttributeNS(Constants.NS_SOAP12, "mustUnderstand");
                } else if (soapVersion == 0) {
                    act = el.getAttributeNS(Constants.NS_SOAP, "actor");
                    mu = el.getAttributeNS(Constants.NS_SOAP, "mustUnderstand");
                } else {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(soapVersion));
                }
                if (!(actor != null && actor.length() != 0 ? !actor.equals(act) : act != null && act.trim().length() != 0)) {
                    if (mustUnderstand && !"1".equals(mu)) {
                        throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s12", mu, Boolean.toString(mustUnderstand));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("searchForSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + el + "]"));
                    }
                    return el;
                }
            }
            el = DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"searchForSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns null");
        }
        return null;
    }

    private static void callTimestampGenerator(TimestampGeneratorConfig config, Map selectors, Document document, Element parent, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        TimestampGenerator gen = (TimestampGenerator)selectors.get(TimestampGenerator.class);
        context.put("com.ibm.wsspi.wssecurity.config.timestampGenerator.configKey", config);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callTokenGenerator(TokenGeneratorConfig config, Document document, Element parent, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callTokenGenerator(TokenGeneratorConfig[" + config + "]" + "Document document[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        if (config.isStandAlone()) {
            TokenGeneratorComponent gen;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Generating security token");
            }
            if ((gen = config.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to get the TokenGenerator object: [" + config + "]."));
                }
            } else {
                context.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", config);
                gen.invoke(document, parent, context);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security token will not be generated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callTokenGenerator(TokenGeneratorConfig config,Document document,Element parent,Map context)");
        }
    }

    private static void callSignatureGenerator(SignatureGeneratorConfig config, Map selectors, Document document, Element parent, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callSignatureGenerator(SignatureGeneratorConfig config,Map selectors,Document document[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        SignatureGenerator gen = (SignatureGenerator)selectors.get(SignatureGenerator.class);
        context.put("com.ibm.wsspi.wssecurity.config.signatureGenerator.configKey", config);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callSignatureGenerator(WSSFactory factory,SignatureGeneratorConfig config,Map type,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callEncryptionGenerator(EncryptionGeneratorConfig config, Map selectors, Document document, Element parent, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        EncryptionGenerator gen = (EncryptionGenerator)selectors.get(EncryptionGenerator.class);
        context.put("com.ibm.wsspi.wssecurity.config.encryptionGenerator.configKey", config);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void replaceEnvelope(SOAPEnvelope envelope, Element source, String nsSoap) throws SOAPException, SoapSecurityException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("replaceEnvelope(SOAPEnvelope envelope[" + DOMUtil.getDisplayName((Node)envelope) + "]," + "Element source[" + DOMUtil.getDisplayName((Node)source) + "]," + "String nsSoap[" + nsSoap + "])"));
        }
        NamedNodeMap attrMap = envelope.getAttributes();
        for (i = attrMap.getLength() - 1; i >= 0; --i) {
            envelope.removeAttributeNode((Attr)attrMap.item(i));
        }
        attrMap = source.getAttributes();
        int attrLength = attrMap.getLength();
        Attr[] attrs = new Attr[attrLength];
        for (i = attrLength - 1; i >= 0; --i) {
            Attr attr;
            attrs[i] = attr = source.removeAttributeNode((Attr)attrMap.item(i));
        }
        int l = attrLength;
        for (i = 0; i < l; ++i) {
            envelope.setAttributeNodeNS(attrs[i]);
        }
        envelope.removeContents();
        for (Node n2 = source.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            envelope.appendChild(n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replaceEnvelope(SOAPEnvelope envelope,Element source,String nsSoap)");
        }
    }

    private boolean checkMustUnderstand(WSSGeneratorConfig config, SOAPMessageContext messageContext) {
        boolean mustUnderstand = true;
        if (messageContext.isServer()) {
            boolean setMustUnderstand = config.getServiceGetMustUnderstand();
            if (setMustUnderstand) {
                mustUnderstand = ConfigUtil.getMustUnderstand((SOAPMessageContext)messageContext);
            }
        } else {
            mustUnderstand = config.getClientSetMustUnderstand();
        }
        ConfigUtil.setMustUnderstand((SOAPMessageContext)messageContext, (boolean)mustUnderstand);
        return mustUnderstand;
    }

    static {
        String setup_jce = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("setup-jce");
            }
        });
        if (setup_jce != null) {
            SetupJCEProviders.setup();
        }
    }
}

