/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.handler.token.TokenCacheManagerImpl;
import com.ibm.ws.webservices.wssecurity.token.TokenCacheManager;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class TokenCacheManagerFactory {
    private static final TraceComponent tc = Tr.register(TokenCacheManagerFactory.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = TokenCacheManagerFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.TokenCacheManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.TokenCacheManagerFactory.getInstance");
    private static TokenCacheManager _instance;
    private static boolean _initialized;

    private TokenCacheManagerFactory() {
    }

    public static TokenCacheManager getInstance() throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_INSTANCE_PERMISSION);
        }
        TokenCacheManager instance = null;
        if (!_initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: The token manager is not initialized.");
            }
        } else {
            instance = _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstance() returns TokenCacheManager[" + instance + "]"));
        }
        return instance;
    }

    protected static synchronized void init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout, long cushion) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("init(boolean useCache[" + useCache + "]," + "String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]" + "long cushion[" + cushion + "])"));
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(INIT_PERMISSION);
        }
        if (!_initialized) {
            _instance = useCache ? new TokenCacheManagerImpl(cacheName, cacheSize, cacheTimeout, cushion) : null;
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public String toString() {
        return clsName;
    }

    static {
        _initialized = false;
    }
}

