/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.util.DistributedMapFactory;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Properties;

class ConfigCache {
    private static final TraceComponent tc = Tr.register(ConfigCache.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = ConfigCache.class.getName();
    private static final String comp = "security.wssecurity";
    private String _cacheName;
    private DistributedMap _dm;
    private boolean _dmInitialized;
    private int _timeToLive;

    public ConfigCache(String cacheName, int size, int timeToLive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("CertCache(String cacheName[" + cacheName + "]," + "int size[" + size + "]," + "int timeToLive[" + timeToLive + "]"));
        }
        this._dm = null;
        this._timeToLive = timeToLive;
        if (cacheName == null || cacheName.length() == 0) {
            cacheName = "WSSReqGeneratorConfigMap";
        }
        Properties p = new Properties();
        p.put("com.ibm.ws.cache.CacheConfig.cacheSize", Integer.toString(size));
        p.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
        p.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
        this._dm = DistributedMapFactory.getMap(cacheName, p);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigCache(String cacheName, int size, int timeout");
        }
    }

    public Object get(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("get(Object key[" + key + "]"));
            Tr.debug((TraceComponent)tc, (String)("key class is " + key.getClass().getName()));
        }
        try {
            Object retValue = null;
            if (this._dm != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"get(Object key) returns valid Object");
                }
                return this._dm.get(key);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get(Object key) returns null");
            }
            return null;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"security.wssecurity.ConfigCache.s01", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "clsName.get", "92", this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get(Object key) returns null");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("put(Object key[" + key + "], Object value[" + value + "]"));
            Tr.debug((TraceComponent)tc, (String)("key class is " + key.getClass().getName()));
        }
        try {
            ConfigCache configCache = this;
            synchronized (configCache) {
                if (this._dm != null) {
                    Object rc = this._dm.put(key, value, 1, this._timeToLive, 1, null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("put(Object key, Object value)" + (rc != null ? "(not null)" : "(null)")));
                    }
                    return rc;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"put(Object key, Object value) returns null");
                }
                return null;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"security.wssecurity.ConfigCache.s02", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "clsName.put", "122", this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"put(Object key, Object value) returns null");
            }
            return null;
        }
    }
}

