/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.confimpl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateConsumerConfig
extends PrivateCommonConfig
implements WSSConsumerConfig {
    private static final TraceComponent tc = Tr.register(PrivateConsumerConfig.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PrivateConsumerConfig.class.getName();
    protected String _myActor = null;
    protected boolean _ultimateReceiver = false;
    protected boolean _nonceCacheDistributed = false;
    protected final Set _allowedTransforms = new HashSet();
    protected final Set _allowedCanonicalizationMethods = new HashSet();
    protected final Set _allowedSignatureMethods = new HashSet();
    protected final Set _allowedDigestMethods = new HashSet();
    protected final Set _allowedDataEncryptionMethods = new HashSet();
    protected final Set _allowedKeyEncryptionMethods = new HashSet();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set _defaultKeyInfoContentConsumers = new HashSet();
    protected final Set _defaultTokenConsumers = new HashSet();
    protected final Set _defaultJAASConfigs = new HashSet();
    protected final Set _defaultKeyLocators = new HashSet();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _verificationRequired = false;
    protected boolean _decryptionRequired = false;
    protected boolean _tokenRequired = false;
    protected boolean _loginRequired = false;
    protected boolean _timestampRequired = false;
    protected final Set _requiredIntegralParts = new HashSet();
    protected final Set _requiredConfidentialParts = new HashSet();
    protected final Set _requiredSecurityTokens = new HashSet();
    protected final Set _callers = new HashSet();
    protected final Set _signatureConsumers = new HashSet();
    protected final Set _encryptionConsumers = new HashSet();
    protected final Set _tokenConsumers = new HashSet();
    protected TimestampConsumerConfImpl _timestampConsumer = null;
    protected NonceManager _nonceManager = null;
    protected CertCacheManager _certManager = null;
    protected int _timestampMaxAge = -1;
    protected int _timestampClockSkew = -1;
    protected Map _properties = null;
    protected boolean _bypassSecurityHeader = false;

    protected void processPrivateConfig(Document pconfig) throws SoapSecurityException {
        String value;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processPrivateConfig(Document pconfig[" + pconfig + "])"));
        }
        boolean fipsMode = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is true; getting FIPS algorithms");
            }
            fipsMode = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            fipsMode = false;
        }
        NodeList list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "Transform");
        int length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedTransforms.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed Transforms:", (Object)new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s11");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedCanonicalizationMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed canonicalizationMethods:", (Object)new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s12");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedSignatureMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed signatureMethods:", (Object)new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s13");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "digestMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedDigestMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed digestMethods:", (Object)new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s14");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedDataEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed encryptionMethods:", (Object)new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s15");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(value)) continue;
            this._allowedKeyEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed keyEncryptionMethods:", (Object)new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s16");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyInfoContentConsumer");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultKeyInfoContentConsumers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default KeyInfoContentConsumer:", (Object)new Object[]{this._defaultKeyInfoContentConsumers});
        }
        if (this._defaultKeyInfoContentConsumers.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6711W");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "TokenConsumer");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultTokenConsumers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default TokenConsumer:", (Object)new Object[]{this._defaultTokenConsumers});
        }
        if (this._defaultTokenConsumers.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6712W");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "JAASConfig");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"name");
            this._defaultJAASConfigs.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default JAAS configuration:", (Object)new Object[]{this._defaultJAASConfigs});
        }
        if (this._defaultJAASConfigs.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6713W");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultKeyLocators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default KeyLocator:", (Object)new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6714W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processPrivateConfig(Document pconfig)");
        }
    }

    public void validate() throws SoapSecurityException {
        this.validate(false);
    }

    public void validate(boolean defaultConfig) throws SoapSecurityException {
        KeyInfoConsumerConfImpl kconfig;
        PrivateCommonConfig.AlgorithmConfImpl aconfig2;
        int index;
        String keyword;
        String dialect;
        PrivateCommonConfig.ReferencePartConfImpl rconfig;
        int Timestamp2;
        int Nonce2;
        int MessageParts2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("validate(boolean defaultConfig[" + defaultConfig + "])"));
        }
        HashSet<PrivateCommonConfig.ReferencePartConfImpl> tgForDsigKey = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
        HashSet<PrivateCommonConfig.ReferencePartConfImpl> tgForEncKey = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
        Iterator i = this._requiredIntegralParts.iterator();
        while (i.hasNext()) {
            MessageParts2 = 0;
            Nonce2 = 0;
            Timestamp2 = 0;
            rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
            rconfig.validate();
            if (rconfig._usage != null && ConfigUtil.isUsage((String)rconfig._usage) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s02", rconfig._usage, rconfig.toString());
            }
            for (PrivateCommonConfig.PartConfImpl pconfig : rconfig._parts) {
                pconfig.validate();
                if (pconfig.isNonce()) {
                    ++Nonce2;
                } else if (pconfig.isTimestamp()) {
                    ++Timestamp2;
                } else {
                    ++MessageParts2;
                }
                dialect = pconfig._dialect;
                keyword = pconfig._keyword;
                if (Constants.DIALECT_WAS.equals(dialect)) {
                    index = ConfigUtil.isIntegralWASDialect((String)keyword);
                    if (index == 1 && pconfig.isTimestamp()) {
                        throw new SoapSecurityException("security.wssecurity.TimestampGenerator.s02");
                    }
                    if (index == 3) {
                        tgForDsigKey.add(rconfig);
                        continue;
                    }
                    if (index == 4) {
                        tgForEncKey.add(rconfig);
                        continue;
                    }
                    if (index >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, pconfig.toString());
                }
                if (Constants.DIALECT_FUNCTION.equals(dialect)) {
                    if (keyword != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                }
                if (Constants.DIALECT_XPATH.equals(dialect)) {
                    if (keyword != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, pconfig.toString());
            }
            if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        i = this._requiredConfidentialParts.iterator();
        while (i.hasNext()) {
            MessageParts2 = 0;
            Nonce2 = 0;
            Timestamp2 = 0;
            rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
            rconfig.validate();
            if (rconfig._usage != null && ConfigUtil.isUsage((String)rconfig._usage) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s02", rconfig._usage, rconfig.toString());
            }
            for (PrivateCommonConfig.PartConfImpl pconfig : rconfig._parts) {
                pconfig.validate();
                if (pconfig.isNonce()) {
                    ++Nonce2;
                } else if (pconfig.isTimestamp()) {
                    ++Timestamp2;
                } else {
                    ++MessageParts2;
                }
                dialect = pconfig._dialect;
                keyword = pconfig._keyword;
                if (Constants.DIALECT_WAS.equals(dialect)) {
                    if (ConfigUtil.isConfidentialWASDialect((String)keyword) >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, pconfig.toString());
                }
                if (Constants.DIALECT_FUNCTION.equals(dialect)) {
                    if (keyword != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                }
                if (Constants.DIALECT_XPATH.equals(dialect)) {
                    if (keyword != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, pconfig.toString());
            }
            if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        if (defaultConfig) {
            HashMap<QName, TokenConsumerConfImpl> consumersMap = new HashMap<QName, TokenConsumerConfImpl>();
            for (TokenConsumerConfImpl tconfig : this._tokenConsumers) {
                consumersMap.put(tconfig.getType(), tconfig);
            }
            for (TokenConsumerConfImpl tconfig : this._requiredSecurityTokens) {
                QName tctype = tconfig.getType();
                TokenConsumerConfImpl tc2 = (TokenConsumerConfImpl)consumersMap.get(tctype);
                if (tc2 == null) {
                    String msg = "There is a required security token that does not have a matching token consumer. Its name is [" + tconfig._name + "] and its type is [" + tctype + "].";
                    throw new SoapSecurityException(msg);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found token consumer of type [" + tctype + "]."));
            }
        } else {
            for (TokenConsumerConfImpl tconfig : this._requiredSecurityTokens) {
                if (this._tokenConsumers.contains(tconfig)) continue;
                String msg = "There is a required security token that no token consumer references. Its name is [" + tconfig._name + "].";
                throw new SoapSecurityException(msg);
            }
        }
        if (this._callers != null) {
            for (CallerConfImpl cconfig : this._callers) {
                cconfig.validate();
                QName type = cconfig._tokenType;
                rconfig = cconfig._part;
                if (rconfig != null && (Constants.UNTOKEN.equals(type) || Constants.KERBEROSV5_ST.equals(type) || Constants.KERBEROSV5_TGT.equals(type))) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s06", cconfig.toString());
                }
                if (rconfig != null && !ConfigUtil.isUsageRequired((String)rconfig._usage)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s33", cconfig.toString());
                }
                if (!this.checkCallerRequired(this._tokenConsumers)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s34", type.toString());
                }
                CallerConfImpl tmconfig = cconfig._trustMethod;
                if (tmconfig == null) continue;
                type = tmconfig._tokenType;
                rconfig = tmconfig._part;
                if (rconfig != null && (type == null || Constants.UNTOKEN.equals(type) || Constants.KERBEROSV5_ST.equals(type) || Constants.KERBEROSV5_TGT.equals(type))) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s07", tmconfig.toString());
                }
                if (rconfig != null && !ConfigUtil.isUsageRequired((String)rconfig._usage)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s33", tmconfig.toString());
                }
                if (type == null || this.checkTrustMethodRequired(this._tokenConsumers)) continue;
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s34", type.toString());
            }
        }
        for (SignatureConsumerConfImpl sconfig : this._signatureConsumers) {
            sconfig.validate(defaultConfig);
            aconfig2 = sconfig._canonicalizationMethod;
            if (aconfig2 != null) {
                aconfig2.validate();
                if (!this._allowedCanonicalizationMethods.contains(aconfig2._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", aconfig2._algorithm);
                }
            }
            aconfig2 = sconfig._signatureMethod;
            boolean isSecretKeyAlgorithm = false;
            String secretKeyAlgorithm = null;
            if (aconfig2 != null) {
                aconfig2.validate();
                if (!this._allowedSignatureMethods.contains(aconfig2._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", aconfig2._algorithm);
                }
                secretKeyAlgorithm = aconfig2._algorithm;
                isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm((String)secretKeyAlgorithm);
            }
            if ((aconfig2 = sconfig._keyInfoSignature) != null) {
                aconfig2.validate();
                if (ConfigUtil.isKeyInfoSignature((String)aconfig2._algorithm) < 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s10", aconfig2._algorithm);
                }
            }
            PrivateCommonConfig.ReferencePartConfImpl requiredTG = null;
            for (PrivateCommonConfig.SigningReferenceConfImpl srconfig : sconfig.getReferences()) {
                srconfig.validate();
                aconfig2 = srconfig._digestMethod;
                if (aconfig2 != null) {
                    aconfig2.validate();
                    if (!this._allowedDigestMethods.contains(aconfig2._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", aconfig2._algorithm);
                    }
                }
                boolean strTransform = false;
                for (PrivateCommonConfig.AlgorithmConfImpl aconfig2 : srconfig.getTransforms()) {
                    aconfig2.validate();
                    if (!this._allowedTransforms.contains(aconfig2._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", aconfig2._algorithm);
                    }
                    if ("http://www.w3.org/2002/07/decrypt#XML".equals(aconfig2._algorithm)) {
                        sconfig._isDecryptionXformEnabled = true;
                        continue;
                    }
                    if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(aconfig2._algorithm)) continue;
                    strTransform = true;
                }
                if (!strTransform || requiredTG != null) continue;
                if (tgForDsigKey.contains(srconfig._reference)) {
                    requiredTG = srconfig._reference;
                    continue;
                }
                if (!tgForEncKey.contains(srconfig._reference)) continue;
                requiredTG = srconfig._reference;
            }
            kconfig = sconfig._signingKeyInfo;
            kconfig.validate();
            for (KeyInfoContentConsumerConfImpl kcconfig : kconfig._contentConsumers) {
                kcconfig.validate();
                if (ConfigUtil.isKeyInfoType((String)kcconfig._keyInfoType) < 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", kcconfig.toString());
                }
                if (isSecretKeyAlgorithm) {
                    if (ConfigUtil.isKeyInfoEmb((String)kcconfig._keyInfoType)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                    }
                    if (!ConfigUtil.isKeyInfoX509issuer((String)kcconfig._keyInfoType)) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                }
                if (requiredTG == null || kcconfig._tokenConsumer != null) continue;
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s35");
            }
            this.checkIdentity(sconfig, this._signatureConsumers);
        }
        int size = this._signatureConsumers.size();
        if (size > 1) {
            for (SignatureConsumerConfImpl sconfig : this._signatureConsumers) {
                kconfig = sconfig._signingKeyInfo;
                for (SignatureConsumerConfImpl tmp : this._signatureConsumers) {
                    if (sconfig.equals(tmp)) continue;
                    kconfig._otherContentConsumers.addAll(tmp._signingKeyInfo._contentConsumers);
                }
            }
        }
        for (EncryptionConsumerConfImpl econfig : this._encryptionConsumers) {
            econfig.validate(defaultConfig);
            aconfig2 = econfig._dataEncryptionMethod;
            aconfig2.validate();
            if (!this._allowedDataEncryptionMethods.contains(aconfig2._algorithm)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", aconfig2._algorithm);
            }
            String secretKeyAlgorithm = aconfig2._algorithm;
            boolean isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm((String)secretKeyAlgorithm);
            aconfig2 = econfig._keyEncryptionMethod;
            if (aconfig2 != null) {
                aconfig2.validate();
                if (!this._allowedKeyEncryptionMethods.contains(aconfig2._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", aconfig2._algorithm);
                }
                secretKeyAlgorithm = aconfig2._algorithm;
                isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm((String)secretKeyAlgorithm);
            }
            kconfig = econfig._encryptionKeyInfo;
            kconfig.validate();
            for (KeyInfoContentConsumerConfImpl kcconfig : kconfig._contentConsumers) {
                kcconfig.validate();
                if (ConfigUtil.isKeyInfoType((String)kcconfig._keyInfoType) < 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", kcconfig.toString());
                }
                if (!isSecretKeyAlgorithm) continue;
                if (ConfigUtil.isKeyInfoEmb((String)kcconfig._keyInfoType)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                }
                if (!ConfigUtil.isKeyInfoX509issuer((String)kcconfig._keyInfoType)) continue;
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
            }
            this.checkIdentity(econfig, this._encryptionConsumers);
        }
        size = this._encryptionConsumers.size();
        if (size > 1) {
            for (EncryptionConsumerConfImpl econfig : this._encryptionConsumers) {
                kconfig = econfig._encryptionKeyInfo;
                for (EncryptionConsumerConfImpl tmp : this._encryptionConsumers) {
                    if (econfig.equals(tmp)) continue;
                    kconfig._otherContentConsumers.addAll(tmp._encryptionKeyInfo._contentConsumers);
                }
            }
        }
        for (TokenConsumerConfImpl tconfig : this._tokenConsumers) {
            tconfig.validate();
            if (tconfig._trustAnchorKeyStore != null) {
                tconfig._trustAnchorKeyStore.validate();
            }
            if (tconfig._usage != null && ConfigUtil.isUsage((String)tconfig._usage) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s02", tconfig._usage, tconfig.toString());
            }
            if (!this._requiredSecurityTokens.contains(tconfig)) continue;
            if (tconfig._usedForVerification) {
                String msg = "The token consumer [" + tconfig._name + "] that refers to the required security token in DD is used for signature verification." + " The required security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
                throw new SoapSecurityException(msg);
            }
            if (!tconfig._usedForDecryption) continue;
            String msg = "The token consumer [" + tconfig._name + "] that refers to the required security token in DD is used for decryption." + " The required security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
            throw new SoapSecurityException(msg);
        }
        if (this._timestampConsumer != null) {
            this._timestampConsumer.validate();
            String value = (String)this._timestampConsumer._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT);
            if (value != null && Constants.DIALECT_WAS.equals(value) && (value = (String)this._timestampConsumer._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD)) != null && (index = ConfigUtil.isTimestampWASDialect((String)value)) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", value, this._timestampConsumer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate(boolean)");
        }
    }

    public String getMyActor() {
        return this._myActor;
    }

    public boolean isUltimateReceiver() {
        return this._ultimateReceiver;
    }

    public boolean isNonceCacheDistributed() {
        return this._nonceCacheDistributed;
    }

    public Set getAllowedTransforms() {
        return this._allowedTransforms;
    }

    public Set getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    public Set getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    public Set getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    public Set getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    public Set getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    public boolean isVerificationRequired() {
        return this._verificationRequired;
    }

    public boolean isDecryptionRequired() {
        return this._decryptionRequired;
    }

    public boolean isTokenRequired() {
        return this._tokenRequired;
    }

    public boolean isLoginRequired() {
        return this._loginRequired;
    }

    public boolean isTimestampRequired() {
        return this._timestampRequired;
    }

    public Set getRequiredIntegralParts() {
        return this._requiredIntegralParts;
    }

    public Set getRequiredConfidentialParts() {
        return this._requiredConfidentialParts;
    }

    public Set getRequiredSecurityTokens() {
        return this._requiredSecurityTokens;
    }

    public Set getCallers() {
        return this._callers;
    }

    public Set getSignatureConsumers() {
        return this._signatureConsumers;
    }

    public Set getEncryptionConsumers() {
        return this._encryptionConsumers;
    }

    public Set getTokenConsumers() {
        return this._tokenConsumers;
    }

    public TimestampConsumerConfig getTimestampConsumer() {
        return this._timestampConsumer;
    }

    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    public CertCacheManager getCertManager() {
        return this._certManager;
    }

    public int getTimestampMaxAge() {
        return this._timestampMaxAge;
    }

    public int getTimestampClockSkew() {
        return this._timestampClockSkew;
    }

    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    public Map getProperties() {
        return this._properties;
    }

    public Object getProperty(Object property) {
        if (this._properties != null) {
            return this._properties.get(property);
        }
        return null;
    }

    protected String getLogProperties(Map defaultProps, Map extProps, Map bndProps, String reqRespTypeIn) {
        String logProps = null;
        if (tc.isDebugEnabled()) {
            logProps = super.getLogProperties(defaultProps, extProps, bndProps, this._properties, reqRespTypeIn, "consumer");
        }
        return logProps;
    }

    public String toSring() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("myActor=[").append(this._myActor).append("], ");
        buf.append("ultimateReceiver=[").append(this._ultimateReceiver).append("], ");
        buf.append("nonceCacheDistributed=[").append(this._nonceCacheDistributed).append("], ");
        buf.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        buf.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        buf.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        buf.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        buf.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        buf.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        buf.append("algorithmFactory=[").append((Object)this._algorithmFactory).append("], ");
        buf.append("verificationRequired=[").append(this._verificationRequired).append("], ");
        buf.append("decryptionRequired=[").append(this._decryptionRequired).append("], ");
        buf.append("tokenRequired=[").append(this._tokenRequired).append("], ");
        buf.append("timestampRequired=[").append(this._timestampRequired).append("], ");
        buf.append("requiredIntegralParts=[").append(this._requiredIntegralParts).append("], ");
        buf.append("requiredConfidentialParts=[").append(this._requiredConfidentialParts).append("], ");
        buf.append("callers=[").append(this._callers).append("], ");
        buf.append("signatureConsumers=[").append(this._signatureConsumers).append("], ");
        buf.append("encryptionConsumers=[").append(this._encryptionConsumers).append("], ");
        buf.append("tokenConsumers=[").append(this._tokenConsumers).append("], ");
        buf.append("timestampConsumer=[").append(this._timestampConsumer).append("], ");
        buf.append("nonceManager=[").append(this._nonceManager).append("], ");
        buf.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
        buf.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
        buf.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        buf.append("bypassSecurityHeader=[").append(this._bypassSecurityHeader).append("], ");
        buf.append("properties=[").append(this._properties).append("]");
        buf.append(")");
        return buf.toString();
    }

    private boolean checkCallerRequired(Set tokenConsumers) {
        boolean ret = false;
        for (TokenConsumerConfImpl tconfig : tokenConsumers) {
            if (!tconfig._callerRequired) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean checkTrustMethodRequired(Set tokenConsumers) {
        boolean ret = false;
        for (TokenConsumerConfImpl tconfig : tokenConsumers) {
            if (!tconfig._trustMethodRequired) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void checkIdentity(SignatureConsumerConfImpl sconfig, Set signatureConsumers) {
        if (signatureConsumers.size() > 1) {
            String c14nMethod = sconfig._canonicalizationMethod._algorithm;
            String signMethod = sconfig._signatureMethod._algorithm;
            String kiSign = sconfig._keyInfoSignature == null ? null : sconfig._keyInfoSignature._algorithm;
            List references = sconfig._references;
            List kics = sconfig._signingKeyInfo._contentConsumers;
            boolean sameKISign = true;
            for (SignatureConsumerConfImpl config : signatureConsumers) {
                if (config.equals(sconfig) || !c14nMethod.equals(config._canonicalizationMethod._algorithm) || !signMethod.equals(config._signatureMethod._algorithm)) continue;
                PrivateCommonConfig.AlgorithmConfImpl aconfig2 = config._keyInfoSignature;
                for (PrivateCommonConfig.SigningReferenceConfImpl sref : references) {
                    ArrayList<VerifiedConfig> vlist = (ArrayList<VerifiedConfig>)sconfig._identity.get(sref);
                    if (vlist == null) {
                        vlist = new ArrayList<VerifiedConfig>();
                        sconfig._identity.put(sref, vlist);
                    }
                    String digestMethod = sref._digestMethod._algorithm;
                    HashSet<String> transforms = new HashSet<String>();
                    for (PrivateCommonConfig.AlgorithmConfImpl aconfig2 : sref._transforms) {
                        transforms.add(aconfig2._algorithm);
                    }
                    for (PrivateCommonConfig.SigningReferenceConfImpl srconfig : config._references) {
                        if (!digestMethod.equals(srconfig._digestMethod._algorithm)) continue;
                        boolean sameTransform = true;
                        for (PrivateCommonConfig.AlgorithmConfImpl aconfig2 : srconfig._transforms) {
                            if (transforms.contains(aconfig2._algorithm)) continue;
                            sameTransform = false;
                            break;
                        }
                        if (!sameTransform) continue;
                        vlist.add(new VerifiedConfig(config, srconfig));
                    }
                }
            }
        }
    }

    private void checkIdentity(EncryptionConsumerConfImpl econfig, Set encryptionConsumers) {
        if (encryptionConsumers.size() > 1) {
            String dataEncMethod = econfig._dataEncryptionMethod._algorithm;
            String keyEncMethod = econfig._keyEncryptionMethod == null ? null : econfig._keyEncryptionMethod._algorithm;
            List kics = econfig._encryptionKeyInfo._contentConsumers;
            for (EncryptionConsumerConfImpl config : encryptionConsumers) {
                if (config.equals(econfig) || !dataEncMethod.equals(config._dataEncryptionMethod._algorithm)) continue;
                PrivateCommonConfig.AlgorithmConfImpl aconfig = config._keyEncryptionMethod;
                if (keyEncMethod == null ? aconfig != null : aconfig == null || !keyEncMethod.equals(aconfig._algorithm)) continue;
                econfig._identity.add(config);
            }
        }
    }

    public boolean getBypassSecurityHeaderSetting() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled=" + this._bypassSecurityHeader));
        }
        return this._bypassSecurityHeader;
    }

    public static class KeyInfoContentConsumerConfImpl
    implements KeyInfoContentConsumerConfig {
        public String _className = null;
        public KeyInfoContentConsumerComponent _instance = null;
        public String _keyInfoType = null;
        public KeyLocator _keyLocator = null;
        public String _keyName = null;
        public TokenConsumerConfImpl _tokenConsumer = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
            if (this._keyInfoType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s26", this.toString());
            }
        }

        public KeyInfoContentConsumerComponent getInstance() {
            return this._instance;
        }

        public String getKeyInfoType() {
            return this._keyInfoType;
        }

        public KeyLocator getKeyLocator() {
            return this._keyLocator;
        }

        public String getKeyName() {
            return this._keyName;
        }

        public TokenConsumerConfig getTokenConsumer() {
            return this._tokenConsumer;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("keyInfoType=[").append(this._keyInfoType).append("], ");
            buf.append("keyLocator=[").append(this._keyLocator).append("], ");
            buf.append("tokenConsumer=[").append(this._tokenConsumer).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class KeyInfoConsumerConfImpl
    implements KeyInfoConsumerConfig {
        public List _contentConsumers = null;
        public final List _otherContentConsumers = new ArrayList();

        public void validate() throws SoapSecurityException {
            if (this._contentConsumers == null || this._contentConsumers.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s24", this.toString());
            }
        }

        public List getContentConsumers() {
            return this._contentConsumers;
        }

        public List getOtherContentConsumers() {
            return this._otherContentConsumers;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("contentConsumers=[").append(this._contentConsumers).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TimestampConsumerConfImpl
    implements TimestampConsumerConfig {
        public String _actor = null;
        public int _timestampMaxAge = 300;
        public int _timestampClockSkew = 0;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
        }

        public String getActor() {
            return this._actor;
        }

        public int getTimestampMaxAge() {
            return this._timestampMaxAge;
        }

        public int getTimestampClockSkew() {
            return this._timestampClockSkew;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("actor=[").append(this._actor).append("], ");
            buf.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
            buf.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TokenConsumerConfImpl
    implements TokenConsumerConfig {
        public String _name = null;
        public String _className = null;
        public TokenConsumerComponent _instance = null;
        public String _usage = null;
        public QName _type = null;
        public TrustedIDEvaluator _trustedIDEvaluator = null;
        public boolean _trustAny = false;
        public Provider _provider = null;
        public PKIXBuilderParameters _pkixBuilderParams = null;
        public boolean _callerRequired = false;
        public Map _callerProperties = null;
        public boolean _trustMethodRequired = false;
        public Map _trustMethodProperties = null;
        public String _jaasConfig = null;
        public final Map _jaasConfigProperties = new HashMap();
        public boolean _usedForVerification = false;
        public boolean _usedForDecryption = false;
        public final Map _properties = new HashMap();
        private volatile boolean _initialized = false;
        public List _certStores = new ArrayList();
        public String _trustAnchorRef = null;
        public com.ibm.ws.webservices.wssecurity.config.KeyStore _trustAnchorKeyStore = null;

        public void validate() throws SoapSecurityException {
            String cspConstant;
            String csp;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TokenConsumerConfImpl.validate");
            }
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s22", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s23", this.toString());
            }
            if (this._certStores.isEmpty() && this._provider == null && ConfigUtil.hasValue((String)(csp = (String)this._properties.get(cspConstant = "com.ibm.wsspi.wssecurity.config.CertStore.Provider")))) {
                throw new SoapSecurityException("The cert store security provider '" + csp + "' active for the token consumer '" + this._name + "' does not exist.  The cert store security provider is " + "configured on the '" + cspConstant + "' property.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TokenConsumerConfImpl.validate");
            }
        }

        protected synchronized void initCerts() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initCerts()");
            }
            if (this._initialized) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initCerts()");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_pkixBuilderParams is " + this._pkixBuilderParams));
                Tr.debug((TraceComponent)tc, (String)("_trustAnchorKeyStore is " + this._trustAnchorKeyStore));
                Tr.debug((TraceComponent)tc, (String)("_trustAnchorRef is " + this._trustAnchorRef));
            }
            if (this._pkixBuilderParams == null && this._trustAnchorKeyStore != null) {
                String msgKey;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Getting java.security.KeyStore instance from trust anchor " + this._trustAnchorRef));
                }
                KeyStore kstore = this._trustAnchorKeyStore.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Got java.security.KeyStore instance: " + kstore));
                }
                if (kstore == null) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.ConfigValidation.keystore.taref.open", (Object)new Object[]{this._trustAnchorRef});
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating X509CertSelector.");
                    }
                    X509CertSelector selector = new X509CertSelector();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating PKIXBuilderParameters.");
                    }
                    this._pkixBuilderParams = new PKIXBuilderParameters(kstore, (CertSelector)selector);
                    this._pkixBuilderParams.setDate(null);
                }
                catch (InvalidAlgorithmParameterException e) {
                    msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                    FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "1291", this);
                    Tr.warning((TraceComponent)tc, (String)msgKey, (Object)new Object[]{e});
                }
                catch (KeyStoreException e) {
                    msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                    FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "1295", this);
                    Tr.warning((TraceComponent)tc, (String)msgKey, (Object)new Object[]{e});
                }
            }
            if (this._certStores != null) {
                Iterator it;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_certStores is non-null");
                }
                if (!(it = this._certStores.iterator()).hasNext() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_certStores is empty");
                }
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof CollectionCertStore) {
                        CollectionCertStore ccs;
                        CertStore cs;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Instance is a CollectionCertStore, creating CertStore instance.");
                        }
                        if ((cs = (ccs = (CollectionCertStore)obj).getInstance()) != null) {
                            if (this._pkixBuilderParams != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Adding CertStore to pkixBuilderParams.");
                                }
                                this._pkixBuilderParams.addCertStore(cs);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"pkixBuilderParams was null; not adding CertStore.");
                            }
                            this._provider = cs.getProvider();
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"CollectionCertStore.getInstance() returned null.");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Instance not a CollectionCertStore, nothing to do.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"_certStores is null");
            }
            this._initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initCerts()");
            }
        }

        public TokenConsumerComponent getInstance() {
            return this._instance;
        }

        public String getUsage() {
            return this._usage;
        }

        public QName getType() {
            return this._type;
        }

        public TrustedIDEvaluator getTrustedIDEvaluator() {
            return this._trustedIDEvaluator;
        }

        public boolean isTrustAnyCertificate() {
            return this._trustAny;
        }

        public Provider getProvider() {
            this.initCerts();
            return this._provider;
        }

        public PKIXBuilderParameters getPKIXBuilderParameters() {
            this.initCerts();
            return this._pkixBuilderParams;
        }

        public boolean isCallerRequired() {
            return this._callerRequired;
        }

        public Map getCallerProperties() {
            return this._callerProperties;
        }

        public boolean isTrustMethodRequired() {
            return this._trustMethodRequired;
        }

        public Map getTrustMethodProperties() {
            return this._trustMethodProperties;
        }

        public String getJAASConfig() {
            return this._jaasConfig;
        }

        public Map getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        public boolean isUsedForVerification() {
            return this._usedForVerification;
        }

        public boolean isUsedForDecryption() {
            return this._usedForDecryption;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("usage=[").append(this._usage).append("], ");
            buf.append("type=[").append(this._type).append("], ");
            buf.append("trustedIdEvaluator=[").append(this._trustedIDEvaluator).append("], ");
            buf.append("trustAny=[").append(this._trustAny).append("], ");
            buf.append("provider=[").append(this._provider).append("], ");
            buf.append("pkixBuilderParams=[").append(this._pkixBuilderParams).append("], ");
            buf.append("callerRequired=[").append(this._callerRequired).append("], ");
            buf.append("callerProperties=[").append(this._callerProperties).append("], ");
            buf.append("trustMethodRequired=[").append(this._trustMethodRequired).append("], ");
            buf.append("trustMethodProperties=[").append(this._trustMethodProperties).append("], ");
            buf.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            buf.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            buf.append("usedForVerification=[").append(this._usedForVerification).append("], ");
            buf.append("usedForDecryption=[").append(this._usedForDecryption).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class EncryptionConsumerConfImpl
    implements EncryptionConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoConsumerConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public final Map _properties = new HashMap();
        public final List _identity = new ArrayList();

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s20", this.toString());
            }
            if (this._reference == null && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        public KeyInfoConsumerConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        public ReferencePartConfig getReference() {
            return this._reference;
        }

        public Map getProperties() {
            return this._properties;
        }

        public List getIdentityList() {
            return this._identity;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            buf.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            buf.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            buf.append("reference=[").append(this._reference).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class SignatureConsumerConfImpl
    implements SignatureConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoConsumerConfImpl _signingKeyInfo = null;
        public final List _references = new ArrayList();
        public final Map _properties = new HashMap();
        public final Map _identity = new HashMap();
        private boolean _isDecryptionXformEnabled = false;

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s17", this.toString());
            }
            if (this._references.isEmpty() && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        public KeyInfoConsumerConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        public List getReferences() {
            return this._references;
        }

        public Map getProperties() {
            return this._properties;
        }

        public Map getIdentityMap() {
            return this._identity;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            buf.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            buf.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            buf.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            buf.append("refereces=[").append(this._references).append("], ");
            buf.append("properties=[").append(this._properties).append("], ");
            buf.append("isDecryptionXformEnabled=[").append(this._isDecryptionXformEnabled).append("], ");
            buf.append(")");
            return buf.toString();
        }

        public boolean isDecryptionTransformEnabled() {
            return this._isDecryptionXformEnabled;
        }
    }

    public static class CallerConfImpl
    implements WSSConsumerConfig.CallerConfig {
        public PrivateCommonConfig.ReferencePartConfImpl _part = null;
        public QName _tokenType = null;
        public QName _tokenConsumerType = null;
        public CallerConfImpl _trustMethod = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._tokenType == null || this._tokenConsumerType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s16", this.toString());
            }
        }

        public ReferencePartConfig getPart() {
            return this._part;
        }

        public QName getTokenType() {
            return this._tokenType;
        }

        public QName getTokenConsumerType() {
            return this._tokenConsumerType;
        }

        public WSSConsumerConfig.CallerConfig getTrustMethod() {
            return this._trustMethod;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("part=[").append(this._part).append("], ");
            buf.append("tokenType=[").append(this._tokenType).append("], ");
            buf.append("tokenConsumerType=[").append(this._tokenConsumerType).append("], ");
            buf.append("trustMethod=[").append(this._trustMethod).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }
}

