/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import java.security.cert.CertStore;

public final class LDAPCertStore {
    private com.ibm.etools.webservice.wscommonbnd.LDAPCertStore _ldapCertStore = null;
    private VariableMap _varMap = null;
    private String _name = null;
    private CertStore _certStore = null;
    private static final String comp = "security.wssecurity";
    private static final String clsName = LDAPCertStore.class.getName();
    private static final TraceComponent tc = Tr.register(LDAPCertStore.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public LDAPCertStore(com.ibm.etools.webservice.wscommonbnd.LDAPCertStore ldapCertStore, VariableMap varMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LDAPCertStore(ldapCertStore, varMap):", new Object[]{ldapCertStore, varMap});
        }
        this._ldapCertStore = ldapCertStore;
        this._varMap = varMap;
        this._name = ldapCertStore != null ? ldapCertStore.getName() : "";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LDAPCertStore()");
        }
    }

    public synchronized CertStore getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (this._certStore == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Opening LDAPCertStore \"" + this._name + "\"");
            }
            try {
                this._certStore = ConfigConstants.readLDAPCertStore(this._ldapCertStore, this._varMap);
            }
            catch (SoapSecurityException e) {
                FFDCFilter.processException((Throwable)e, clsName + ".getInstance", "64", this);
                Tr.error(tc, "security.wssecurity.load.ldapcertstore.failed", new Object[]{this._name, e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns " + this._certStore);
        }
        return this._certStore;
    }
}

