/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.wssecurity.core.KRBCredentialsFactory;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public final class KRBContext {
    private GSSCredential gssCred;
    private GSSContext gssContext;
    private static TraceComponent tc = Tr.register(KRBContext.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public KRBContext(GSSCredential aGSSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBContext");
        }
        this.gssCred = aGSSCredential;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBContext");
        }
    }

    public byte[] begin(byte[] request) throws GSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "begin");
        }
        this.gssContext = KRBCredentialsFactory.getMgr().createContext(this.gssCred);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "begin: before acceptSecContext context");
        }
        byte[] response = this.gssContext.acceptSecContext(request, 0, request.length);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "begin: after acceptSecContext context");
        }
        if (!this.gssContext.isEstablished()) {
            String responsebytes = "null";
            if (response != null) {
                responsebytes = KRB5Util.showHex(response);
            }
            Tr.error(tc, "security.wssecurity.kerberos.bad.token", new Object[]{responsebytes});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "gssContext.getLifetime" + this.gssContext.getLifetime());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "begin");
        }
        return response;
    }

    public boolean isEstablshed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEstablshed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEstablshed");
        }
        return this.gssContext == null ? false : this.gssContext.isEstablished();
    }

    public void dispose() throws GSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose");
        }
        this.gssContext.dispose();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose");
        }
    }

    public final String getPrincipalName() throws GSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrincipalName");
        }
        GSSName name = this.gssContext.getSrcName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrincipalName");
        }
        return ((Object)name).toString();
    }

    public GSSCredential getDelegateCred() throws GSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelegateCred");
        }
        GSSCredential result = null;
        if (this.gssContext != null && this.gssContext.getCredDelegState()) {
            result = this.gssContext.getDelegCred();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting Delegate Credential, done.");
            }
        } else if (tc.isEntryEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get Delegate Credential - gssContext " + this.gssContext);
            }
            if (this.gssContext != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "state:" + this.gssContext.getCredDelegState());
                Tr.debug(tc, "cred:" + this.gssContext.getDelegCred());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDelegateCred");
        }
        return result;
    }
}

