/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.utils;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.extensions.ExtensionUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;

public class OperationDescBuilder {
    BindingEntry be;
    BindingOperationEntry boe;
    SymbolTable symbolTable;
    ODesc oDesc;

    public static OperationDescBuilder create(BindingOperationEntry boe, BindingEntry be, SymbolTable symbolTable) {
        OperationDescBuilder odb = new OperationDescBuilder(boe, be, symbolTable);
        odb.init();
        return odb;
    }

    private OperationDescBuilder(BindingOperationEntry boe, BindingEntry be, SymbolTable symbolTable) {
        this.boe = boe;
        this.be = be;
        this.symbolTable = symbolTable;
    }

    public OperationDesc getOperationDesc(boolean isAgnostic) {
        ParameterDesc[] params = new ParameterDesc[this.oDesc.params.length];
        ParameterDesc returnDesc = null;
        for (int i = -1; i < this.oDesc.params.length; ++i) {
            ParameterDesc param = null;
            PDesc pDesc = i == -1 ? this.oDesc.returnDesc : this.oDesc.params[i];
            if (pDesc != null) {
                param = new ParameterDesc(pDesc.qName, pDesc.mode, pDesc.typeQName, pDesc.javaType, pDesc.isReturn, pDesc.inHeader, pDesc.outHeader, pDesc.minOccursIs0, pDesc.maxOccursIs1, pDesc.wsdl11MIME);
                if (pDesc.map.size() > 0) {
                    param.setOptions(pDesc.map);
                }
            }
            if (i == -1) {
                returnDesc = param;
                continue;
            }
            params[i] = param;
        }
        FaultDesc[] faults = new FaultDesc[this.oDesc.faults.length];
        for (int i = 0; i < this.oDesc.faults.length; ++i) {
            faults[i] = new FaultDesc(this.oDesc.faults[i].faultCode, this.oDesc.faults[i].messageQName, this.oDesc.faults[i].className, this.oDesc.faults[i].partQName, this.oDesc.faults[i].partXmlType);
            if (this.oDesc.faults[i].map.size() <= 0) continue;
            faults[i].setOptions(this.oDesc.faults[i].map);
        }
        OperationDesc operationDesc = new OperationDesc(this.oDesc.name, this.oDesc.elementQName, params, returnDesc, faults, isAgnostic ? "" : this.oDesc.soapAction);
        if (!isAgnostic) {
            operationDesc.setUse(this.oDesc.use);
        }
        operationDesc.setStyle(this.oDesc.style);
        if (this.oDesc.map.size() > 0) {
            operationDesc.setOptions(this.oDesc.map);
        }
        return operationDesc;
    }

    public void writeOperationDesc(PrintWriter pw, boolean isAgnostic, String indent, String opDescVar, int suffixId) throws IOException {
        FDesc fDesc;
        PDesc pDesc;
        int i;
        pw.println(indent + "com.ibm.ws.webservices.engine.description.ParameterDesc[] " + " _params" + suffixId + " = new com.ibm.ws.webservices.engine.description.ParameterDesc[] {");
        for (i = 0; i < this.oDesc.params.length; ++i) {
            pDesc = this.oDesc.params[i];
            pw.println(indent + " " + "new com.ibm.ws.webservices.engine.description.ParameterDesc(" + this.toString(pDesc.qName) + ", " + this.modeToString(pDesc.mode) + ", " + this.toString(pDesc.typeQName) + ", " + pDesc.javaType + ".class, " + this.toString(pDesc.isReturn) + ", " + this.toString(pDesc.inHeader) + ", " + this.toString(pDesc.outHeader) + ", " + this.toString(pDesc.minOccursIs0) + ", " + this.toString(pDesc.maxOccursIs1) + ", " + this.toString(pDesc.wsdl11MIME) + "), ");
        }
        pw.println(indent + "  };");
        for (i = 0; i < this.oDesc.params.length; ++i) {
            pDesc = this.oDesc.params[i];
            this.writeProperties(pw, indent, "_params" + suffixId + "[" + i + "]", pDesc.map);
        }
        pDesc = this.oDesc.returnDesc;
        pw.print(indent + "com.ibm.ws.webservices.engine.description.ParameterDesc " + " _returnDesc" + suffixId + " = ");
        if (pDesc == null) {
            pw.println("null;");
        } else {
            pw.println("new com.ibm.ws.webservices.engine.description.ParameterDesc(" + this.toString(pDesc.qName) + ", " + this.modeToString(pDesc.mode) + ", " + this.toString(pDesc.typeQName) + ", " + pDesc.javaType + ".class, " + this.toString(pDesc.isReturn) + ", " + this.toString(pDesc.inHeader) + ", " + this.toString(pDesc.outHeader) + ", " + this.toString(pDesc.minOccursIs0) + ", " + this.toString(pDesc.maxOccursIs1) + ", " + this.toString(pDesc.wsdl11MIME) + "); ");
            this.writeProperties(pw, indent, "_returnDesc" + suffixId, pDesc.map);
        }
        pw.println(indent + "com.ibm.ws.webservices.engine.description.FaultDesc[] " + " _faults" + suffixId + " = new com.ibm.ws.webservices.engine.description.FaultDesc[] {");
        for (i = 0; i < this.oDesc.faults.length; ++i) {
            fDesc = this.oDesc.faults[i];
            pw.println(indent + " " + "new com.ibm.ws.webservices.engine.description.FaultDesc(" + this.toString(fDesc.faultCode) + ", " + this.toString(fDesc.messageQName) + ", " + "\"" + fDesc.className + "\", " + this.toString(fDesc.partQName) + ", " + this.toString(fDesc.partXmlType) + "), ");
        }
        pw.println(indent + "  };");
        for (i = 0; i < this.oDesc.faults.length; ++i) {
            fDesc = this.oDesc.faults[i];
            this.writeProperties(pw, indent, "_faults" + suffixId + "[" + i + "]", fDesc.map);
        }
        pw.println(indent + opDescVar + " = new com.ibm.ws.webservices.engine.description.OperationDesc(" + "\"" + this.oDesc.name + "\", " + this.toString(this.oDesc.elementQName) + ", " + "_params" + suffixId + ", " + "_returnDesc" + suffixId + ", " + "_faults" + suffixId + ", " + (isAgnostic ? "null" : "\"" + this.oDesc.soapAction + "\"") + ");");
        this.writeProperties(pw, indent, opDescVar, this.oDesc.map);
        if (!isAgnostic) {
            pw.println(indent + opDescVar + ".setUse(" + this.writeUse(this.oDesc.use) + ");");
        }
        pw.println(indent + opDescVar + ".setStyle(" + this.writeStyle(this.oDesc.style) + ");");
    }

    public void writeProperties(PrintWriter pw, String indent, String var, HashMap map) throws IOException {
        if (map.size() > 0) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object mapValue = map.get(key);
                String value = null;
                value = mapValue instanceof QName ? this.toString((QName)mapValue) : (mapValue == null ? "null" : "\"" + (String)mapValue + "\"");
                key = key == null ? "null" : key;
                value = value == null ? "null" : value;
                pw.println(indent + var + ".setOption(\"" + key + "\"," + value + ");");
            }
        }
    }

    private void init() {
        Output output;
        this.oDesc = new ODesc();
        PDesc[] params = new PDesc[this.boe.numParameters()];
        for (int i = 0; i < this.boe.numParameters(); ++i) {
            String val;
            params[i] = new PDesc();
            BindingParamEntry bpe = this.boe.getParameter(i);
            params[i].qName = (QName)bpe.getDynamicVar("parameterWireQName");
            params[i].typeQName = Utils.getXSIType(bpe);
            params[i].mode = ParameterDesc.modeFromString(this.getModeString(bpe.getMode()));
            params[i].javaType = (String)bpe.getDynamicVar("parameterType");
            params[i].inHeader = bpe.isInHeader();
            params[i].outHeader = bpe.isOutHeader();
            params[i].minOccursIs0 = bpe.isMinOccursIs0();
            params[i].maxOccursIs1 = bpe.isMaxOccursIs1();
            params[i].wsdl11MIME = bpe.getMIMEType() != null;
            params[i].isReturn = false;
            if (bpe.getMIMEType() != null) {
                params[i].map.put(ParameterDesc.MIME_TYPE, bpe.getMIMEType());
            }
            if (bpe.getType().getQName() != null) {
                params[i].map.put(ParameterDesc.PART_QNAME_STRING, bpe.getType().getQName().toString());
                params[i].map.put(ParameterDesc.PART_NAME, bpe.getType().getQName().getLocalPart());
            }
            if (JavaUtils.hasValue(val = (String)bpe.getDynamicVar(JavaGeneratorFactory.IN_POSITION))) {
                params[i].map.put(JavaGeneratorFactory.IN_POSITION, val);
            }
            if (!JavaUtils.hasValue(val = (String)bpe.getDynamicVar(JavaGeneratorFactory.OUT_POSITION))) continue;
            params[i].map.put(JavaGeneratorFactory.OUT_POSITION, val);
        }
        PDesc returnDesc = null;
        Operation operation = this.boe.getBindingOperation().getOperation();
        if (operation.getStyle() != OperationType.ONE_WAY) {
            returnDesc = new PDesc();
            returnDesc.isReturn = true;
            returnDesc.mode = (byte)2;
            if (this.boe.getReturn() == null) {
                returnDesc.qName = null;
                returnDesc.typeQName = Constants.WEBSERVICES_VOID;
                returnDesc.javaType = "void";
            } else {
                String val;
                BindingParamEntry bpe = this.boe.getReturn();
                returnDesc.qName = (QName)bpe.getDynamicVar("parameterWireQName");
                returnDesc.typeQName = Utils.getXSIType(bpe);
                returnDesc.javaType = (String)bpe.getDynamicVar("parameterType");
                returnDesc.minOccursIs0 = bpe.isMinOccursIs0();
                returnDesc.maxOccursIs1 = bpe.isMaxOccursIs1();
                returnDesc.outHeader = bpe.isOutHeader();
                boolean bl = returnDesc.wsdl11MIME = bpe.getMIMEType() != null;
                if (bpe.getMIMEType() != null) {
                    returnDesc.map.put(ParameterDesc.MIME_TYPE, bpe.getMIMEType());
                }
                if (bpe.getType().getQName() != null) {
                    returnDesc.map.put(ParameterDesc.PART_QNAME_STRING, bpe.getType().getQName().toString());
                    returnDesc.map.put(ParameterDesc.PART_NAME, bpe.getType().getQName().getLocalPart());
                }
                if (JavaUtils.hasValue(val = (String)bpe.getDynamicVar(JavaGeneratorFactory.OUT_POSITION))) {
                    returnDesc.map.put(JavaGeneratorFactory.OUT_POSITION, val);
                }
            }
        }
        FDesc[] faults = new FDesc[this.boe.numFaults()];
        for (int i = 0; i < this.boe.numFaults(); ++i) {
            BindingFaultRefEntry faultRef = this.boe.getFault(i);
            MessageEntry me = faultRef.getMessageEntry();
            ChildFaultPartEntry cfp = null;
            if (me.getFaultParts().size() > 0) {
                cfp = (ChildFaultPartEntry)me.getFaultParts().elementAt(0);
            }
            SymTabEntry faultEntry = (SymTabEntry)me.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
            faults[i] = new FDesc();
            faults[i].faultCode = faultEntry.getQName();
            faults[i].messageQName = me.getQName();
            faults[i].className = faultEntry.getName();
            if ("javax.xml.soap.SOAPElement".equals(faults[i].className)) {
                faults[i].className = "javax.xml.rpc.soap.SOAPFaultException";
            }
            faults[i].partXmlType = null;
            faults[i].partQName = null;
            if (faultEntry == me) {
                if (cfp == null) continue;
                if (cfp.getType() instanceof Element) {
                    faults[i].partQName = cfp.getType().getQName();
                    this.oDesc.map.put(FaultDesc.MESSAGE_PART_NAME, cfp.getQName());
                } else {
                    faults[i].partQName = cfp.getQName();
                }
                faults[i].partXmlType = Utils.getXSIType(cfp.getType());
                continue;
            }
            faults[i].partXmlType = faults[i].faultCode;
            faults[i].partQName = cfp.getType() instanceof Element ? cfp.getType().getQName() : cfp.getQName();
        }
        this.oDesc.name = this.boe.getName();
        this.oDesc.elementQName = this.boe.getQName();
        this.oDesc.params = params;
        this.oDesc.returnDesc = returnDesc;
        this.oDesc.faults = faults;
        this.oDesc.soapAction = (String)this.boe.getDynamicVar(BindingOperationEntry.SOAP_ACTION_URI);
        this.setWSAAction(this.oDesc, this.boe.getBindingOperation().getOperation());
        this.setUsingAddressing(this.oDesc, this.be);
        if (this.boe.isWrapped()) {
            this.oDesc.style = Style.WRAPPED;
            this.oDesc.use = Use.LITERAL;
        } else {
            this.oDesc.style = this.be.getBindingStyle();
            this.oDesc.use = this.boe.getInputBodyUse() == Use.LITERAL || this.boe.getOutputBodyUse() == Use.LITERAL ? Use.LITERAL : Use.ENCODED;
            if (this.boe.getInputEncodingStyle() != null) {
                this.oDesc.map.put(OperationDesc.INPUT_ENCODING_STYLE, this.boe.getInputEncodingStyle());
            }
            if (this.boe.getOutputEncodingStyle() != null) {
                this.oDesc.map.put(OperationDesc.OUTPUT_ENCODING_STYLE, this.boe.getOutputEncodingStyle());
            }
        }
        this.oDesc.map.put("buildNum", Version.getRawBuildNum());
        this.oDesc.map.put(OperationDesc.TARGET_NAMESPACE, this.symbolTable.getDefinition().getTargetNamespace());
        this.boe.getBindingOperation().getOperation();
        Input input = this.boe.getBindingOperation().getOperation().getInput();
        if (input != null) {
            if (input.getName() != null) {
                this.oDesc.map.put(OperationDesc.INPUT_NAME, input.getName());
            }
            if (input.getMessage() != null) {
                this.oDesc.map.put(OperationDesc.INPUT_MESSAGE_QNAME, input.getMessage().getQName());
            }
        }
        if ((output = this.boe.getBindingOperation().getOperation().getOutput()) != null) {
            Message outputMessage = output.getMessage();
            if (output.getName() != null) {
                this.oDesc.map.put(OperationDesc.OUTPUT_NAME, output.getName());
            }
            if (outputMessage != null) {
                this.oDesc.map.put(OperationDesc.OUTPUT_MESSAGE_QNAME, outputMessage.getQName());
                if (this.boe.isWrapped()) {
                    QName outputElement = null;
                    Map msgParts = outputMessage.getParts();
                    if (msgParts != null && msgParts.size() == 1) {
                        Iterator it = msgParts.keySet().iterator();
                        while (it.hasNext()) {
                            Part p = outputMessage.getPart((String)it.next());
                            outputElement = p.getElementName();
                        }
                    }
                    if (outputElement != null) {
                        this.oDesc.map.put(OperationDesc.RESPONSE_NAMESPACE, outputElement.getNamespaceURI());
                        this.oDesc.map.put(OperationDesc.RESPONSE_LOCALPART, outputElement.getLocalPart());
                    }
                } else {
                    String outputNamespace = this.boe.getOutputNamespace();
                    if (outputNamespace != null) {
                        this.oDesc.map.put(OperationDesc.RESPONSE_NAMESPACE, outputNamespace);
                    }
                }
            }
        }
        this.oDesc.map.put(OperationDesc.PORT_TYPE_QNAME, this.be.getBinding().getPortType().getQName());
        this.oDesc.map.put(OperationDesc.SERVICE_QNAME, this.be.getServiceName());
        String val = (String)this.boe.getDynamicVar(JavaGeneratorFactory.OUT_ORDERING_REQUIRED);
        if (JavaUtils.hasValue(val)) {
            this.oDesc.map.put(JavaGeneratorFactory.OUT_ORDERING_REQUIRED, val);
        }
    }

    private void setWSAAction(ODesc oDesc, Operation op) {
        Iterator it;
        Output output;
        Input input = op.getInput();
        if (input != null) {
            String value = null;
            for (int i = 0; i < Constants.ACTIONS_WSA.length; ++i) {
                value = this.expectString(input.getExtensionAttribute(Constants.ACTIONS_WSA[i]));
                if (value == null) continue;
                oDesc.map.put(OperationDesc.INPUT_WSA_ACTION, value);
                break;
            }
        }
        if ((output = op.getOutput()) != null) {
            String value = null;
            for (int i = 0; i < Constants.ACTIONS_WSA.length; ++i) {
                value = this.expectString(output.getExtensionAttribute(Constants.ACTIONS_WSA[i]));
                if (value == null) continue;
                oDesc.map.put(OperationDesc.OUTPUT_WSA_ACTION, value);
                break;
            }
        }
        Iterator iterator = it = op.getFaults() == null ? null : op.getFaults().values().iterator();
        if (it != null) {
            block2: while (it.hasNext()) {
                Fault fault = (Fault)it.next();
                for (int i = 0; i < oDesc.faults.length; ++i) {
                    FDesc fdesc = oDesc.faults[i];
                    if (!fdesc.messageQName.equals(fault.getMessage().getQName())) continue;
                    String value = null;
                    for (int j = 0; j < Constants.ACTIONS_WSA.length; ++j) {
                        value = this.expectString(fault.getExtensionAttribute(Constants.ACTIONS_WSA[j]));
                        if (value == null) continue;
                        fdesc.map.put(OperationDesc.FAULT_WSA_ACTION, value);
                        continue block2;
                    }
                    continue block2;
                }
            }
        }
    }

    private void setUsingAddressing(ODesc oDesc, BindingEntry be) {
        Binding bind = be.getBinding();
        Boolean usingAddressingRequiredFlag = ExtensionUtils.usingAddressing(bind);
        String usingAddressingRequired = null;
        if (usingAddressingRequiredFlag != null) {
            usingAddressingRequired = usingAddressingRequiredFlag.toString();
            oDesc.map.put(OperationDesc.USING_ADDRESSING_ELEMENT, usingAddressingRequired);
        } else {
            oDesc.map.remove(OperationDesc.USING_ADDRESSING_ELEMENT);
        }
    }

    private String expectString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof QName) {
            QName qName = (QName)value;
            if (qName.getPrefix() == null || qName.getPrefix().length() == 0) {
                return qName.getLocalPart();
            }
            return qName.getPrefix() + ":" + qName.getLocalPart();
        }
        return (String)value;
    }

    private String getModeString(byte mode) {
        if (mode == 1) {
            return "IN";
        }
        if (mode == 3) {
            return "INOUT";
        }
        return "OUT";
    }

    private String modeToString(byte mode) {
        String text = "com.ibm.ws.webservices.engine.description.ParameterDesc.";
        if (mode == 1) {
            return text + "IN";
        }
        if (mode == 2) {
            return text + "OUT";
        }
        return text + "INOUT";
    }

    private String toString(boolean value) {
        return value ? "true" : "false";
    }

    private String toString(QName qName) {
        return qName == null ? "null" : Utils.getNewQName(qName);
    }

    private String writeUse(Use use) {
        if (use == Use.ENCODED) {
            return "com.ibm.ws.webservices.engine.enumtype.Use.ENCODED";
        }
        if (use == Use.LITERAL) {
            return "com.ibm.ws.webservices.engine.enumtype.Use.LITERAL";
        }
        return "not compilable";
    }

    private String writeStyle(Style style) {
        if (style == Style.WRAPPED) {
            return "com.ibm.ws.webservices.engine.enumtype.Style.WRAPPED";
        }
        if (style == Style.DOCUMENT) {
            return "com.ibm.ws.webservices.engine.enumtype.Style.DOCUMENT";
        }
        if (style == Style.RPC) {
            return "com.ibm.ws.webservices.engine.enumtype.Style.RPC";
        }
        return "not compilable";
    }

    class FDesc {
        public QName faultCode;
        public QName messageQName;
        public String className;
        public QName partQName;
        public QName partXmlType;
        public HashMap map = new HashMap();

        FDesc() {
        }
    }

    class PDesc {
        public String javaType;
        public QName qName;
        public QName typeQName;
        public byte mode = 1;
        public int order;
        public boolean isReturn = false;
        public boolean inHeader = false;
        public boolean outHeader = false;
        public boolean minOccursIs0 = false;
        public boolean maxOccursIs1 = true;
        public boolean wsdl11MIME = true;
        public HashMap map = new HashMap();

        PDesc() {
        }
    }

    class ODesc {
        public String name;
        public QName elementQName;
        public PDesc[] params;
        public PDesc returnDesc;
        public FDesc[] faults;
        public Style style;
        public Use use;
        public String soapAction;
        public HashMap map = new HashMap();

        ODesc() {
        }
    }
}

