/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Scenario;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.wsdl.Operation;
import javax.wsdl.PortType;

public class JavaInterfaceWriter
extends JavaClassWriter {
    protected PortType portType;
    protected BindingEntry bEntry;

    protected JavaInterfaceWriter(Emitter emitter, PortTypeEntry ptEntry, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, (String)bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME), "interface");
        this.portType = ptEntry.getPortType();
        this.bEntry = bEntry;
    }

    public void generate() throws IOException {
        if ((this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER || this.emitter.getScenario() == Scenario.WRD_BOTTOM_UP_SERVER) && this.getClass() == JavaInterfaceWriter.class) {
            return;
        }
        String fqClass = this.getPackage() + "." + this.getClassName();
        if (!(this.emitter.getGeneratedFileInfo().getClassNames().contains(fqClass) || this.emitter.getRole() != Role.CLIENT && this.emitter.getRole() != Role.SERVER && this.emitter.getRole() != Role.DEVELOP_CLIENT && this.emitter.getRole() != Role.DEVELOP_SERVER)) {
            super.generate();
        }
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends java.rmi.Remote ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Iterator operations = this.portType.getOperations().iterator();
        while (operations.hasNext()) {
            Operation operation = (Operation)operations.next();
            this.writeOperation(pw, operation);
        }
    }

    protected void writeOperation(PrintWriter pw, Operation operation) throws IOException {
        this.writeComment(pw, operation.getDocumentationElement());
        BindingOperationEntry boe = this.bEntry.getOperation(operation);
        pw.println(boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE) + ";");
    }
}

