/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class JavaEnumTypeWriter
extends JavaClassWriter {
    private Vector enumValues;
    private Type type;

    protected JavaEnumTypeWriter(Emitter emitter, Type type) {
        super(emitter, type.getName(), "enumType");
        this.type = type;
        this.enumValues = type.getChildren();
    }

    protected String getImplementsText() {
        if (this.emitter.isGenImplSer()) {
            return "implements java.io.Serializable ";
        }
        return " ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        int i;
        String baseType;
        String javaName = this.getClassName();
        String baseClass = baseType = this.type.getRestrictionBase().getName();
        if (baseType.equals("String")) {
            baseClass = "java.lang.String";
        } else if (baseType.equals("int")) {
            baseClass = "java.lang.Integer";
        } else if (baseType.equals("char")) {
            baseClass = "java.lang.Character";
        } else if (baseType.equals("short")) {
            baseClass = "java.lang.Short";
        } else if (baseType.equals("long")) {
            baseClass = "java.lang.Long";
        } else if (baseType.equals("double")) {
            baseClass = "java.lang.Double";
        } else if (baseType.equals("float")) {
            baseClass = "java.lang.Float";
        } else if (baseType.equals("byte")) {
            baseClass = "java.lang.Byte";
        }
        Vector<String> values = new Vector<String>();
        for (i = 0; i < this.enumValues.size(); ++i) {
            String value = ((ChildEnumValueEntry)this.enumValues.get(i)).getEnumValue();
            if (baseClass.equals("java.lang.String")) {
                value = "\"" + value + "\"";
            } else if (baseClass.equals("java.lang.Character")) {
                value = "'" + value + "'";
            } else if (baseClass.equals("java.lang.Float")) {
                if (!value.endsWith("F") && !value.endsWith("f")) {
                    value = value + "F";
                }
            } else if (baseClass.equals("java.lang.Long")) {
                if (!value.endsWith("L") && !value.endsWith("l")) {
                    value = value + "L";
                }
            } else if (baseClass.equals(baseType)) {
                value = "new " + baseClass + "(\"" + value + "\")";
            }
            values.add(value);
        }
        pw.println("    private " + baseType + " _value_;");
        pw.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        pw.println("");
        pw.println("    // " + Messages.getMessage("ctor00"));
        pw.println("    protected " + javaName + "(" + baseType + " value) {");
        pw.println("        _value_ = value;");
        if (baseClass.equals("java.lang.String") || baseClass.equals(baseType)) {
            pw.println("        _table_.put(_value_,this);");
        } else {
            pw.println("        _table_.put(new " + baseClass + "(_value_),this);");
        }
        pw.println("    };");
        pw.println("");
        for (i = 0; i < this.enumValues.size(); ++i) {
            pw.println("    public static final " + baseType + " _" + ((ChildEnumValueEntry)this.enumValues.get(i)).getName() + " = " + values.get(i) + ";");
        }
        for (i = 0; i < this.enumValues.size(); ++i) {
            pw.println("    public static final " + javaName + " " + ((ChildEnumValueEntry)this.enumValues.get(i)).getName() + " = new " + javaName + "(_" + ((ChildEnumValueEntry)this.enumValues.get(i)).getName() + ");");
        }
        pw.println("    public " + baseType + " getValue() { return _value_;}");
        pw.println("    public static " + javaName + " fromValue(" + baseType + " value)");
        pw.println("          throws java.lang.IllegalArgumentException {");
        pw.println("        " + javaName + " enumeration = (" + javaName + ")");
        if (baseClass.equals("java.lang.String") || baseClass.equals(baseType)) {
            pw.println("            _table_.get(value);");
        } else {
            pw.println("            _table_.get(new " + baseClass + "(value));");
        }
        pw.println("        if (enumeration==null) throw new java.lang.IllegalArgumentException();");
        pw.println("        return enumeration;");
        pw.println("    }");
        pw.println("    public static " + javaName + " fromString(java.lang.String value)");
        pw.println("          throws java.lang.IllegalArgumentException {");
        if (baseClass.equals("java.lang.String")) {
            pw.println("        return fromValue(value);");
        } else if (baseClass.equals(baseType)) {
            pw.println("        try {");
            pw.println("            return fromValue(new " + baseClass + "(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalArgumentException();");
            pw.println("        }");
        } else if (baseClass.equals("java.lang.Character")) {
            pw.println("        if (value != null && value.length() == 1);");
            pw.println("            return fromValue(value.charAt(0));");
            pw.println("        throw new java.lang.IllegalArgumentException();");
        } else if (baseClass.equals("java.lang.Integer")) {
            pw.println("        try {");
            pw.println("            return fromValue(java.lang.Integer.parseInt(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalArgumentException();");
            pw.println("        }");
        } else {
            String parse = "parse" + baseClass.substring(baseClass.lastIndexOf(".") + 1);
            pw.println("        try {");
            pw.println("            return fromValue(" + baseClass + "." + parse + "(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalArgumentException();");
            pw.println("        }");
        }
        pw.println("    }");
        pw.println("    public boolean equals(java.lang.Object obj) {return (obj == this);}");
        pw.println("    public int hashCode() { return toString().hashCode();}");
        if (baseClass.equals("java.lang.String")) {
            pw.println("    public java.lang.String toString() { return _value_;}");
        } else if (baseClass.equals(baseType)) {
            pw.println("    public java.lang.String toString() { return _value_.toString();}");
        } else {
            pw.println("    public java.lang.String toString() { return java.lang.String.valueOf(_value_);}");
        }
        pw.println();
        if (this.emitter.isGenImplSer()) {
            pw.println("    private java.lang.Object readResolve() throws java.io.ObjectStreamException {");
            pw.println("        return fromValue(_value_);");
            pw.println("    }");
        }
    }
}

