/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanBaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class JavaBeanSerializerWriter
extends JavaBeanBaseWriter {
    protected JavaBeanSerializerWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + "_Ser", "serializer");
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        String extend = !this.isBaseClass() ? "extends " + this.extendType.getName() + "_Ser " : (this.type.isSimpleContent() ? "extends com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializer " : (this.type.isSimpleType() ? "extends com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer " : "extends com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer "));
        return extend;
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        String beanClass = this.className.substring(0, this.className.lastIndexOf("_Ser"));
        String in = "        ";
        pw.println("    /**");
        pw.println("     * Constructor");
        pw.println("     */");
        pw.println("    public " + this.getClassName() + "(");
        pw.println("           java.lang.Class _javaType,  ");
        pw.println("           javax.xml.namespace.QName _xmlType, ");
        pw.println("           com.ibm.ws.webservices.engine.description.TypeDesc _typeDesc) {");
        pw.println("        super(_javaType, _xmlType, _typeDesc);");
        pw.println("    }");
        this.buildQNames();
        pw.println("    public void serialize(");
        pw.println("        javax.xml.namespace.QName name,");
        pw.println("        org.xml.sax.Attributes attributes,");
        pw.println("        java.lang.Object value,");
        pw.println("        com.ibm.ws.webservices.engine.encoding.SerializationContext context)");
        pw.println("        throws java.io.IOException");
        pw.println("    {");
        if (!this.type.isSimpleTypeOrSimpleContent()) {
            pw.println("        context.startElement(name, addAttributes(attributes, value, context));");
            pw.println("        addElements(value, context);");
            pw.println("        context.endElement();");
        } else {
            pw.println("        java.lang.String stringValue = getValueAsString(value, context);");
            pw.println("        context.simpleElement(name,");
            pw.println("                              addAttributes(attributes, value, context),");
            pw.println("                              stringValue);");
        }
        pw.println("    }");
        if (this.isBaseClass() && this.type.isSimpleContent()) {
            pw.println("    public java.lang.String getValueAsString(");
            pw.println("        java.lang.Object value,");
            pw.println("        com.ibm.ws.webservices.engine.encoding.SerializationContext context)");
            pw.println("    {");
            this.startTolerateCheckedException(pw, "     ");
            ChildElement elem = (ChildElement)this.elements.get(0);
            String xmlTypeLocalPart = elem.getType().getQName().getLocalPart();
            String xmlTypeNamespaceURI = elem.getType().getQName().getNamespaceURI();
            if (this._qNameMap.get(elem.getType().getQName()) == null) {
                this._qNameMap.put(elem.getType().getQName(), Utils.returnQNameIdentifier(xmlTypeNamespaceURI, xmlTypeLocalPart));
            }
            pw.println("        " + beanClass + " bean = (" + beanClass + ") value;");
            pw.println("        java.lang.Object propValue = null;");
            pw.println("        java.lang.String retValue = \"\";");
            pw.println("        " + this.assignPropValue(elem));
            pw.println("        if (propValue != null) {");
            pw.print("          javax.xml.namespace.QName  typeQName = ");
            pw.println(Utils.returnQNameIdentifier(xmlTypeNamespaceURI, xmlTypeLocalPart) + ";");
            pw.println("          try {");
            pw.println("            retValue = context.getValueAsString(propValue, typeQName);");
            pw.println("          } catch (Exception _e) {");
            pw.println("            throw new java.lang.RuntimeException(_e);");
            pw.println("          }");
            pw.println("        }");
            pw.println("        return retValue;");
            this.endTolerateCheckedException(pw, "     ");
            pw.println("    }");
        }
        pw.println("    protected org.xml.sax.Attributes addAttributes(");
        pw.println("        org.xml.sax.Attributes attributes,");
        pw.println("        java.lang.Object value,");
        pw.println("        com.ibm.ws.webservices.engine.encoding.SerializationContext context)");
        pw.println("        throws java.io.IOException");
        pw.println("    {");
        this.startTolerateCheckedException(pw, "     ");
        if (this.attributes != null || !this.isBaseClass()) {
            if (!this.isBaseClass()) {
                pw.println(in + "attributes = super.addAttributes(attributes, value, context);");
            }
            if (this.attributes != null && this.attributes.size() > 0) {
                pw.println(in + beanClass + " bean = (" + beanClass + ") value;");
                pw.println(in + "java.lang.Object propValue;");
                pw.println(in + "org.xml.sax.helpers.AttributesImpl attrs;");
                pw.println(in + "if (attributes==null || attributes.getLength() == 0) {");
                pw.println(in + "  attrs = new org.xml.sax.helpers.AttributesImpl();");
                pw.println(in + "} else {");
                pw.println(in + "  attrs = new org.xml.sax.helpers.AttributesImpl(attributes);");
                pw.println(in + "}");
                for (int i = 0; i < this.attributes.size(); ++i) {
                    ChildAttribute attr = (ChildAttribute)this.attributes.get(i);
                    String assign = this.assignPropValue(attr);
                    if (i == 0) {
                        pw.println(in + "{");
                        pw.println(in + "  javax.xml.namespace.QName attrQName;");
                        pw.println(in + "  javax.xml.namespace.QName attrTypeQName;");
                    }
                    pw.println(in + "  " + assign);
                    pw.println(in + "  if (propValue != null) {        ");
                    String xmlLocalPart = attr.getQName().getLocalPart();
                    String xmlNamespaceURI = attr.getQName().getNamespaceURI();
                    QName xmlType = Utils.getXSIType(attr.getType());
                    String xmlTypeLocalPart = xmlType.getLocalPart();
                    String xmlTypeNamespaceURI = xmlType.getNamespaceURI();
                    pw.print(in + "    attrQName = ");
                    pw.println(Utils.returnQNameIdentifier(xmlNamespaceURI, xmlLocalPart) + ";");
                    pw.print(in + "    attrTypeQName = ");
                    pw.println(Utils.returnQNameIdentifier(xmlTypeNamespaceURI, xmlTypeLocalPart) + ";");
                    pw.println(in + "    attrs.addAttribute(");
                    pw.println(in + "      \"" + xmlNamespaceURI + "\",");
                    pw.println(in + "      \"" + xmlLocalPart + "\",");
                    pw.println(in + "      context.qName2String(attrQName, true),");
                    pw.println(in + "      \"CDATA\",");
                    pw.println(in + "      context.getValueAsString(propValue, attrTypeQName));");
                    pw.println(in + "  }");
                }
                pw.println(in + "}");
                pw.println(in + "attributes = attrs;");
            }
        }
        this.performanceBoost(pw);
        pw.println(in + "return attributes;");
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
        pw.println("    protected void addElements(");
        pw.println("        java.lang.Object value,");
        pw.println("        com.ibm.ws.webservices.engine.encoding.SerializationContext context)");
        pw.println("        throws java.io.IOException");
        pw.println("    {");
        this.startTolerateCheckedException(pw, "     ");
        if (!this.isBaseClass()) {
            pw.println(in + "super.addElements(value, context);");
        }
        if (this.elements != null && !this.type.isSimpleTypeOrSimpleContent()) {
            pw.println(in + beanClass + " bean = (" + beanClass + ") value;");
            pw.println(in + "java.lang.Object propValue;");
            for (int i = 0; i < this.elements.size(); ++i) {
                ChildElement elem = (ChildElement)this.elements.get(i);
                String xmlLocalPart = elem.getQName().getLocalPart();
                String xmlNamespaceURI = elem.getQName().getNamespaceURI();
                if (i == 0) {
                    pw.println(in + "javax.xml.namespace.QName propQName;");
                    pw.println(in + "{");
                }
                pw.print(in + "  propQName = ");
                pw.println(Utils.returnQNameIdentifier(xmlNamespaceURI, xmlLocalPart) + ";");
                if (!elem.getType().isCollectionTypeEntry()) {
                    pw.println(in + "  " + this.assignPropValue(elem));
                    boolean sendNull = !elem.getMinOccursIs0();
                    this.serialize(pw, in + "  ", "propQName", "propValue", elem.getType(), (String)elem.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE), sendNull);
                } else {
                    String javaType = (String)elem.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    String compJavaType = javaType.substring(0, javaType.length() - 2);
                    boolean sendNull = elem.isNillable() || JavaUtils.getWrapper(compJavaType) == null;
                    pw.println(in + "  {");
                    pw.println(in + "    " + this.assignPropValue(elem));
                    pw.println(in + "    if (propValue != null) {");
                    pw.println(in + "      for (int i=0; i<java.lang.reflect.Array.getLength(propValue); i++) {");
                    this.serialize(pw, in + "        ", "propQName", "java.lang.reflect.Array.get(propValue, i)", elem.getType().getRefType(), compJavaType, sendNull);
                    pw.println(in + "      }");
                    pw.println(in + "    }");
                    pw.println(in + "  }");
                }
                if (i + 1 < this.elements.size()) continue;
                pw.println(in + "}");
            }
        } else if (this.type.isSimpleContent()) {
            pw.println(in + "java.lang.String stringValue = getValueAsString(value, context);");
            pw.println(in + "context.simpleElement(null, null, stringValue);");
        }
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
        this.writeQNames(pw, "    ", "private");
    }

    protected String assignPropValue(ChildEntry ce) {
        String assignment = "propValue = ";
        String readAccess = "bean." + JavaBeanWriter.readAccess(ce);
        String wrapper = JavaUtils.getWrapper((String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE));
        assignment = wrapper == null ? assignment + readAccess + ";" : assignment + "new " + wrapper + "(" + readAccess + ");";
        return assignment;
    }

    protected void serialize(PrintWriter pw, String in, String nameQNameVar, String valueVar, TypeEntry type, String typeName, boolean sendNull) {
        QName typeQName;
        String typeQNameString;
        String sendNullVal = sendNull ? "true" : "false";
        String xmlTypeVal = "null";
        String sendTypeVal = "null";
        if (!(type instanceof Type)) {
            type = type.getRefType();
        }
        if ((typeQNameString = (String)this._qNameMap.get(typeQName = Utils.getXSIType(type))) == null) {
            typeQNameString = Utils.returnQNameIdentifier(typeQName.getNamespaceURI(), typeQName.getLocalPart());
            this._qNameMap.put(typeQName, typeQNameString);
        }
        if (typeName.equals("java.lang.String")) {
            pw.println(in + "if (" + valueVar + " != null && !context.shouldSendXSIType()) {");
            pw.println(in + "  context.simpleElement(" + nameQNameVar + ", null, " + valueVar + ".toString()); ");
            pw.println(in + "} else {");
            pw.println(in + "  serializeChild(" + nameQNameVar + ", null, ");
            pw.println(in + "    " + valueVar + ", ");
            pw.println(in + "    " + typeQNameString + ",");
            pw.println(in + "    " + sendNullVal + "," + sendTypeVal + ",context);");
            pw.println(in + "}");
        } else {
            pw.println(in + "serializeChild(" + nameQNameVar + ", null, ");
            pw.println(in + "    " + valueVar + ", ");
            pw.println(in + "    " + typeQNameString + ",");
            pw.println(in + "    " + sendNullVal + "," + sendTypeVal + ",context);");
        }
    }

    protected void performanceBoost(PrintWriter pw) {
        String in = "        ";
        if (this.elements != null) {
            ChildElement elem;
            ArrayList<String> namespaceList = new ArrayList<String>();
            ArrayList<ChildElement> elementList = new ArrayList<ChildElement>();
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                elem = (ChildElement)iterator.next();
                String namespace = elem.getQName().getNamespaceURI();
                if (namespace.equals("") || namespaceList.contains(elem)) continue;
                namespaceList.add(namespace);
                elementList.add(elem);
            }
            iterator = elementList.iterator();
            if (iterator.hasNext()) {
                pw.println(in + "   javax.xml.namespace.QName");
            }
            while (iterator.hasNext()) {
                elem = (ChildElement)iterator.next();
                pw.print(in + "   elemQName = ");
                pw.println(Utils.returnQNameIdentifier(elem.getQName().getNamespaceURI(), elem.getQName().getLocalPart()) + ";");
                pw.println(in + "   context.qName2String(elemQName, true);");
            }
        }
    }
}

