/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanBaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.jem.java.JavaHelpers;

public class JavaBeanDeserializerWriter
extends JavaBeanBaseWriter {
    protected boolean emitExtraMethods = true;
    protected String beanClass;
    protected ArrayList elementSetFromStringList = new ArrayList();
    protected static final int MAX = 25;
    protected boolean writeOutQNameDef = false;
    protected JavaHelpers collectionType;
    private static Hashtable parseText = new Hashtable(50);

    protected JavaBeanDeserializerWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + "_Deser", "deserializer");
        ClassFactory classFactory = emitter.getToolEnv().getClassFactory();
        this.collectionType = classFactory.forName("java.util.Collection");
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        String extend = !this.isBaseClass() ? "extends " + this.extendType.getName() + "_Deser " : (this.type.isSimpleContent() ? "extends com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializer " : (this.type.isSimpleType() ? "extends com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer " : "extends com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer "));
        return extend;
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.beanClass = this.getClassName().substring(0, this.className.lastIndexOf("_Deser"));
        pw.println("    /**");
        pw.println("     * Constructor");
        pw.println("     */");
        pw.println("    public " + this.getClassName() + "(");
        pw.println("           java.lang.Class _javaType,  ");
        pw.println("           javax.xml.namespace.QName _xmlType, ");
        pw.println("           com.ibm.ws.webservices.engine.description.TypeDesc _typeDesc) {");
        pw.println("        super(_javaType, _xmlType, _typeDesc);");
        pw.println("    }");
        if (!this.type.isSimpleType()) {
            Boolean isComplexFault = (Boolean)this.type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            if (!(this.type.isAbstract() || isComplexFault != null && isComplexFault.booleanValue() || !this.emitExtraMethods)) {
                this.buildQNames();
                this.writeCreateValue(pw);
                this.writeTryElementSetFromString(pw);
                this.writeTryAttributeSetFromString(pw);
                this.writeTryElementSetFromObject(pw);
                this.writeTryElementSetFromList(pw);
                if (this.writeOutQNameDef) {
                    this.writeQNames(pw, "    ", "private");
                }
            }
        }
    }

    private void writeCreateValue(PrintWriter pw) throws IOException {
        pw.println("    /**");
        pw.println("     * Create instance of java bean");
        pw.println("     */");
        pw.println("    public void createValue() {");
        this.startTolerateCheckedException(pw, "     ");
        pw.println("        value = new " + this.type.getName() + "();");
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
    }

    private void writeTryElementSetFromString(PrintWriter pw) throws IOException {
        pw.println("    protected boolean tryElementSetFromString(javax.xml.namespace.QName qName, java.lang.String strValue) {");
        this.startTolerateCheckedException(pw, "     ");
        String ifText = "if";
        if (this.elements != null) {
            String qNameName;
            String parseText;
            String typeName;
            ChildEntry ce;
            int i;
            for (i = 0; i < this.elements.size(); ++i) {
                ce = (ChildEntry)this.elements.get(i);
                if (!this.isAcceptable(ce)) continue;
                typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                parseText = this.getParseText(typeName, ce.getType());
                qNameName = (String)this._qNameMap.get(ce.getQName());
                if (parseText == null || qNameName == null || typeName.lastIndexOf("]") - typeName.indexOf("[") >= 2) continue;
                this.elementSetFromStringList.add(ce);
            }
            if (this.elementSetFromStringList.size() <= 25 && this.elementSetFromStringList.size() != 0) {
                this.writeOutQNameDef = true;
                for (i = 0; i < this.elementSetFromStringList.size(); ++i) {
                    ce = (ChildEntry)this.elementSetFromStringList.get(i);
                    typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    parseText = this.getParseText(typeName, ce.getType());
                    qNameName = (String)this._qNameMap.get(ce.getQName());
                    pw.println("        " + ifText + " (qName==" + qNameName + ") {");
                    pw.print("          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(ce)) {
                        pw.println(ce.getName() + "=" + parseText + ";");
                    } else {
                        pw.println(JavaBeanWriter.setterMethodName(ce) + "(" + parseText + ");");
                    }
                    pw.println("          return true;}");
                    ifText = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            pw.println("        return false;");
        } else {
            pw.println("        return super.tryElementSetFromString(qName, strValue);");
        }
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
    }

    private void writeTryAttributeSetFromString(PrintWriter pw) throws IOException {
        pw.println("    protected boolean tryAttributeSetFromString(javax.xml.namespace.QName qName, java.lang.String strValue) {");
        this.startTolerateCheckedException(pw, "     ");
        String ifText = "if";
        if (this.attributes != null) {
            String qNameName;
            String parseText;
            String typeName;
            ChildEntry ce;
            int i;
            ArrayList<ChildEntry> list = new ArrayList<ChildEntry>();
            for (i = 0; i < this.attributes.size(); ++i) {
                ce = (ChildEntry)this.attributes.get(i);
                if (!this.isAcceptable(ce)) continue;
                typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                parseText = this.getParseText(typeName, ce.getType());
                qNameName = (String)this._qNameMap.get(ce.getQName());
                if (parseText == null || qNameName == null || typeName.lastIndexOf("]") - typeName.indexOf("[") >= 2) continue;
                list.add(ce);
            }
            if (list.size() <= 25 && list.size() != 0) {
                this.writeOutQNameDef = true;
                for (i = 0; i < list.size(); ++i) {
                    ce = (ChildEntry)list.get(i);
                    typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    parseText = this.getParseText(typeName, ce.getType());
                    qNameName = (String)this._qNameMap.get(ce.getQName());
                    pw.println("        " + ifText + " (qName==" + qNameName + ") {");
                    pw.print("          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(ce)) {
                        pw.println(ce.getName() + "=" + parseText + ";");
                    } else {
                        pw.println(JavaBeanWriter.setterMethodName(ce) + "(" + parseText + ");");
                    }
                    pw.println("          return true;}");
                    ifText = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            pw.println("        return false;");
        } else {
            pw.println("        return super.tryAttributeSetFromString(qName, strValue);");
        }
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
    }

    private void writeTryElementSetFromObject(PrintWriter pw) throws IOException {
        pw.println("    protected boolean tryElementSetFromObject(javax.xml.namespace.QName qName, java.lang.Object objValue) {");
        this.startTolerateCheckedException(pw, "     ");
        String ifText = "if";
        if (this.elements != null) {
            ChildEntry ce;
            int i;
            ArrayList<ChildEntry> list = new ArrayList<ChildEntry>();
            ClassFactory classFactory = this.emitter.getToolEnv().getClassFactory();
            for (i = 0; i < this.elements.size(); ++i) {
                String typeName;
                JavaHelpers javaType;
                String qNameName;
                ce = (ChildEntry)this.elements.get(i);
                if (!this.isAcceptable(ce) || (qNameName = (String)this._qNameMap.get(ce.getQName())) == null || ce.getType().isCollectionTypeEntry() || ((ChildElement)ce).getAnyElement() || this.elementSetFromStringList.contains(ce) || this.collectionType.isAssignableFrom(javaType = classFactory.forName(typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE))) || typeName.lastIndexOf("]") - typeName.indexOf("[") >= 2) continue;
                list.add(ce);
            }
            if (list.size() <= 25 && list.size() != 0) {
                this.writeOutQNameDef = true;
                for (i = 0; i < list.size(); ++i) {
                    ce = (ChildEntry)list.get(i);
                    String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    String qNameName = (String)this._qNameMap.get(ce.getQName());
                    String indent = "";
                    String bracket = "";
                    pw.println("        " + ifText + " (qName==" + qNameName + ") {");
                    if (typeName.lastIndexOf("]") - typeName.indexOf("[") == 1 && typeName.indexOf(".") > 0) {
                        pw.println("          if (objValue instanceof java.util.List) {");
                        pw.println("            " + typeName + " array = new " + typeName.substring(0, typeName.length() - 1) + "((java.util.List)objValue).size()];");
                        pw.println("            ((java.util.List)objValue).toArray(array);");
                        pw.print("            ((" + this.beanClass + ")value).");
                        if (JavaBeanWriter.isDataMember(ce)) {
                            pw.println(ce.getName() + "=array;");
                        } else {
                            pw.println(JavaBeanWriter.setterMethodName(ce) + "(array);");
                        }
                        pw.println("          } else { ");
                        indent = "  ";
                        bracket = "}";
                    }
                    pw.print(indent + "          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(ce)) {
                        pw.println(ce.getName() + "=(" + typeName + ")objValue;" + bracket);
                    } else {
                        pw.println(JavaBeanWriter.setterMethodName(ce) + "((" + typeName + ")objValue);" + bracket);
                    }
                    pw.println("          return true;}");
                    ifText = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            pw.println("        return false;");
        } else {
            pw.println("        return super.tryElementSetFromObject(qName, objValue);");
        }
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
    }

    private void writeTryElementSetFromList(PrintWriter pw) throws IOException {
        pw.println("    protected boolean tryElementSetFromList(javax.xml.namespace.QName qName, java.util.List listValue) {");
        this.startTolerateCheckedException(pw, "     ");
        String ifText = "if";
        if (this.elements != null) {
            ChildEntry ce;
            int i;
            ArrayList<ChildEntry> list = new ArrayList<ChildEntry>();
            for (i = 0; i < this.elements.size(); ++i) {
                ce = (ChildEntry)this.elements.get(i);
                if (!this.isAcceptable(ce)) continue;
                String qNameName = (String)this._qNameMap.get(ce.getQName());
                String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                if (qNameName == null || !ce.getType().isCollectionTypeEntry() || typeName.lastIndexOf("]") - typeName.indexOf("[") != 1 || typeName.indexOf(".") <= 0 || ((ChildElement)ce).getAnyElement()) continue;
                list.add(ce);
            }
            if (list.size() <= 25 && list.size() != 0) {
                this.writeOutQNameDef = true;
                for (i = 0; i < list.size(); ++i) {
                    ce = (ChildEntry)list.get(i);
                    String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    String qNameName = (String)this._qNameMap.get(ce.getQName());
                    pw.println("        " + ifText + " (qName==" + qNameName + ") {");
                    pw.println("          " + typeName + " array = new " + typeName.substring(0, typeName.length() - 1) + "listValue.size()];");
                    pw.println("          listValue.toArray(array);");
                    pw.print("          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(ce)) {
                        pw.println(ce.getName() + "=array;");
                    } else {
                        pw.println(JavaBeanWriter.setterMethodName(ce) + "(array);");
                    }
                    pw.println("          return true;}");
                    ifText = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            pw.println("        return false;");
        } else {
            pw.println("        return super.tryElementSetFromList(qName, listValue);");
        }
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
    }

    private boolean isAcceptable(ChildEntry ce) {
        boolean missingSetter;
        boolean bl = missingSetter = ce.getDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME) == null ? false : (Boolean)ce.getDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME);
        return !missingSetter;
    }

    private String getParseText(String javaTypeName, TypeEntry type) {
        String text = (String)parseText.get(javaTypeName);
        if (text == null) {
            if (javaTypeName.equals("java.util.Calendar")) {
                if (Constants.equals(type.getQName(), Constants.XSD_DATE)) {
                    text = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDateToCalendar(strValue)";
                } else if (Constants.equals(type.getQName(), Constants.XSD_DATETIME)) {
                    text = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDateTimeToCalendar(strValue)";
                } else if (Constants.equals(type.getQName(), Constants.XSD_TIME)) {
                    text = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseTimeToCalendar(strValue)";
                }
            } else if (javaTypeName.equals("java.util.Date") && Constants.equals(type.getQName(), Constants.XSD_DATETIME)) {
                text = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDateTimeToDate(strValue)";
            }
        }
        return text;
    }

    static {
        parseText.put("java.lang.String", "strValue");
        parseText.put("int", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseint(strValue)");
        parseText.put("boolean", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseboolean(strValue)");
        parseText.put("char", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsechar(strValue)");
        parseText.put("long", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parselong(strValue)");
        parseText.put("double", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsedouble(strValue)");
        parseText.put("short", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseshort(strValue)");
        parseText.put("float", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsefloat(strValue)");
        parseText.put("byte", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsebyte(strValue)");
        parseText.put("java.lang.Integer", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseInteger(strValue)");
        parseText.put("java.lang.Boolean", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseBoolean(strValue)");
        parseText.put("java.lang.Character", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseCharacter(strValue)");
        parseText.put("java.lang.Long", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseLong(strValue)");
        parseText.put("java.lang.Double", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDouble(strValue)");
        parseText.put("java.lang.Short", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseShort(strValue)");
        parseText.put("java.lang.Float", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseFloat(strValue)");
        parseText.put("java.lang.Byte", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseByte(strValue)");
        parseText.put("java.math.BigInteger", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseBigInteger(strValue)");
        parseText.put("java.math.BigDecimal", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseBigDecimal(strValue)");
    }
}

