/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

public abstract class JavaBeanBaseWriter
extends JavaClassWriter {
    protected Type type;
    protected Type extendType;
    protected Type baseSimpleType = null;
    protected Vector elements;
    protected Vector attributes;
    protected Hashtable _qNameMap = new Hashtable();
    private boolean hasCheckedException = false;

    protected JavaBeanBaseWriter(Emitter emitter, Type type, String fullClassName, String description) {
        super(emitter, fullClassName, description);
        this.type = type;
        this.hasCheckedException = type.getDynamicVar("throwsCheckedException") == null ? false : (Boolean)type.getDynamicVar("throwsCheckedException");
        this.extendType = type.getExtensionBase();
        if (this.extendType == null) {
            this.extendType = type.getRestrictionBase();
        }
        if (type.isSimpleTypeOrSimpleContent() && this.extendType != null) {
            this.baseSimpleType = this.extendType;
            while (this.baseSimpleType.getRestrictionBase() != null || this.baseSimpleType.getExtensionBase() != null) {
                if (this.baseSimpleType.getRestrictionBase() != null) {
                    this.baseSimpleType = this.baseSimpleType.getRestrictionBase();
                    continue;
                }
                this.baseSimpleType = this.baseSimpleType.getExtensionBase();
            }
        }
        this.elements = null;
        this.attributes = null;
        Vector children = type.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (children.get(i) instanceof ChildElement) {
                    if (this.elements == null) {
                        this.elements = new Vector();
                    }
                    this.elements.add(children.get(i));
                    continue;
                }
                if (this.attributes == null) {
                    this.attributes = new Vector();
                }
                this.attributes.add(children.get(i));
            }
        }
    }

    protected boolean isBaseClass() {
        return this.extendType == null || this.extendType.isEnumeration() || this.type.isSimpleContent() && this.type.getExtensionBase() == null || this.baseSimpleType != null && this.baseSimpleType.getName().equals(this.extendType.getName());
    }

    protected void buildQNames() throws IOException {
        int i;
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.size(); ++i) {
                QName attrXmlType;
                ChildAttribute attr = (ChildAttribute)this.attributes.get(i);
                if (this._qNameMap.get(attr.getQName()) == null) {
                    this._qNameMap.put(attr.getQName(), Utils.returnQNameIdentifier(attr.getQName().getNamespaceURI(), attr.getQName().getLocalPart()));
                }
                if (this._qNameMap.get(attrXmlType = Utils.getXSIType(attr.getType())) != null) continue;
                this._qNameMap.put(attrXmlType, Utils.returnQNameIdentifier(attrXmlType.getNamespaceURI(), attrXmlType.getLocalPart()));
            }
        }
        if (this.elements != null && !this.type.isSimpleType()) {
            for (i = 0; i < this.elements.size(); ++i) {
                ChildElement elem = (ChildElement)this.elements.get(i);
                String xmlLocalPart = elem.getQName().getLocalPart();
                String xmlNamespaceURI = elem.getQName().getNamespaceURI();
                QName elementQName = new QName(xmlNamespaceURI, xmlLocalPart);
                if (this._qNameMap.get(elementQName) != null) continue;
                this._qNameMap.put(elementQName, Utils.returnQNameIdentifier(xmlNamespaceURI, xmlLocalPart));
            }
        }
    }

    protected void writeQNames(PrintWriter pw, String indent, String accessMod) throws IOException {
        Set coll = this._qNameMap.keySet();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            QName qname = (QName)it.next();
            String qnameID = (String)this._qNameMap.get(qname);
            pw.print(indent + accessMod + " final static javax.xml.namespace.QName ");
            pw.println(qnameID + " = ");
            pw.println(indent + "       com.ibm.ws.webservices.engine.utils.QNameTable.createQName(");
            pw.println(indent + "              \"" + qname.getNamespaceURI() + "\",");
            pw.println(indent + "              \"" + qname.getLocalPart() + "\");");
        }
    }

    public void startTolerateCheckedException(PrintWriter pw, String indent) {
        if (this.hasCheckedException) {
            pw.println(indent + "try {");
        }
    }

    public void endTolerateCheckedException(PrintWriter pw, String indent) {
        if (this.hasCheckedException) {
            pw.println(indent + "} catch (java.lang.Throwable _t)  {");
            pw.println(indent + "  if (!(_t instanceof java.lang.RuntimeException)) {");
            pw.println(indent + "    _t = new java.lang.RuntimeException(_t);");
            pw.println(indent + "  }");
            pw.println(indent + "  throw (java.lang.RuntimeException) _t;");
            pw.println(indent + "}");
        }
    }
}

