/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public abstract class Type
extends TypeEntry {
    protected boolean isSimpleType = false;
    protected boolean isSimpleContent = false;
    protected boolean isEnumeration = false;
    private boolean isAnonType = false;
    private Vector childEntries = null;
    private int extensionBaseSIDX;
    private int restrictionBaseSIDX;

    protected Type(QName pqName, Node pNode, List pNodeStack, SymbolTable symbolTable) {
        super(pqName, pNode, pNodeStack, symbolTable);
        if (pqName.getLocalPart() != null && pqName.getLocalPart().length() > 0) {
            this.isAnonType = pqName.getLocalPart().indexOf(">") >= 0;
        }
    }

    public boolean isSimpleType() {
        return this.isSimpleType;
    }

    void setSimpleType(boolean simpleType) {
        this.isSimpleType = simpleType;
    }

    public boolean isSimpleContent() {
        return this.isSimpleContent;
    }

    void setSimpleContent(boolean simpleContent) {
        this.isSimpleContent = simpleContent;
    }

    public boolean isSimpleTypeOrSimpleContent() {
        return this.isSimpleType || this.isSimpleContent;
    }

    public boolean isEnumeration() {
        return this.isEnumeration;
    }

    public void setEnumeration(boolean value) {
        this.isEnumeration = value;
        if (!value) {
            this.setChildren(null);
        }
    }

    public boolean isList() {
        if (this.isSimpleType() && this.getDimensions().length() > 0) {
            return true;
        }
        if (!this.isSimpleType() || this.getRefType() == null) {
            return false;
        }
        return ((Type)this.getRefType()).isList();
    }

    public boolean isAnonType() {
        return this.isAnonType;
    }

    public Vector getChildren() {
        return this.childEntries;
    }

    void setChildren(Vector children) {
        this.childEntries = children;
    }

    void setExtensionBase(Type ext) {
        this.extensionBaseSIDX = ext.getSIDX();
    }

    public Type getExtensionBase() {
        return (Type)this.symbolTable.lookup(this.extensionBaseSIDX);
    }

    void setRestrictionBase(Type restrict) {
        this.restrictionBaseSIDX = restrict.getSIDX();
    }

    public Type getRestrictionBase() {
        return (Type)this.symbolTable.lookup(this.restrictionBaseSIDX);
    }

    protected String toString(String indent) {
        String text = super.toString(indent) + indent + "extendSIDX?    " + this.extensionBaseSIDX + "\n" + indent + "restrictSIDX?  " + this.restrictionBaseSIDX + "\n" + indent + "SimpleType?    " + this.isSimpleType + "\n" + indent + "SimpleContent?    " + this.isSimpleContent + "\n" + indent + "isList?        " + this.isList() + "\n" + indent + "Enumeration?   " + this.isEnumeration + "\n" + indent + "isAnonType?    " + this.isAnonType + "\n" + indent + "Children       " + this.childEntries + "\n";
        return text;
    }
}

