/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Base64;
import com.ibm.ws.webservices.engine.utils.URLHashSet;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import com.ibm.ws.webservices.wsdl.symbolTable.WSIUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Resolver
implements WSDLLocator {
    protected static Log log = LogFactory.getLog(Resolver.class.getName());
    private ToolEnv env;
    private WSIUtils myWSIUtils;
    private long timeoutms = 45000L;
    private int retry = 0;
    private ImportResolver w2jResolver;
    private URLHashSet importedLocations = new URLHashSet();
    private URLHashSet importedNSs = new URLHashSet();
    private HashMap includedLocations = new HashMap();
    public boolean isIncludedMultipleTimes = false;
    private WSDLWriter writer = null;
    private String username;
    private String password;
    private URL baseURL;
    private InputSource baseInputSource = null;
    private URL latestURL;

    Resolver(String baseURI, ImportResolver w2jResolver) throws MalformedURLException, IOException {
        this.baseURL = baseURI == null || baseURI.length() == 0 ? null : this._makeAbsoluteURL(baseURI);
        this.latestURL = this.baseURL;
        this.w2jResolver = w2jResolver;
        this.myWSIUtils = new WSIUtils();
    }

    Info resolveWSDLImport(URL context, Import wsdlImport, WSDLReader reader) throws IOException, WSDLException, ParserConfigurationException, SAXException {
        String parentFileName;
        Info info;
        block9: {
            info = new Info();
            info.url = Utils.getURL(context, wsdlImport.getLocationURI());
            String string = parentFileName = context == null ? "" : context.getFile();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("loadingFile00", "imported", info.url.toString(), parentFileName));
                log.debug(Messages.getMessage("Namespace00", wsdlImport.getNamespaceURI()));
            }
            if (wsdlImport.getNamespaceURI() != null && wsdlImport.getNamespaceURI().indexOf(58) == -1) {
                this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportNamespace00", wsdlImport.getNamespaceURI(), parentFileName));
            }
            if (this.importedLocations.contains(info.url)) {
                return null;
            }
            this.importedLocations.add(info.url);
            this.importedNSs.add(wsdlImport.getNamespaceURI());
            try {
                this.setInfoDoc(info, wsdlImport.getLocationURI(), parentFileName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug(Messages.getMessage("failConnect00", wsdlImport.getLocationURI(), e.getMessage()));
            }
        }
        this.myWSIUtils.checkValidWSDLImport(info.doc, info.url.toString(), parentFileName);
        Node docNode = this.myWSIUtils.getRootDoc(info.doc, info.url.toString());
        this.myWSIUtils.checkNamespaceTargetNamespace(wsdlImport.getNamespaceURI(), this.myWSIUtils.getTargetNamespace(docNode), parentFileName, info.url.toString());
        info.def = wsdlImport.getDefinition();
        if (info.doc == null && info.def != null) {
            if (this.writer == null) {
                this.writer = WSDLFactory.newInstance().newWSDLWriter();
            }
            info.doc = this.writer.getDocument(info.def);
        } else if (info.def == null) {
            info.def = reader.readWSDL(this);
        }
        return info;
    }

    Info resolveXSDImport(URL context, String namespaceURI, String schemaLocation, String namespaceContext) throws IOException, ParserConfigurationException, SAXException {
        return this._resolveXSD(context, namespaceURI, schemaLocation, true, false, namespaceContext);
    }

    Info resolveXSDInclude(URL context, String schemaLocation, String namespaceContext) throws IOException, ParserConfigurationException, SAXException {
        return this._resolveXSD(context, "", schemaLocation, false, true, namespaceContext);
    }

    Info resolveXSDRedefine(URL context, String schemaLocation, String namespaceContext) throws IOException, ParserConfigurationException, SAXException {
        return this._resolveXSD(context, "", schemaLocation, false, false, namespaceContext);
    }

    private Info _resolveXSD(URL context, String namespaceURI, String schemaLocation, boolean isImport, boolean isInclude, String namespaceContext) throws IOException, ParserConfigurationException, SAXException {
        String parentFileName;
        Info info = new Info();
        info.url = Utils.getURL(context, schemaLocation);
        String string = parentFileName = context == null ? "" : context.getFile();
        if (isImport) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("loadingFile00", "imported", info.url.toString(), parentFileName));
                log.debug(Messages.getMessage("Namespace00", namespaceURI));
            }
            if (this.importedLocations.contains(info.url)) {
                if (log.isDebugEnabled()) {
                    log.debug("File " + info.url.toString() + " was not imported " + "because it has already been imported under the namespace \"" + namespaceURI + "\".");
                }
                return null;
            }
            this.importedNSs.add(namespaceURI);
        }
        this.setInfoDoc(info, schemaLocation, parentFileName);
        Node schemaNode = this.myWSIUtils.getRootSchema(info.doc, info.url.toString(), true);
        String targetNamespace = this.myWSIUtils.getTargetNamespace(schemaNode);
        if (isImport) {
            this.myWSIUtils.checkNamespaceTargetNamespace(namespaceURI, targetNamespace, parentFileName, info.url.toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("loadingFile00", "included/redefined", info.url.toString(), parentFileName));
            }
            if (targetNamespace != null) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("targetNameSpace00", targetNamespace));
                }
                if (this.importedLocations.contains(info.url)) {
                    if (log.isDebugEnabled()) {
                        log.debug("File " + info.url.toString() + " was not included/redefined " + "because it has a targetNamespace and has already been included/redefined.");
                    }
                    return null;
                }
                this.importedNSs.add(targetNamespace);
            } else if (log.isDebugEnabled()) {
                log.debug("File " + info.url.toString() + " will be included/redefined with namespace context \"" + namespaceContext + "\".");
            }
        }
        this.importedLocations.add(info.url);
        if (isInclude) {
            if (this.includedLocations.containsKey(namespaceContext)) {
                URLHashSet urlHashSet = (URLHashSet)this.includedLocations.get(namespaceContext);
                if (urlHashSet.contains(info.url)) {
                    this.isIncludedMultipleTimes = true;
                    if (log.isDebugEnabled()) {
                        log.debug("File " + info.url.toString() + " was not included " + "because it has already been included with namespace context \"" + namespaceContext + "\".");
                    }
                    return null;
                }
                urlHashSet.add(info.url);
            } else {
                URLHashSet urlHashSet = new URLHashSet();
                urlHashSet.add(info.url);
                this.includedLocations.put(namespaceContext, urlHashSet);
            }
        }
        return info;
    }

    public String getBaseURI() {
        return this.baseURL.toString();
    }

    public InputSource getBaseInputSource() {
        if (this.baseInputSource == null) {
            this.baseInputSource = this._getInputSource(this.baseURL.toString(), null);
        }
        return this.baseInputSource;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        try {
            URL parentURL = null;
            if (parentLocation != null && parentLocation.length() > 0) {
                parentURL = this._makeAbsoluteURL(parentLocation);
            }
            URL url = Utils.getURL(parentURL, importLocation);
            InputSource inputSource = this._getInputSource(url.toString(), importLocation);
            this.latestURL = url;
            return inputSource;
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.wsdl.symbolTable.Resolver.getImportInputSource", "252", this);
            throw new RuntimeException(e.toString());
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.wsdl.symbolTable.Resolver.getImportInputSource", "255", this);
            throw new RuntimeException(e.toString());
        }
    }

    public String getLatestImportURI() {
        return this.latestURL.toString();
    }

    private InputSource _getInputSource(String uri, String location) {
        InputStream is = null;
        String uri2 = uri;
        if (this.w2jResolver != null) {
            is = this.w2jResolver.resolve(uri);
            if (is == null && location != null) {
                uri2 = location;
                is = this.w2jResolver.resolve(location);
            }
            if (is == null) {
                uri2 = uri.substring(uri.lastIndexOf("META-INF/wsdl/") + 14);
                is = this.w2jResolver.resolve(uri2);
            }
        }
        if (is != null) {
            InputSource inputSource = new InputSource(is);
            inputSource.setSystemId(uri2);
            return inputSource;
        }
        try {
            return XMLUtils.getInputSourceFromURI(uri, this.username, this.password);
        }
        catch (Exception e) {
            return XMLUtils.getInputSourceFromURI(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL _makeAbsoluteURL(String uri) throws MalformedURLException, IOException {
        URL url;
        block20: {
            url = null;
            InputStream inputStream = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("resolving00", uri));
                }
                url = new URL(uri);
                URLConnection conn = url.openConnection();
                String userinfo = url.getUserInfo();
                String auth = null;
                if (userinfo != null) {
                    auth = userinfo;
                } else if (this.username != null) {
                    String string = auth = this.password == null ? this.username : this.username + ":" + this.password;
                }
                if (auth != null) {
                    conn.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(auth.getBytes("ISO-8859-1")));
                }
                String proxyUserName = null;
                String proxyPassword = null;
                boolean proxyEnabled = false;
                if (uri.startsWith("https")) {
                    proxyUserName = System.getProperty("https.proxyUserName");
                    proxyPassword = System.getProperty("https.proxyPassword");
                    proxyEnabled = true;
                } else if (uri.startsWith("http")) {
                    proxyUserName = System.getProperty("http.proxyUserName");
                    proxyPassword = System.getProperty("http.proxyPassword");
                    proxyEnabled = true;
                }
                if (proxyEnabled) {
                    String encoded = new String(Base64.encode(new String(proxyUserName + ":" + proxyPassword).getBytes()));
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
                inputStream = conn.getInputStream();
                url = conn.getURL();
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("resolved00", url.toString()));
                }
            }
            catch (MalformedURLException e) {
                File file = new File(uri);
                if (file != null) {
                    url = file.toURL();
                    break block20;
                }
                throw e;
            }
            catch (IOException f) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("failConnect00", url.toString(), f.getMessage()));
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return url;
    }

    public void setId(String id) {
        this.username = id;
    }

    public void setPass(String pw) {
        this.password = pw;
    }

    public void setEnv(ToolEnv env) {
        this.env = env;
        this.myWSIUtils.setEnv(env);
    }

    public void setTimeout(long timeout) {
        this.timeoutms = timeout;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void enableWSIChecking(boolean wsiCheck) {
        this.myWSIUtils.enableWSIChecking(wsiCheck);
    }

    private void setInfoDoc(Info info, String location, String parentFileName) throws MalformedURLException, IOException, ParserConfigurationException, SAXException {
        block10: {
            try {
                InputSource inputSource = this._getInputSource(info.url.toString(), location);
                if (info.url.toString().startsWith("file:") && inputSource != null) {
                    info.doc = XMLUtils.newDocument(inputSource, this.w2jResolver);
                } else if (inputSource != null) {
                    info.doc = XMLUtils.newDocument(inputSource, this.w2jResolver, this.retry, this.timeoutms);
                }
            }
            catch (FileNotFoundException f) {
                InputSource inputSource;
                info.url = Utils.getURL(this.latestURL, location);
                info.url = this._makeAbsoluteURL(info.url.toString());
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("loadingFile00", "imported", info.url.toString(), parentFileName));
                }
                if ((inputSource = this._getInputSource(info.url.toString(), location)) != null) {
                    info.doc = XMLUtils.newDocument(inputSource, this.w2jResolver, this.retry, this.timeoutms);
                }
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("failConnect00", info.url.toString(), e.getMessage()));
                }
                throw e;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug(Messages.getMessage("failConnect00", info.url.toString(), e.getMessage()));
            }
        }
    }

    public void close() {
    }

    class Info {
        public URL url;
        public Document doc;
        public Definition def;

        Info() {
        }
    }
}

