/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.introspect.TypeEntryIntrospector;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;

public class MessageEntryIntrospector {
    protected static Log log = LogFactory.getLog(MessageEntryIntrospector.class.getName());
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;

    MessageEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(MessageEntry mEntry) {
        Entry entry = (Entry)mEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
        if (entry != mEntry) {
            return;
        }
        JavaHelpers javaType = this.findSimpleException(mEntry);
    }

    void introspect2(MessageEntry mEntry) {
        Entry entry = (Entry)mEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
        if (entry != mEntry) {
            return;
        }
        JavaHelpers javaType = this.findSimpleException(mEntry);
        if (javaType == null) {
            return;
        }
        JavaClass bean = (JavaClass)javaType;
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectClass00", mEntry.getQName().toString(), bean.infoString()));
        }
        List beanPropDescs = BeanUtils.getPd(bean, this.emitter.getToolEnv());
        this.processFaultParts(mEntry, beanPropDescs);
        this.validateException(mEntry, javaType);
    }

    private void validateException(MessageEntry mEntry, JavaHelpers javaType) {
        JavaClass javaClass = (JavaClass)javaType;
        JavaClass exceptionClass = (JavaClass)this.classFactory.forName("java.lang.Exception");
        if (exceptionClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Exception"));
        }
        if (!exceptionClass.isAssignableFrom(javaType)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault00", javaType.getJavaName(), exceptionClass.getName()));
        } else {
            boolean constructorFound = false;
            String constructor = javaType.getJavaName().substring(javaType.getJavaName().lastIndexOf(46) + 1);
            List methods = javaClass.getPublicMethodsNamed(constructor);
            ArrayList order = (ArrayList)mEntry.getDynamicVar("constructorOrder");
            for (int i = 0; i < methods.size(); ++i) {
                Method method2 = (Method)methods.get(i);
                EList params = method2.getParameters();
                if (order != null && params.size() != order.size()) continue;
                constructorFound = true;
                if (method2.getJavaExceptions() == null || method2.getJavaExceptions().size() <= 0) continue;
                mEntry.setDynamicVar("throwsCheckedException", Boolean.TRUE);
            }
            if (!constructorFound) {
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault01", javaType.getJavaName(), constructor, String.valueOf(order.size())));
            }
        }
    }

    JavaHelpers findSimpleException(MessageEntry mEntry) {
        return TypeEntryIntrospector.locateClass(mEntry, this.emitter, this.classFactory);
    }

    private void processFaultParts(MessageEntry message, List list) {
        for (int i = 0; i < message.getFaultParts().size(); ++i) {
            ChildEntry cEntry = (ChildEntry)message.getFaultParts().get(i);
            TypeEntryIntrospector.processChild(message, cEntry, list, true, this.emitter, this.symbolTable, this.classFactory);
        }
    }
}

