/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava.description;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.eclipse.jem.java.JavaHelpers;

public class ParameterDesc
implements Serializable {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    private transient QName name;
    private byte mode = 1;
    private QName typeQName;
    private JavaHelpers javaType = null;
    private int order = -1;
    private boolean isReturn = false;
    private String mimeType = null;
    private boolean inHeader = false;
    private boolean outHeader = false;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc copy) {
        this.name = copy.name;
        this.mode = copy.mode;
        this.typeQName = copy.typeQName;
        this.javaType = copy.javaType;
        this.order = copy.order;
        this.isReturn = copy.isReturn;
        this.mimeType = copy.mimeType;
    }

    public ParameterDesc(QName name, byte mode, QName typeQName) {
        this.name = name;
        this.mode = mode;
        this.typeQName = typeQName;
    }

    public ParameterDesc(QName name, byte mode, QName typeQName, JavaHelpers javaType, boolean inHeader, boolean outHeader) {
        this(name, mode, typeQName);
        this.javaType = javaType;
        this.inHeader = inHeader;
        this.outHeader = outHeader;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String text = "";
        text = text + indent + "name:       " + this.name + "\n";
        text = text + indent + "mode:       " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\n";
        text = text + indent + "isReturn:   " + this.isReturn + "\n";
        text = text + indent + "typeQName:  " + this.typeQName + "\n";
        text = text + indent + "javaType:   " + this.javaType + "\n";
        text = text + indent + "inHeader:   " + this.inHeader + "\n";
        text = text + indent + "outHeader:  " + this.outHeader + "\n";
        return text;
    }

    public static byte modeFromString(String modeStr) {
        int ret = 1;
        if (modeStr == null) {
            return 1;
        }
        if (modeStr.equalsIgnoreCase("out")) {
            ret = 2;
        } else if (modeStr.equalsIgnoreCase("inout")) {
            ret = 3;
        }
        return (byte)ret;
    }

    public static String getModeAsString(byte mode) {
        if (mode == 3) {
            return "inout";
        }
        if (mode == 2) {
            return "out";
        }
        if (mode == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(mode)));
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String name) {
        this.name = new QName("", name);
    }

    public void setQName(QName name) {
        this.name = name;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public JavaHelpers getJavaType() {
        return this.javaType;
    }

    public JavaHelpers getHeldJavaType(Emitter emitter) {
        JavaHelpers heldType = Utils.getHolderValueType(this.javaType, emitter.getToolEnv().getClassFactory());
        if (heldType == null) {
            heldType = this.javaType;
        }
        return heldType;
    }

    public void setJavaType(JavaHelpers javaType, Emitter emitter) {
        if (javaType != null) {
            JavaHelpers heldType = Utils.getHolderValueType(javaType, emitter.getToolEnv().getClassFactory());
            if ((this.mode == 1 || this.isReturn) && heldType != null || this.mode != 1 && !this.isReturn && heldType == null) {
                throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", javaType.getJavaName(), ParameterDesc.getModeAsString(this.mode)));
            }
        }
        this.javaType = javaType;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setInHeader(boolean value) {
        this.inHeader = value;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean value) {
        this.outHeader = value;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean value) {
        this.isReturn = value;
    }
}

