/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.internal.impl.FieldImpl;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog(BeanPropertyDescriptor.class.getName());
    private FieldImpl field = null;
    private String name = null;
    private Method readMethod = null;
    private Method writeMethod = null;
    private Method indexedReadMethod = null;
    private Method indexedWriteMethod = null;
    private JavaHelpers type = null;

    BeanPropertyDescriptor(FieldImpl field) {
        this.name = field.getName();
        this.type = field.getJavaType();
        this.field = field;
    }

    BeanPropertyDescriptor(String name, Method readMethod, Method writeMethod, Method indexedReadMethod, Method indexedWriteMethod) {
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.indexedReadMethod = indexedReadMethod;
        this.indexedWriteMethod = indexedWriteMethod;
        this.type = readMethod.getReturnType();
    }

    BeanPropertyDescriptor(String name, Method readMethod, Method writeMethod) {
        this(name, readMethod, writeMethod, null, null);
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.field != null || this.readMethod != null;
    }

    public boolean isWriteable() {
        return this.field != null || this.writeMethod != null;
    }

    public boolean isIndexed() {
        return this.field != null && this.field.isArray() || this.indexedReadMethod != null;
    }

    public JavaHelpers getType() {
        if (this.isIndexed()) {
            return ((ArrayType)this.type).getComponentTypeAsHelper();
        }
        return this.type;
    }

    public JavaHelpers getRawType() {
        return this.type;
    }

    public boolean isField() {
        return this.field != null;
    }

    public String getReadMethodName() {
        return this.readMethod == null ? null : this.readMethod.getName();
    }

    public String getWriteMethodName() {
        return this.writeMethod == null ? null : this.writeMethod.getName();
    }

    public boolean hasCheckedException() {
        EList exceptions2 = null;
        if (this.readMethod != null && (exceptions2 = this.readMethod.getJavaExceptions()) != null && exceptions2.size() > 0) {
            return true;
        }
        if (this.writeMethod != null && (exceptions2 = this.writeMethod.getJavaExceptions()) != null && exceptions2.size() > 0) {
            return true;
        }
        if (this.indexedReadMethod != null && (exceptions2 = this.indexedReadMethod.getJavaExceptions()) != null && exceptions2.size() > 0) {
            return true;
        }
        return this.indexedWriteMethod != null && (exceptions2 = this.indexedWriteMethod.getJavaExceptions()) != null && exceptions2.size() > 0;
    }
}

