/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.wsdl.fromJava.SchemaWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Types;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import javax.xml.namespace.QName;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaHelpers;
import org.w3c.dom.Element;

class ArrayWriter
extends SchemaWriter {
    JavaHelpers objectClass = null;

    ArrayWriter(Types types2) {
        super(types2);
    }

    boolean isWriter(JavaHelpers javaType, QName xmlType) {
        return Constants.SOAP_ARRAY.equals(Utils.getTypeQName(javaType, this.types.getTypeMapping(), this.types.getEmitter().getCustomRegistry(), this.types.getEmitter().getToolEnv().getClassFactory()));
    }

    void writeSchema(JavaHelpers javaType, QName xmlType) throws Exception {
        String dimString = "[]";
        JavaHelpers componentType = this.getComponentType(javaType);
        while (componentType.isArray()) {
            dimString = dimString + "[]";
            componentType = this.getComponentType(componentType);
        }
        String fullTypeName = this.types.writeType(componentType, null) + dimString;
        componentType = this.getComponentType(javaType);
        Element complexType = this.types.createElement("complexType");
        Element schema = this.types.writeSchemaElement(xmlType.getNamespaceURI());
        if (schema != null) {
            schema.appendChild(complexType);
        }
        complexType.setAttribute("name", xmlType.getLocalPart());
        if (this.types.getUse() == Use.LITERAL) {
            QName componentTypeQName = this.types.getTypeQName(componentType);
            Element sequence = this.types.createElement("sequence");
            complexType.appendChild(sequence);
            Element element = this.types.createElement("element");
            sequence.appendChild(element);
            element.setAttribute("name", componentTypeQName.getLocalPart());
            String typeType = this.types.writeType(componentType, componentTypeQName);
            if (typeType == null || typeType.equals("")) {
                QName anyQN = Constants.XSD_ANYTYPE;
                String prefix = this.types.getNamespaces().getCreatePrefix(anyQN.getNamespaceURI());
                typeType = prefix + ":" + anyQN.getLocalPart();
            } else {
                this.types.recordReference(xmlType.getNamespaceURI(), this.types.getTypeQName(componentType).getNamespaceURI());
            }
            element.setAttribute("type", typeType);
            element.setAttribute("maxOccurs", "unbounded");
            element.setAttribute("minOccurs", "0");
            if (this.types.isNullable(componentType)) {
                element.setAttribute("nillable", "true");
            }
        } else {
            Element complexContent = this.types.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element restriction = this.types.createElement("restriction");
            complexContent.appendChild(restriction);
            restriction.setAttribute("base", "soapenc:Array");
            Element attribute = this.types.createElement("attribute");
            restriction.appendChild(attribute);
            attribute.setAttribute("ref", "soapenc:arrayType");
            attribute.setAttribute("wsdl:arrayType", fullTypeName);
        }
    }

    private JavaHelpers getComponentType(JavaHelpers container) {
        if (container.isArray()) {
            return ((ArrayType)container).getComponentTypeAsHelper();
        }
        if (this.objectClass == null) {
            this.objectClass = this.types.getEmitter().getToolEnv().getClassFactory().forName("java.lang.Object");
            if (this.objectClass == null) {
                throw new InternalException(new ClassNotFoundException("java.lang.Object"));
            }
        }
        return this.objectClass;
    }
}

