/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.CLArgsParser;
import com.ibm.ws.webservices.engine.utils.CLOption;
import com.ibm.ws.webservices.engine.utils.CLOptionDescriptor;
import com.ibm.ws.webservices.engine.utils.CLUtil;
import com.ibm.ws.webservices.engine.utils.DefaultAuthenticator;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.Parser;
import java.io.FileNotFoundException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class WSDL2 {
    protected static final int DEBUG_OPT = 68;
    protected static final int HELP_OPT = 104;
    protected static final int NETWORK_TIMEOUT_OPT = 79;
    protected static final int NETWORK_RETRY_OPT = 82;
    protected static final int VERBOSE_OPT = 118;
    protected static final int USE_RESOLVER_OPT = 117;
    protected CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, Messages.getMessage("optionHelp00")), new CLOptionDescriptor("verbose", 8, 118, Messages.getMessage("optionVerbose00")), new CLOptionDescriptor("timeout", 2, 79, Messages.getMessage("optionTimeout00")), new CLOptionDescriptor("retry", 2, 82, Messages.getMessage("optionRetry00")), new CLOptionDescriptor("Debug", 8, 68, Messages.getMessage("optionDebug00")), new CLOptionDescriptor("useResolver", 2, 117, Messages.getMessage("optionUseResolver00"))};
    protected String wsdlURI = null;
    protected Parser parser = this.createParser();

    protected WSDL2() {
    }

    protected Parser createParser() {
        return new Parser();
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void addOptions(CLOptionDescriptor[] newOptions) {
        if (newOptions != null && newOptions.length > 0) {
            CLOptionDescriptor[] allOptions = new CLOptionDescriptor[this.options.length + newOptions.length];
            System.arraycopy(this.options, 0, allOptions, 0, this.options.length);
            System.arraycopy(newOptions, 0, allOptions, this.options.length, newOptions.length);
            this.options = allOptions;
        }
    }

    protected void parseOption(CLOption option) {
        switch (option.getId()) {
            case 0: {
                if (this.wsdlURI != null) {
                    System.out.println(Messages.getMessage("w2jDuplicateWSDLURI00", this.wsdlURI, option.getArgument()));
                    this.printUsage();
                }
                this.wsdlURI = option.getArgument();
                break;
            }
            case 104: {
                this.printUsage();
                break;
            }
            case 79: {
                String timeoutValue = option.getArgument();
                long timeout = Long.parseLong(timeoutValue);
                if (timeout > 0L) {
                    timeout *= 1000L;
                }
                this.parser.setTimeout(timeout);
                break;
            }
            case 82: {
                String retryValue = option.getArgument();
                int retry = Integer.parseInt(retryValue);
                this.parser.setRetry(retry);
                break;
            }
            case 118: {
                this.parser.setVerbose(true);
                break;
            }
            case 68: {
                this.parser.setDebug(true);
                break;
            }
            case 117: {
                try {
                    this.parser.setResolver(option.getArgument(), true);
                    break;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.WSDL2.parseOption", "205", this);
                    System.out.println(e.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    protected void validateOptions() {
        if (this.wsdlURI == null) {
            System.out.println(Messages.getMessage("w2jMissingWSDLURI00"));
            this.printUsage();
        }
        this.checkForAuthInfo(this.wsdlURI);
        Authenticator.setDefault(new DefaultAuthenticator(this.parser.getUsername(), this.parser.getPassword()));
    }

    private void checkForAuthInfo(String uri) {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.gen.WSDL2.checkForAuthInfo", "223", this);
            return;
        }
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            int i = userInfo.indexOf(58);
            if (i >= 0) {
                this.parser.setUsername(userInfo.substring(0, i));
                this.parser.setPassword(userInfo.substring(i + 1));
            } else {
                this.parser.setUsername(userInfo);
            }
        }
    }

    protected void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getMessage("usage00", "java " + this.getClass().getName() + " [options] WSDL-URI")).append(lSep);
        msg.append(Messages.getMessage("options00")).append(lSep);
        msg.append(CLUtil.describeOptions(this.options).toString());
        System.out.println(msg.toString());
        System.exit(1);
    }

    protected void run(String[] args) {
        CLArgsParser argsParser = new CLArgsParser(args, this.options);
        if (null != argsParser.getErrorString()) {
            System.err.println(Messages.getMessage("error01", argsParser.getErrorString()));
            this.printUsage();
        }
        Vector clOptions = argsParser.getArguments();
        int size = clOptions.size();
        try {
            for (int i = 0; i < size; ++i) {
                this.parseOption((CLOption)clOptions.get(i));
            }
            this.validateOptions();
            this.parser.setToolEnv(DefaultToolEnv.create());
            this.parser.run(this.wsdlURI);
            System.exit(0);
        }
        catch (FileNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.gen.WSDL2.run", "311", this);
            System.exit(1);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.wsdl.gen.WSDL2.run", "315", this);
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        WSDL2 wsdl2 = new WSDL2();
        wsdl2.run(args);
    }
}

