/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.NoopFactory;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Parser {
    protected ToolEnv env = null;
    protected boolean debug = false;
    protected boolean verbose = false;
    protected boolean displayDevelopmentMessages = true;
    protected String username = null;
    protected String password = null;
    private long timeoutms = 45000L;
    private int retry = 0;
    private GeneratorFactory genFactory = null;
    private SymbolTable symbolTable = null;
    protected MetaInfo metaInfo = new MetaInfo();
    private boolean parsed = false;
    private boolean logToConsole = true;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getLogToConsole() {
        return this.logToConsole;
    }

    public void setLogToConsole(boolean ltc) {
        this.logToConsole = ltc;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDisplayDevelopmentMessages(boolean value) {
        this.displayDevelopmentMessages = value;
    }

    public boolean getDisplayDevelopmentMessages() {
        return this.displayDevelopmentMessages;
    }

    public void setTimeout(long timeout) {
        this.timeoutms = timeout;
    }

    public long getTimeout() {
        return this.timeoutms;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public int getRetry() {
        return this.retry;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public GeneratorFactory getFactory() {
        return this.genFactory;
    }

    public void setFactory(GeneratorFactory factory) {
        this.genFactory = factory;
    }

    public void setResolver(String resolverClassName, boolean wsiCheck) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.metaInfo.setImportResolver((ImportResolver)ClassUtils.forName(resolverClassName).newInstance());
        this.metaInfo.setWSICheck(wsiCheck);
    }

    public void setResolver(ImportResolver resolver, boolean wsiCheck) {
        this.metaInfo.setImportResolver(resolver);
        this.metaInfo.setWSICheck(wsiCheck);
    }

    public ImportResolver getResolver() {
        return this.metaInfo.getImportResolver();
    }

    public void setToolEnv(ToolEnv env) {
        this.env = env;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Definition getCurrentDefinition() {
        return this.symbolTable == null ? null : this.symbolTable.getDefinition();
    }

    public String getWSDLURI() {
        return this.symbolTable == null ? null : this.symbolTable.getWSDLURI();
    }

    public void run(String wsdlURI) throws Exception {
        this.parse(wsdlURI);
        this.generate();
    }

    protected void setup() throws IOException {
    }

    public void parse(String wsdlURI) throws Exception {
        if (!this.parsed) {
            this.setup();
            if (this.getFactory() == null) {
                this.setFactory(new NoopFactory());
            }
            if (this.env == null) {
                this.env = DefaultToolEnv.create();
            }
            this.metaInfo.setBaseTypeMapping(this.genFactory.getBaseTypeMapping());
            this.metaInfo.setRetry(this.retry);
            this.metaInfo.setTimeout(this.timeoutms);
            this.metaInfo.setProperty("debugMode", new Boolean(this.debug));
            this.symbolTable = new SymbolTable(this.env, this.metaInfo, true, this.verbose);
            this.symbolTable.setWarnUnmappableTypes(this.displayDevelopmentMessages);
            try {
                this.symbolTable.populate(wsdlURI, this.username, this.password);
            }
            catch (FileNotFoundException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.Parser.parse", "309", this);
                if (this.logToConsole) {
                    this.env.reportFatalErr(Messages.getMessage("wsdlFileNotFound", wsdlURI, e.getMessage()));
                }
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.gen.Parser.parse", "313", this);
                throw e;
            }
            this.parsed = true;
        }
    }

    public void run(String context, Document doc) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        this.metaInfo.setBaseTypeMapping(this.genFactory.getBaseTypeMapping());
        this.metaInfo.setProperty("debugMode", new Boolean(this.debug));
        this.symbolTable = new SymbolTable(this.env, this.metaInfo, true, this.verbose);
        this.symbolTable.setWarnUnmappableTypes(this.displayDevelopmentMessages);
        this.symbolTable.populate(context, doc);
        this.generate(this.symbolTable);
    }

    public void run(String context, Document doc, Definition def) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        this.metaInfo.setBaseTypeMapping(this.genFactory.getBaseTypeMapping());
        this.metaInfo.setProperty("debugMode", new Boolean(this.debug));
        this.symbolTable = new SymbolTable(this.env, this.metaInfo, true, this.verbose);
        this.symbolTable.setWarnUnmappableTypes(this.displayDevelopmentMessages);
        this.symbolTable.populateUsingDefinition(context, doc, def);
        this.generate(this.symbolTable);
    }

    public void generate() throws IOException {
        if (!this.parsed) {
            if (this.logToConsole) {
                this.getToolEnv().reportFatalErr(Messages.getMessage("illegalGenAttempt"));
            }
            throw new IOException(Messages.getMessage("illegalGenAttempt"));
        }
        this.generate(this.symbolTable);
    }

    private void generate(SymbolTable symbolTable) throws IOException {
        symbolTable.setServicesToBeWritten((Set)this.metaInfo.getProperty("servicesToWrite"));
        symbolTable.secondPass();
        Definition def = symbolTable.getDefinition();
        this.genFactory.generatorPass(def, symbolTable);
        if (this.isDebug()) {
            symbolTable.dump(System.out);
        }
        if (!this.env.getSuspendGen()) {
            this.generateTypes(symbolTable);
        }
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                Generator gen = null;
                if (entry instanceof MessageEntry) {
                    gen = this.genFactory.getGenerator(((MessageEntry)entry).getMessage(), symbolTable);
                } else if (entry instanceof PortTypeEntry) {
                    PortTypeEntry pEntry = (PortTypeEntry)entry;
                    if (pEntry.getPortType().isUndefined()) continue;
                    gen = this.genFactory.getGenerator(pEntry.getPortType(), symbolTable);
                } else if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    if (binding.isUndefined() || !bEntry.isReferenced()) continue;
                    gen = this.genFactory.getGenerator(binding, symbolTable);
                } else if (entry instanceof ServiceEntry) {
                    gen = this.genFactory.getGenerator(((ServiceEntry)entry).getService(), symbolTable);
                }
                if (gen == null || this.env.getSuspendGen()) continue;
                gen.generate();
            }
        }
        Generator gen = this.genFactory.getGenerator(def, symbolTable);
        if (!this.env.getSuspendGen()) {
            gen.generate();
        }
        if (this.env.getSuspendGen()) {
            throw new IOException(Messages.getMessage("fatalErr"));
        }
    }

    private void generateTypes(SymbolTable symbolTable) throws IOException {
        Vector types2 = symbolTable.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            TypeEntry type = (TypeEntry)types2.elementAt(i);
            Generator gen = this.genFactory.getGenerator(type, symbolTable);
            gen.generate();
        }
    }
}

