/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools.resource;

import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.webservices.engine.encoding.custom.Utils;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;

public abstract class ToolEnv {
    private ClassFactory classFactory = new ClassFactory(this);
    private JavaSearchCriteria javaSearch = null;
    protected String javaOutputDir = null;
    private boolean suspendGen = false;
    protected boolean isJavaIntrospectionAllowed = false;
    protected boolean allowRelativeNamespace = false;
    private CompoundClassLoader classLoader = null;

    public abstract boolean fileExists(String var1);

    public abstract PrintWriter getPrintWriter(String var1) throws IOException;

    public abstract OutputStream getOutputStream(String var1) throws IOException;

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract char getSeparatorChar();

    public abstract void mkdir(String var1) throws IOException;

    public abstract void report(String var1);

    public abstract void reportWarning(String var1);

    public abstract void reporterr(String var1);

    public void reportFatalErr(String error) {
        if (!this.suspendGen) {
            this.reporterr(Messages.getMessage("fatalError"));
            this.suspendGen = true;
        }
        this.reporterr(error);
    }

    public abstract boolean isJavaIntrospectionAllowed();

    public void allowJavaIntrospection() {
        this.isJavaIntrospectionAllowed = true;
    }

    public boolean isRelativeNamespaceAllowed() {
        return this.allowRelativeNamespace;
    }

    public void allowRelativeNamespace(boolean allow) {
        this.allowRelativeNamespace = allow;
    }

    public abstract void setJavaContext(ResourceSet var1);

    public abstract ResourceSet getJavaContext();

    public void setJavaSearch(JavaSearchCriteria javaSearch) {
        this.javaSearch = javaSearch;
    }

    public JavaSearchCriteria getJavaSearch() {
        return this.javaSearch;
    }

    public void setJavaOutputDir(String javaOutputDir) {
        this.javaOutputDir = javaOutputDir;
    }

    public CompoundClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public boolean getSuspendGen() {
        return this.suspendGen;
    }

    public char getPathSeparatorChar() {
        return File.pathSeparatorChar;
    }

    public void setIntrospectionClassPath(String classPath) {
        StringTokenizer tokenizer = new StringTokenizer(classPath, "" + this.getPathSeparatorChar());
        String[] pathList = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            pathList[i] = tokenizer.nextToken();
            ++i;
        }
        PrivilegedAction object = new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl;
            }
        };
        ClassLoader parentClassLoader = (ClassLoader)AccessController.doPrivileged(object);
        this.classLoader = new CompoundClassLoader(pathList, parentClassLoader, false);
        ResourceSet rs = this.getJavaContext();
        EList list = rs.getAdapterFactories();
        for (i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof JavaJDKAdapterFactory)) continue;
            JavaJDKAdapterFactory jjaf = (JavaJDKAdapterFactory)list.get(i);
            jjaf.setContextClassLoader(this.classLoader);
        }
    }

    public List getCustomBindingProviders(Object classpath) throws PrivilegedActionException {
        PrivilegedAction object = new PrivilegedAction(){

            public Object run() {
                ClassLoader l = Thread.currentThread().getContextClassLoader();
                return l;
            }
        };
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(object);
        String classpathStr = null;
        if (classpath != null && classpath instanceof String) {
            classpathStr = (String)classpath;
        }
        if (classpathStr != null && classpathStr.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(classpathStr, File.pathSeparator);
            URL[] urls = new URL[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                try {
                    URL temp = new URL("file:" + tokenizer.nextToken());
                    urls[i++] = temp;
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
            loader = new URLClassLoader(urls, loader);
        }
        return this.loadCustomProviders(loader);
    }

    protected List loadCustomProviders(final ClassLoader loader) {
        return (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Utils.loadCustomProviders(loader);
            }
        });
    }
}

