/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools.resource;

import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.util.JavaContext;

public class DefaultToolEnv
extends ToolEnv {
    private static DefaultToolEnv env = null;
    private ResourceSet javaContext;
    private static final String SuppressMessagesValue = (String)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.startup.wsdl.suppressMessages");

    public static DefaultToolEnv create() {
        return DefaultToolEnv.create(false);
    }

    public static DefaultToolEnv create(boolean skipWCCMMappingPass) {
        if (env == null) {
            env = new DefaultToolEnv();
            if (!skipWCCMMappingPass) {
                env.setJavaContext(JavaContext.createJavaContext());
            }
        }
        DefaultToolEnv newEnv = new DefaultToolEnv();
        newEnv.setJavaContext(env.getJavaContext());
        return newEnv;
    }

    private DefaultToolEnv() {
    }

    public boolean fileExists(String urlString) {
        JavaSearchCriteria javaSearch;
        block7: {
            javaSearch = this.getJavaSearch();
            if (javaSearch.equals(JavaSearchCriteria.BOTH) || javaSearch.equals(JavaSearchCriteria.FILE)) {
                try {
                    URL url = new URL(urlString);
                    if (new File(url.getFile()).exists()) {
                        return true;
                    }
                }
                catch (MalformedURLException e) {
                    if (!new File(urlString).exists()) break block7;
                    return true;
                }
            }
        }
        if (javaSearch.equals(JavaSearchCriteria.BOTH) || javaSearch.equals(JavaSearchCriteria.CLASSPATH)) {
            if (this.javaOutputDir != null) {
                urlString = urlString.substring(this.javaOutputDir.length() + 1);
            }
            urlString = urlString.substring(0, urlString.lastIndexOf(46)).replace(this.getSeparatorChar(), '.');
            if (this.getClassFactory().forName(urlString) != null) {
                return true;
            }
        }
        return false;
    }

    public PrintWriter getPrintWriter(String urlString) throws IOException {
        File file = null;
        File parent = null;
        try {
            URL url = new URL(urlString);
            file = new File(url.getFile());
        }
        catch (MalformedURLException e) {
            file = new File(urlString);
        }
        parent = new File(file.getParent());
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        return new PrintWriter(new BufferedWriter(writer));
    }

    public OutputStream getOutputStream(String urlString) throws IOException {
        File parent;
        File file = null;
        try {
            URL url = new URL(urlString);
            file = new File(url.getFile());
        }
        catch (MalformedURLException e) {
            file = new File(urlString);
        }
        String parentStr = file.getParent();
        if (parentStr != null && (parent = new File(parentStr)) != null && !parent.exists()) {
            parent.mkdirs();
        }
        return new FileOutputStream(file);
    }

    public InputStream getInputStream(String urlString) throws IOException {
        File file = null;
        try {
            URL url = new URL(urlString);
            file = new File(url.getFile());
        }
        catch (MalformedURLException e) {
            file = new File(urlString);
        }
        return new FileInputStream(file);
    }

    public char getSeparatorChar() {
        return File.separatorChar;
    }

    public void mkdir(String urlString) throws IOException {
        File packageDir = new File(urlString);
        packageDir.mkdirs();
    }

    public void report(String progress) {
        this.reportPrint(progress, System.out);
    }

    public void reportWarning(String warning) {
        this.reportPrint(warning, System.err);
    }

    public void reporterr(String error) {
        this.reportPrint(error, System.err);
    }

    public boolean isJavaIntrospectionAllowed() {
        return true;
    }

    public void setJavaContext(ResourceSet context) {
        this.javaContext = context;
    }

    public ResourceSet getJavaContext() {
        if (this.javaContext == null) {
            this.setJavaContext(JavaContext.createJavaContext());
        }
        return this.javaContext;
    }

    private void reportPrint(String message, PrintStream ps) {
        if (message == null || SuppressMessagesValue.equals("ALL")) {
            return;
        }
        int indexOf = 11;
        if (SuppressMessagesValue.equals("ERROR") ? message.toLowerCase().indexOf("error:") == indexOf || message.toLowerCase().indexOf("warning:") == indexOf || message.toLowerCase().indexOf("info:") == indexOf : (SuppressMessagesValue.equals("WARNING") ? message.toLowerCase().indexOf("warning:") == indexOf || message.toLowerCase().indexOf("info:") == indexOf : SuppressMessagesValue.equals("INFO") && message.toLowerCase().indexOf("info:") == indexOf)) {
            return;
        }
        ps.println(message);
    }
}

