/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.soap;

import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.models.ModelServiceProvider;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.provider.soap.SOAPBindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.soap.ServiceProxy;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.commons.logging.Log;

public class SOAPServiceProvider
extends ModelServiceProvider {
    protected static Log log = LogFactory.getLog(SOAPServiceProvider.class.getName());

    public String getName() {
        return "soap";
    }

    protected String[] getSupportedBindingNamespaces() {
        return new String[]{"http://schemas.xmlsoap.org/wsdl/soap/"};
    }

    protected String[] getRequiredClasses() {
        return new String[]{"com.ibm.ws.webservices.engine.client.Service"};
    }

    public ExtensionDescription[] getExtensionDescriptions() {
        return new ExtensionDescription[0];
    }

    public BindingGenerator[] getBindingGenerators() {
        return new BindingGenerator[]{new SOAPBindingGenerator("http"), new SOAPBindingGenerator("jms")};
    }

    public StubGenerator getStubGenerator(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new JavaStubWriter(emitter, bEntry, st);
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public Transport makeTransport(ServiceContext context) {
        return null;
    }

    protected Service makeService(ServiceContext context) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPServiceProvider::makeService");
        }
        Definition def = context.getDefinition();
        Service locator = context.getGeneratedService();
        ServiceProxy service = null;
        if (def == null) {
            if (log.isDebugEnabled()) {
                log.debug("WSDL definition is null, creating basic Service.");
            }
            service = new ServiceProxy(locator);
        } else {
            QName serviceName = context.getServiceName();
            Hashtable namespace2packageMapping = this.getNamespace2packageMappings();
            ClientEngine engine2 = null;
            if (context.isManagedEnvironment()) {
                engine2 = context.getClientEngine();
            }
            if (log.isDebugEnabled()) {
                log.debug("WSDL definition is non-null, creating full-powered Service from WSDL definition.");
            }
            service = new ServiceProxy(engine2, def, serviceName, namespace2packageMapping, locator);
            service.setServiceRefName(context.getServiceRefName());
            service.setWSDLDocumentLocation(context.getWSDLDocumentLocation());
            if (log.isDebugEnabled()) {
                log.debug("Set Service's serviceRefName to: " + context.getServiceRefName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPServiceProvider::makeService");
        }
        return service;
    }

    protected Hashtable getNamespace2packageMappings() {
        return new Hashtable();
    }

    public static void initTypeMapping(WebServicesEngine engine2, HashMap xmlType2JavaTypeMapping) {
        TypeMappingRegistry tmr = engine2.getTypeMappingRegistry();
        TypeMapping tm = SOAPServiceProvider.getTypeMapping(tmr, "http://schemas.xmlsoap.org/soap/encoding/");
        Iterator i = xmlType2JavaTypeMapping.keySet().iterator();
        while (i.hasNext()) {
            QName xmlType = (QName)i.next();
            Class javaType = (Class)xmlType2JavaTypeMapping.get(xmlType);
            SOAPServiceProvider.registerType(tm, javaType, xmlType);
        }
    }

    protected static void registerType(TypeMapping tm, Class javaType, QName xmlType) {
        SerializerFactory sf = BaseSerializerFactory.createFactory(BeanSerializerFactory.class, javaType, xmlType);
        DeserializerFactory df = BaseDeserializerFactory.createFactory(BeanDeserializerFactory.class, javaType, xmlType);
        if (sf != null || df != null) {
            tm.register(javaType, xmlType, sf, df);
        }
    }

    protected static TypeMapping getTypeMapping(javax.xml.rpc.encoding.TypeMappingRegistry tmr, String encoding) {
        TypeMapping tm = tmr.getTypeMapping(encoding);
        TypeMapping defaultTM = tmr.getDefaultTypeMapping();
        if (tm == null || tm == defaultTM) {
            tm = tmr.createTypeMapping();
            tm.setSupportedEncodings(new String[]{encoding});
            tmr.register(encoding, tm);
        }
        return tm;
    }
}

