/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.discovery;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator;
import com.ibm.ws.webservices.multiprotocol.extensions.CompositeExtensionRegistry;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionRegistrySupplier;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.webservices.wsdl.extensions.ExtensionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import org.apache.commons.logging.Log;

public class ServiceProviderManager {
    protected static Log log = LogFactory.getLog(ServiceProviderManager.class.getName());
    protected List additionalServiceProviders;
    protected Map namespace2ServiceProviderCache;
    protected WSDLFactoryImpl wsdlFactory;
    protected boolean useDiscovery;
    public static final String SERVICE_PROVIDER_PFX1 = "jaxrpc.service.provider.default.";
    public static final String SERVICE_PROVIDER_PFX2 = "jaxrpc.service.provider.uri.";
    static /* synthetic */ Class class$javax$wsdl$Input;
    static /* synthetic */ Class class$javax$wsdl$Output;

    public ServiceProviderManager() {
        this(null, true);
    }

    public ServiceProviderManager(List additionalServiceProviders) {
        this(additionalServiceProviders, true);
    }

    public ServiceProviderManager(List additionalServiceProviders, boolean useDiscovery) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderManager ctor");
            log.debug("useDiscovery=" + useDiscovery + "additionalServiceProviders=" + additionalServiceProviders);
        }
        this.additionalServiceProviders = additionalServiceProviders;
        this.useDiscovery = useDiscovery;
        this.namespace2ServiceProviderCache = new HashMap();
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderManager ctor");
        }
    }

    public Iterator getAllServiceProviders() {
        ArrayList<ServiceProvider> allServiceProviders = new ArrayList<ServiceProvider>(this.getAdditionalProviders());
        allServiceProviders.addAll(this.getDiscoveredServiceProviders());
        Collection c = this.namespace2ServiceProviderCache.values();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)i.next();
            if (serviceProvider == null || allServiceProviders.contains(serviceProvider)) continue;
            allServiceProviders.add(serviceProvider);
        }
        return allServiceProviders.iterator();
    }

    public ServiceProvider getServiceProvider(String namespaceURI) {
        ServiceProvider serviceProvider = (ServiceProvider)this.namespace2ServiceProviderCache.get(namespaceURI);
        if (serviceProvider == null) {
            ArrayList serviceProviders = this.getSupportingServiceProvider(namespaceURI);
            serviceProvider = serviceProviders.size() == 0 ? null : (serviceProviders.size() == 1 ? (ServiceProvider)serviceProviders.get(0) : this.chooseServiceProvider(serviceProviders, namespaceURI));
            this.namespace2ServiceProviderCache.put(namespaceURI, serviceProvider);
        }
        return serviceProvider;
    }

    public boolean isServiceProviderAvailable(String ns1) {
        ServiceProvider ServiceProvider2 = this.getServiceProvider(ns1);
        boolean supported = ServiceProvider2 != null;
        return supported;
    }

    public void overrideDefaultServiceProvider(String bindingNamespace, ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            this.namespace2ServiceProviderCache.remove(bindingNamespace);
        } else {
            this.namespace2ServiceProviderCache.put(bindingNamespace, serviceProvider);
        }
    }

    public WSDLFactory getWSDLFactory() {
        if (this.wsdlFactory == null) {
            this.wsdlFactory = new WSDLFactoryImpl();
            ExtensionRegistry extensionRegistry = this.getExtensionRegistry();
            this.wsdlFactory.setPopulatedExtensionRegistry(extensionRegistry);
        }
        return this.wsdlFactory;
    }

    protected ExtensionRegistry getExtensionRegistry() {
        CompositeExtensionRegistry compositeExtensionRegistry = new CompositeExtensionRegistry();
        this.registerCommonExtensions(compositeExtensionRegistry);
        Iterator i = this.getAllServiceProviders();
        while (i.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)i.next();
            ExtensionDescription[] extensionDescriptions = serviceProvider.getExtensionDescriptions();
            if (extensionDescriptions != null) {
                for (int j = 0; j < extensionDescriptions.length; ++j) {
                    compositeExtensionRegistry.registerExtension(extensionDescriptions[j]);
                }
            }
            if (!(serviceProvider instanceof ExtensionRegistrySupplier)) continue;
            ExtensionRegistry extensionRegistry = ((ExtensionRegistrySupplier)((Object)serviceProvider)).getExtensionRegistry();
            compositeExtensionRegistry.addExtensionRegistry(extensionRegistry);
        }
        return compositeExtensionRegistry;
    }

    private void registerCommonExtensions(CompositeExtensionRegistry er) {
        er.registerExtension(new AgnosticAddress().getExtensionDescription());
        for (int i = 0; i < Constants.ACTIONS_WSA.length; ++i) {
            er.registerExtensionAttributeType(class$javax$wsdl$Input == null ? ServiceProviderManager.class$("javax.wsdl.Input") : class$javax$wsdl$Input, Constants.ACTIONS_WSA[i], 0);
            er.registerExtensionAttributeType(class$javax$wsdl$Output == null ? ServiceProviderManager.class$("javax.wsdl.Output") : class$javax$wsdl$Output, Constants.ACTIONS_WSA[i], 0);
        }
        ExtensionUtils.addSerializers(er);
    }

    protected List getDiscoveredServiceProviders() {
        ArrayList discoveredServiceProviders = this.useDiscovery ? ServiceProviderLocator.getInstance().getServiceProviders() : new ArrayList();
        return discoveredServiceProviders;
    }

    protected ArrayList getSupportingServiceProvider(String namespaceURI) {
        ArrayList<ServiceProvider> supportingServices = new ArrayList<ServiceProvider>();
        Iterator i = this.getAllServiceProviders();
        while (i.hasNext()) {
            ServiceProvider p = (ServiceProvider)i.next();
            if (!p.isBindingNamespaceSupported(namespaceURI)) continue;
            supportingServices.add(p);
        }
        return supportingServices;
    }

    protected ServiceProvider chooseServiceProvider(ArrayList Service2, String uri) {
        if (Service2 == null || Service2.size() < 1) {
            return null;
        }
        return (ServiceProvider)Service2.get(0);
    }

    protected List getAdditionalProviders() {
        if (this.additionalServiceProviders == null) {
            this.additionalServiceProviders = new ArrayList();
        }
        return this.additionalServiceProviders;
    }
}

