/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.modutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.client.ApplicationWSDLLocator;
import com.ibm.ws.webservices.client.ModuleWSDLLocator;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.modutils.ClientBndUtil;
import com.ibm.ws.webservices.modutils.PreferredPortDescriptor;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.w3c.dom.Document;

public class WSDLPPMapper {
    protected static final TraceComponent tc = Tr.register(WSDLPPMapper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private String wsdlName = null;
    private ResourceSet resourceSet = null;
    private WSDLQuery queryTool = null;
    private String noneValue = "none";
    private WSDLFactoryImpl wsdlFactory;

    public WSDLPPMapper(String wName, InputStream wsdlInputStream, LoadStrategy loadStrategy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDLPPMapper(wName,InputStream), WSDL: ", wName);
        }
        this.wsdlName = wName;
        try {
            if (this.wsdlFactory == null) {
                this.wsdlFactory = new WSDLFactoryImpl();
            }
            WSDLReader reader = this.wsdlFactory.newWSDLReader();
            Definition wsdlDefinition = reader.readWSDL(new ModuleWSDLLocator(wName, wsdlInputStream, loadStrategy));
            this.queryTool = new WSDLQuery();
            Document newDoc = null;
            if (wsdlDefinition != null) {
                WSDLWriter writer = this.wsdlFactory.newWSDLWriter();
                newDoc = writer.getDocument(wsdlDefinition);
            }
            this.queryTool.parse(wName, newDoc, wsdlDefinition);
        }
        catch (WebServicesFault wsf) {
            FFDCFilter.processException(wsf, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "119");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(wsf));
            }
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "127");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(t));
            }
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDLPPMapper(wName ,InputStream) c'tor");
        }
    }

    public WSDLPPMapper(ResourceSet resourceSet, String wName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDLPPMapper, WSDL: ", wName);
        }
        this.resourceSet = resourceSet;
        this.wsdlName = wName;
        URIConverter converter = resourceSet.getURIConverter();
        URI uri = URI.createURI(this.wsdlName);
        try {
            InputStream wsdlInputStream = converter.createInputStream(uri);
            if (this.wsdlFactory == null) {
                this.wsdlFactory = new WSDLFactoryImpl();
            }
            WSDLReader reader = this.wsdlFactory.newWSDLReader();
            Definition wsdlDefinition = reader.readWSDL((WSDLLocator)new ApplicationWSDLLocator(wName, wsdlInputStream, resourceSet));
            this.queryTool = new WSDLQuery();
            Document newDoc = null;
            if (wsdlDefinition != null) {
                WSDLWriter writer = this.wsdlFactory.newWSDLWriter();
                newDoc = writer.getDocument(wsdlDefinition);
            }
            this.queryTool.parse(wName, newDoc, wsdlDefinition);
        }
        catch (WebServicesFault wsf) {
            FFDCFilter.processException(wsf, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "181");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(wsf));
            }
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "189");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(t));
            }
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exiting WSDLPPMapper c'tor");
        }
    }

    public HashMap getPreferredPortMap(String serviceQName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferredPortMap", serviceQName);
        }
        HashMap<String, PreferredPortDescriptor> preferredPortMap = new HashMap<String, PreferredPortDescriptor>();
        String serviceNorm = ClientBndUtil.normalizeServiceName(serviceQName);
        if (this.queryTool == null) {
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        } else {
            HashMap services = this.queryTool.getServices();
            Iterator keys = services.keySet().iterator();
            while (keys.hasNext()) {
                String serviceName = (String)keys.next();
                QName qn = QName.valueOf(serviceName);
                String localPart = qn.getLocalPart();
                if (!localPart.equals(serviceNorm)) continue;
                HashMap allPorts = this.queryTool.getPorts(serviceName);
                Iterator keysP = allPorts.keySet().iterator();
                while (keysP.hasNext()) {
                    String portName = (String)keysP.next();
                    PortEntry portEntry = (PortEntry)allPorts.get(portName);
                    Port port = portEntry.getPort();
                    Binding binding = port.getBinding();
                    PortType portType = binding.getPortType();
                    String portTypeKey = portType.getQName().toString();
                    PreferredPortDescriptor ppd = (PreferredPortDescriptor)preferredPortMap.get(portTypeKey);
                    if (ppd == null) {
                        ppd = new PreferredPortDescriptor();
                        ppd.addSupportedPort(this.noneValue);
                    }
                    ppd.addSupportedPort(portName);
                    preferredPortMap.put(portTypeKey, ppd);
                }
                break block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferredPortMap");
        }
        return preferredPortMap;
    }

    public void setNoneValue(String val) {
        if (val != null) {
            this.noneValue = val;
        }
    }

    public static boolean validPreferredPort(HashMap preferredPortMap, String portType, String port) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validPreferredPort", new Object[]{portType, port});
        }
        boolean isValid = false;
        QName checkPortQName = QName.valueOf(port);
        if (checkPortQName.getNamespaceURI() == null || checkPortQName.getNamespaceURI().equals("")) {
            QName portTypeQName = QName.valueOf(portType);
            QName adjustedPortQName = new QName(portTypeQName.getNamespaceURI(), port);
            port = adjustedPortQName.toString();
        }
        PreferredPortDescriptor ppd = (PreferredPortDescriptor)preferredPortMap.get(portType);
        ArrayList ports = ppd.getSupportedPorts();
        isValid = ports.contains(port);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validPreferredPort", new Boolean(isValid));
        }
        return isValid;
    }
}

