/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.IOException;
import org.xml.sax.InputSource;

public final class XMLInputSourceAlternateContent
extends AlternateContentBase {
    public static XMLInputSourceAlternateContent create(InputSource content) {
        content = WebServicesInputSource.create((InputSource)content);
        ((WebServicesInputSource)content).setCopyIfNotResettable(true);
        return new XMLInputSourceAlternateContent(content, AlternateContentBase.CONTENT_PLUS_TAG);
    }

    public static XMLInputSourceAlternateContent createContentOnly(InputSource content) {
        content = WebServicesInputSource.create((InputSource)content);
        ((WebServicesInputSource)content).setCopyIfNotResettable(true);
        return new XMLInputSourceAlternateContent(content, AlternateContentBase.CONTENT_ONLY);
    }

    XMLInputSourceAlternateContent(InputSource content, short contentFlag) {
        super(content, contentFlag);
    }

    protected final Object getContent() {
        try {
            WebServicesInputSource wsis = (WebServicesInputSource)this.content;
            WebServicesInputSource wsis2 = WebServicesInputSource.create((byte[])wsis.getBytes());
            wsis2.setPublicId(wsis.getPublicId());
            wsis2.setSystemId(wsis.getSystemId());
            wsis2.setEncoding(wsis.getEncoding());
            return wsis2;
        }
        catch (RuntimeException re2) {
            throw re2;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent.getContent", "91", this);
            throw new RuntimeException(e);
        }
    }

    protected String getXMLString() throws Exception {
        if (this.contentFlag == AlternateContentBase.CONTENT_ONLY) {
            return null;
        }
        WebServicesInputSource wsis = (WebServicesInputSource)this.content;
        return wsis.getString();
    }

    protected InputSource getXMLInputSource() throws Exception {
        if (this.contentFlag == AlternateContentBase.CONTENT_ONLY) {
            return null;
        }
        return (InputSource)this.getContent();
    }

    protected void serialize(SerializationContext context, boolean includeNSDecls) throws Exception {
        WebServicesInputSource wsis = (WebServicesInputSource)this.content;
        if (this.contentFlag == AlternateContentBase.CONTENT_ONLY) {
            MappingScope ms = this._getMappingScope(this.owner);
            if (includeNSDecls) {
                ms = this._getMappingScope(this.owner);
                MappingScope msAncestors = this._getMappingScopeForAncestorsNotWritten(context);
                ms.setParent(msAncestors);
                ms = ms.flatten();
            }
            context.getSerializationWriter().startElement(this.owner.getQName(), this.owner.getPrefix(), this.owner.getSAXAttributes(), ms);
            try {
                byte[] buf = wsis.getBytes();
                String enc = wsis.getEncoding();
                context.getSerializationWriter().write(buf, enc);
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.xmlsoap.ext.InputStreamAlternateContent.serialize", "60", this);
                throw ex;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.ext.InputStreamAlternateContent.serialize", "64", this);
                throw e;
            }
            if (this.owner instanceof SOAPBody) {
                context.outputMultiRefs();
            }
            context.getSerializationWriter().endElement();
        } else {
            MappingScope ms = null;
            if (includeNSDecls) {
                ms = this._getMappingScopeForAncestorsNotWritten(context);
            }
            if (ms == null || !ms.hasMappings()) {
                context.getSerializationWriter().write(wsis.getBytes(), wsis.getEncoding());
            } else {
                context.getSerializationWriter().writeSnippet(wsis.getString(), ms);
            }
        }
    }
}

