/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.io.Serializable;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public final class QNameTable
implements Serializable {
    private static Hashtable table = new Hashtable();
    private static final String emptyString = "".intern();

    public static QName createQName(String namespaceURI, String localPart) {
        if (namespaceURI == null) {
            namespaceURI = emptyString;
        }
        Object value = table.get(localPart);
        QName qName = null;
        if (value == null) {
            qName = new QName(namespaceURI, localPart);
            table.put(localPart, qName);
            return qName;
        }
        if (value instanceof QName) {
            QName q = (QName)value;
            if (q.getNamespaceURI() == namespaceURI || q.getNamespaceURI().equals(namespaceURI)) {
                return q;
            }
            Hashtable<String, QName> table2 = new Hashtable<String, QName>();
            table.put(localPart, table2);
            qName = new QName(namespaceURI, localPart);
            table2.put(namespaceURI, qName);
            table2.put(q.getNamespaceURI(), q);
            return qName;
        }
        Hashtable table2 = (Hashtable)value;
        QName q = (QName)table2.get(namespaceURI);
        if (q != null) {
            return q;
        }
        qName = new QName(namespaceURI, localPart);
        table2.put(namespaceURI, qName);
        return qName;
    }

    public static QName createQName(String prefixedName, MappingScope mappingScope) {
        String localPart;
        String prefix;
        int i = prefixedName.indexOf(58);
        if (i > 0) {
            prefix = prefixedName.substring(0, i);
            localPart = prefixedName.substring(i + 1);
        } else {
            prefix = emptyString;
            localPart = prefixedName;
        }
        Mapping map = mappingScope.getMappingForPrefix(prefix, false);
        if (map == null) {
            throw new RuntimeException(Messages.getMessage("unmappedPrefix00", prefix));
        }
        return QNameTable.createQName(map.getNamespaceURI(), localPart);
    }
}

