/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.HashMap;

public final class HrefTable {
    protected HashMap hrefMap = null;
    protected HashMap fixupMap = null;
    protected DeserializationContext context;

    public HrefTable(DeserializationContext context) {
        this.context = context;
    }

    public SOAPElement getElementByHref(String href) {
        Object ret;
        if (href == null) {
            return null;
        }
        if (this.hrefMap != null && (ret = this.hrefMap.get(href)) instanceof SOAPElement) {
            return (SOAPElement)ret;
        }
        return null;
    }

    public Object getObjectByHref(String href) {
        Attachments attch;
        Message msg;
        Object ret;
        if (href == null) {
            return null;
        }
        if (this.hrefMap != null && (ret = this.hrefMap.get(href)) != null) {
            return ret;
        }
        if (!href.startsWith("#") && (msg = this.context.getMessageContext().getCurrentMessage()) != null && (attch = msg.getAttachmentsImpl()) != null) {
            try {
                return attch.getAttachmentByReference(href);
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.HrefTable.getObjectByHref", "117", this);
                throw new RuntimeException(e.toString() + JavaUtils.stackToString(e));
            }
        }
        return null;
    }

    public void addObjectByID(String id, Object obj) {
        if (id == null) {
            return;
        }
        if (this.hrefMap == null) {
            this.hrefMap = new HashMap();
        }
        String href = '#' + id;
        this.hrefMap.put(href, obj);
    }

    public void registerFixupByHref(String href, Deserializer dser) {
        Deserializer prev;
        if (this.fixupMap == null) {
            this.fixupMap = new HashMap();
        }
        if ((prev = this.fixupMap.put(href, dser)) != null && prev != dser) {
            dser.moveValueTargets(prev);
            if (dser.getDefaultType() == null) {
                dser.setDefaultType(prev.getDefaultType());
            }
        }
    }

    public Deserializer unregisterFixupByID(String id) {
        if (id == null) {
            return null;
        }
        if (this.fixupMap != null) {
            String href = '#' + id;
            return (Deserializer)this.fixupMap.remove(href);
        }
        return null;
    }
}

