/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOM2Writer {
    public static String nodeToString(Node node, boolean omitXMLDecl) {
        StringWriter writer = new StringWriter();
        DOM2Writer.serializeAsXML(node, writer, omitXMLDecl);
        String str = writer.getBuffer().toString();
        return str;
    }

    public static void serializeAsXML(Node node, Writer writer, boolean omitXMLDecl) {
        DOM2Writer.serializeAsXML(node, writer, omitXMLDecl, false);
    }

    public static void serializeAsXML(Node node, Writer writer, boolean omitXMLDecl, boolean pretty) {
        try {
            SerializationWriter SW = new SerializationWriter(writer, "UTF-8", !omitXMLDecl);
            SW.setPretty(pretty);
            if (node instanceof Document) {
                SW.writeDOMElement(((Document)node).getDocumentElement());
            } else if (node instanceof Element) {
                SW.writeDOMElement((Element)node);
            }
            writer.flush();
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.DOM2Writer.serializeAsXML", "142");
        }
    }

    public static String normalize(String s) {
        return XMLUtils.xmlEncodeString(s);
    }
}

