/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleBeanDeserializer
extends SimpleDeserializer {
    protected Class proxy;
    DeserializationContext context = null;

    public SimpleBeanDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public SimpleBeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        super(javaType, xmlType);
    }

    protected Object makeValue(String source) throws Exception {
        Deserializer dSer = null;
        BeanPropertyDescriptor bpd = null;
        FieldDesc fieldDesc = this.beanDesc.getFieldDesc("", "_value");
        if (fieldDesc != null) {
            bpd = fieldDesc.getPropertyDescriptor();
            dSer = this.getCachedDeserializer(fieldDesc, this.context);
            Deserializer deserializer = dSer = dSer != null ? dSer : this.getDeserializer(null, fieldDesc.getJavaType(), null, this.context);
        }
        if (dSer == null) {
            throw new SAXException(Messages.getMessage("noDeser00", "_value of " + this.javaType));
        }
        dSer.onStartElement("", "_value", "", NullAttributes.singleton, null, this.context);
        dSer.characters(source);
        dSer.endElement("", "_value", this.context);
        Object val = dSer.getValue();
        bpd.set(this.value, val);
        return this.value;
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        this.context = context;
        this.createValue();
        this.processAttributes(attributes, mappingScope, context, false);
    }

    protected void createValue() throws SAXException {
        try {
            this.value = this.javaType.newInstance();
        }
        catch (Exception e) {
            try {
                Object ret = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return SimpleBeanDeserializer.this.javaType.getClassLoader();
                        }
                        catch (Throwable e) {
                            return e;
                        }
                    }
                });
                ClassLoader clsLoader = null;
                if (ret instanceof ClassLoader) {
                    clsLoader = (ClassLoader)ret;
                }
                Class helper = null;
                if (clsLoader == null) {
                    helper = ClassUtils.forName(this.javaType.getName() + "_Helper");
                } else {
                    try {
                        helper = ClassUtils.forName(this.javaType.getName() + "_Helper", true, clsLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        helper = ClassUtils.forName(this.javaType.getName() + "_Helper");
                    }
                }
                Method method2 = null;
                try {
                    method2 = (Method)AccessController.doPrivileged(new getMethodPRIV(helper, "createProxy"));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                this.value = method2.invoke(null, null);
                this.proxy = this.value.getClass();
                this.beanDesc.setBeanPropertyDescriptors(this.proxy);
                this.propertyMap = this.beanDesc.getPropertyDescriptorMap();
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.createValue", "644", this);
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
            }
        }
    }

    public boolean recycle() {
        boolean recycled = super.recycle();
        if (recycled) {
            this.context = null;
        }
        return recycled;
    }

    public final void valueComplete() throws SAXException {
        if (this.proxy != null && this.componentsReady()) {
            try {
                Method method2 = null;
                try {
                    method2 = (Method)AccessController.doPrivileged(new getMethodPRIV(this.proxy, "convert"));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                this.value = method2.invoke(this.value, null);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.valueComplete", "662", this);
                throw new SAXException(e);
            }
        }
        super.valueComplete();
    }

    private class getMethodPRIV
    implements PrivilegedExceptionAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        public Object run() throws Exception {
            return this.clazz.getMethod(this.methodName, null);
        }
    }
}

