/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JAFDataHandlerSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(JAFDataHandlerSerializer.class.getName());
    protected QName xmlType;
    protected Class javaType;

    public JAFDataHandlerSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        DataHandler dh = (DataHandler)value;
        Attachments attachments = context.getCurrentMessage().getAttachmentsImpl();
        if (attachments == null) {
            throw new IOException(Messages.getMessage("noAttachments"));
        }
        Part attachmentPart = attachments.createAttachmentPart((Object)dh, name.getLocalPart());
        if (this.isSwaRefOrAXISAttachment(name, context)) {
            context.getSerializationWriter().simpleElement(name, attributes, attachmentPart.getContentIdRef());
        } else {
            boolean serializeDataHandlerAxisStyle;
            String attchStyle = (String)context.getMessageContext().getProperty("com.ibm.ws.webservices.engine.attachment.style");
            boolean bl = serializeDataHandlerAxisStyle = attchStyle != null && attchStyle.equals("HREF");
            if (!serializeDataHandlerAxisStyle && Constants.MIME_DATA_HANDLER.equals(this.xmlType)) {
                serializeDataHandlerAxisStyle = MCUtils.isPropertyEnabled(context.getMessageContext(), "com.ibm.websphere.webservices.serializeDataHandlerAxisStyle");
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg("com.ibm.websphere.webservices.serializeDataHandlerAxisStyle", serializeDataHandlerAxisStyle));
                }
            }
            if (serializeDataHandlerAxisStyle) {
                AttributesImpl attrs = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attrs.setAttributes(attributes);
                }
                int typeIndex = -1;
                typeIndex = attrs.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (typeIndex != -1) {
                    attrs.removeAttribute(typeIndex);
                }
                attrs.addAttribute("", "href", "href", "CDATA", attachmentPart.getContentIdRef());
                context.getSerializationWriter().simpleElement(name, attrs, null);
            }
        }
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context, RequestResponse rr) throws IOException {
        String cid;
        Attachments attachments;
        DataHandler dh;
        block11: {
            dh = (DataHandler)value;
            attachments = context.getCurrentMessage().getAttachmentsImpl();
            if (attachments == null) {
                throw new IOException(Messages.getMessage("noAttachments"));
            }
            Vector params = null;
            cid = null;
            String paramName = null;
            try {
                params = rr.getParams();
                ParamValue param = (ParamValue)params.elementAt(0);
                paramName = param.getName();
                Object element = param.getValue();
                if (!(element instanceof SOAPElement) || !paramName.equals("body")) break block11;
                Iterator i = ((SOAPElement)element).getChildElements();
                while (i.hasNext()) {
                    SOAPElement se = (SOAPElement)i.next();
                    String seln = se.getLocalName();
                    if (!seln.equals("attachment")) continue;
                    String cid_value = se.getFirstChild().getNodeValue();
                    int idx = cid_value.indexOf(":");
                    cid = cid_value.substring(idx + 1);
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializer", "238", this);
                log.error(e);
            }
        }
        Part attachmentPart = attachments.createAttachmentPart((Object)dh, name.getLocalPart(), cid);
        if (this.isSwaRefOrAXISAttachment(name, context)) {
            context.getSerializationWriter().simpleElement(name, attributes, attachmentPart.getContentIdRef());
        } else {
            boolean serializeDataHandlerAxisStyle;
            String attchStyle = (String)context.getMessageContext().getProperty("com.ibm.ws.webservices.engine.attachment.style");
            boolean bl = serializeDataHandlerAxisStyle = attchStyle != null && attchStyle.equals("HREF");
            if (!serializeDataHandlerAxisStyle && Constants.MIME_DATA_HANDLER.equals(this.xmlType)) {
                serializeDataHandlerAxisStyle = MCUtils.isPropertyEnabled(context.getMessageContext(), "com.ibm.websphere.webservices.serializeDataHandlerAxisStyle");
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg("com.ibm.websphere.webservices.serializeDataHandlerAxisStyle", serializeDataHandlerAxisStyle));
                }
            }
            if (serializeDataHandlerAxisStyle) {
                AttributesImpl attrs = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attrs.setAttributes(attributes);
                }
                int typeIndex = -1;
                typeIndex = attrs.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (typeIndex != -1) {
                    attrs.removeAttribute(typeIndex);
                }
                attrs.addAttribute("", "href", "href", "CDATA", attachmentPart.getContentIdRef());
                context.getSerializationWriter().simpleElement(name, attrs, null);
            }
        }
    }

    private boolean isSwaRefOrAXISAttachment(QName name, SerializationContext context) {
        OperationDesc operation;
        MessageContext msgContext;
        if (Constants.WSI_SWAREF.equals(this.xmlType)) {
            return true;
        }
        if ("http://xml.apache.org/xml-soap".equals(this.xmlType.getNamespaceURI()) && context != null && (msgContext = context.getMessageContext()) != null && (operation = msgContext.getOperation()) != null) {
            ParameterDesc param = operation.getParamByQName(name);
            if (param == null && (param = operation.getReturnParamDesc()) != null && !param.getQName().equals(name)) {
                param = null;
            }
            if (param != null) {
                return !param.isWSDL11MIME();
            }
        }
        return false;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

