/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.HrefTable;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DeserializationContextImpl
implements DeserializationContext {
    protected static Log log = LogFactory.getLog(DeserializationContextImpl.class.getName());
    private SOAPEnvelope envelope;
    protected MessageContext msgContext;
    protected P2DConverter eventConverter = null;
    protected Stack eventConverterStack = null;
    private HrefTable hrefTable = null;
    private TypeMappingRegistry tmr = null;
    private TypeMapping tm = null;
    private String encodingStyle = null;
    private InputSource inputSource = null;
    private WebServicesParser parser = null;
    private List buildNumbers = null;
    private String priorThreadName = null;
    private Exception priorThreadException = null;
    private boolean inCheckThreadAccess = false;

    public DeserializationContextImpl(InputSource is, MessageContext ctx, MessageType messageType) {
        this(is, ctx, messageType, null, Utils._isSAAJ13Enabled());
    }

    public DeserializationContextImpl(InputSource is, MessageContext ctx, MessageType messageType, SOAPConstants sc, boolean isSAAJ13Enabled) {
        this.msgContext = ctx;
        if (sc == null) {
            sc = this.getSOAPConstants();
        }
        SOAPFactory sf = new SOAPFactory(sc);
        sf.setMessageType(messageType);
        try {
            this.envelope = sf.createSOAPEnvelope(false);
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.DeserializationContextImpl", "211", this);
            throw new InternalException((Exception)((Object)se));
        }
        this.inputSource = is;
        SOAPEnvelopeBuilder builder = new SOAPEnvelopeBuilder(this.envelope);
        builder.setMyElement(this.envelope);
        if (this.inputSource != null) {
            this.createEventConverter(new WrapperProcessor(builder));
        }
    }

    public DeserializationContextImpl(InputSource is, MessageContext ctx, MessageType messageType, SOAPEnvelope envelope) {
        this.envelope = envelope;
        SOAPEnvelopeBuilder builder = new SOAPEnvelopeBuilder(envelope);
        envelope.getSOAPFactory().setMessageType(messageType);
        this.msgContext = ctx;
        this.inputSource = is;
        if (this.inputSource != null) {
            this.createEventConverter(new WrapperProcessor(builder));
        }
    }

    public DeserializationContextImpl(MessageContext ctx, DEventProcessor initialProcessor) {
        this.msgContext = ctx;
        if (initialProcessor instanceof SOAPEnvelopeBuilder) {
            this.envelope = ((SOAPEnvelopeBuilder)initialProcessor).getEnvelope();
        }
    }

    public void parse() throws SAXException {
        if (this.inputSource != null) {
            this.parser = (WebServicesParser)XMLUtils.getSAXParser();
            try {
                block5: {
                    try {
                        this.parser.parse(this.inputSource, (DefaultHandler)this.getEventConverter());
                        InputStream is = this.inputSource.getByteStream();
                        if (is == null) break block5;
                        is.close();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.parse", "269", this);
                        throw MCUtils.interceptDeserializationException(e, this);
                    }
                }
                Object var3_3 = null;
                this.parser.recycle();
                this.parser = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.parser.recycle();
                this.parser = null;
                throw throwable;
            }
            this.inputSource = null;
            this.freeEventConverter();
        }
    }

    public InputStream getLazyParse() throws SAXException {
        if (this.parser == null) {
            return null;
        }
        return this.parser.getSubTreeAsStream();
    }

    public P2DConverter getEventConverter() {
        if (this.eventConverterStack != null && this.eventConverterStack.size() > 0) {
            this._checkThreadAccess();
            return (P2DConverter)this.eventConverterStack.peek();
        }
        return this.eventConverter;
    }

    public void createEventConverter(DEventProcessor processor) {
        P2DConverter ec = new P2DConverter(processor, this);
        if (this.eventConverter == null) {
            this.eventConverter = ec;
        } else {
            if (this.eventConverterStack == null) {
                this.eventConverterStack = new Stack();
            }
            this._checkThreadAccess();
            this.eventConverterStack.push(ec);
        }
    }

    public void freeEventConverter() {
        if (this.eventConverterStack != null && this.eventConverterStack.size() > 0) {
            this._checkThreadAccess();
            this.eventConverterStack.pop();
        } else {
            this.eventConverter = null;
        }
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public HrefTable getHrefTable() {
        if (this.hrefTable == null) {
            this.hrefTable = new HrefTable(this);
        }
        return this.hrefTable;
    }

    public final Deserializer getDeserializer(Class javaType, QName xmlType) {
        Deserializer dser;
        block9: {
            if (xmlType == null) {
                return null;
            }
            DeserializerFactory dserF = null;
            dser = null;
            try {
                dserF = (DeserializerFactory)this.getTypeMapping().getDeserializer(javaType, xmlType);
            }
            catch (JAXRPCException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getDeserializer", "390", this);
                log.error(Messages.getMessage("noFactory00", xmlType.toString()));
            }
            if (dserF != null) {
                try {
                    dser = (Deserializer)dserF.getDeserializerAs("WebServices SAX Mechanism");
                }
                catch (JAXRPCException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getDeserializer", "397", this);
                    TypeMappingRegistry tmr = this.getTypeMappingRegistry();
                    if (tmr.getRegisteredEncodingStyleURIs().length == 0) {
                        log.error(Messages.getMessage("noDSerErr02", xmlType.toString()));
                        break block9;
                    }
                    log.error(Messages.getMessage("noDSerErr02", xmlType.toString()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("DeserializationContextImpl: dserF is null");
            }
        }
        return dser;
    }

    public TypeMapping getTypeMapping() {
        if (this.tm == null) {
            this.tm = (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        }
        return this.tm;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            this.encodingStyle = this.msgContext.getEncodingStyle();
        }
        if (log.isDebugEnabled()) {
            log.debug("DeserializationContextImpl: getEncodingStyle() says " + this.encodingStyle);
        }
        return this.encodingStyle;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = this.msgContext.getTypeMappingRegistry();
        }
        return this.tmr;
    }

    private SOAPConstants getSOAPConstants() {
        SOAPConstants constants = null;
        if (this.msgContext != null) {
            constants = this.msgContext.getSOAPConstants();
        }
        if (constants == null) {
            constants = SOAPConstants.SOAP11_CONSTANTS;
        }
        return constants;
    }

    public void setSimpleEventOptimization(boolean enable) {
        if (enable) {
            this.getEventConverter().enableSimpleEvent();
        } else {
            this.getEventConverter().disableSimpleEvent();
        }
    }

    public boolean isSimpleEventEnabled() {
        return this.getEventConverter().isSimpleEventEnabled();
    }

    public void logBuildNumber(String buildNumber) {
        if (buildNumber != null) {
            if (this.buildNumbers == null) {
                this.buildNumbers = new ArrayList();
            }
            if (!this.buildNumbers.contains(buildNumber)) {
                this.buildNumbers.add(buildNumber);
            }
        }
    }

    public List getBuildNumbers() {
        if (this.buildNumbers == null) {
            this.buildNumbers = new ArrayList();
        }
        return this.buildNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _checkThreadAccess() {
        Thread currentThread = Thread.currentThread();
        if (this.priorThreadName == null || !currentThread.getName().equals(this.priorThreadName)) {
            DeserializationContextImpl deserializationContextImpl = this;
            synchronized (deserializationContextImpl) {
                if (this.inCheckThreadAccess) {
                    return;
                }
                this.inCheckThreadAccess = true;
                Exception e = new Exception("Thread Trace");
                if (this.priorThreadName != null) {
                    String text = "Possible Simultaneous Multi-Thread Access Discovered \n Prior Thread = " + this.priorThreadName + "\n Current Thread = " + currentThread.getName() + "\n Prior Stack = " + JavaUtils.stackToString(this.priorThreadException) + "\n Current Stack = " + JavaUtils.stackToString(e);
                    log.error(Messages.getMessage("exception01", text));
                }
                this.priorThreadName = currentThread.getName();
                this.priorThreadException = e;
                this.inCheckThreadAccess = false;
            }
        }
    }
}

