/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.BaseDesc;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class OperationDesc
extends BaseDesc {
    public static String TARGET_NAMESPACE = "targetNamespace";
    public static String INPUT_MESSAGE_QNAME = "inputMessageQName";
    public static String OUTPUT_MESSAGE_QNAME = "outputMessageQName";
    public static String INPUT_NAME = "inputName";
    public static String OUTPUT_NAME = "outputName";
    public static String FAULT_NAME = "faultName";
    public static String INPUT_WSA_ACTION = "inputWSAAction";
    public static String OUTPUT_WSA_ACTION = "outputWSAAction";
    public static String FAULT_WSA_ACTION = "faultWSAAction";
    public static String PORT_TYPE_QNAME = "portTypeQName";
    public static String INPUT_ENCODING_STYLE = "inputEncodingStyle";
    public static String OUTPUT_ENCODING_STYLE = "outputEncodingStyle";
    public static String USING_ADDRESSING_ELEMENT = "usingAddressing";
    public static String SERVICE_QNAME = "ServiceQName";
    public static String WSDL_UNAVAILABLE = "WSDLUnavailable";
    public static String RESPONSE_NAMESPACE = "ResponseNamespace";
    public static String RESPONSE_LOCALPART = "ResponseLocalPart";
    protected static Log log = LogFactory.getLog(OperationDesc.class.getName());
    private PortDesc parent;
    private Method method;
    private String name;
    private QName elementQName;
    private ArrayList parameters = new ArrayList();
    private ParameterDesc returnDesc = null;
    private ArrayList faults = null;
    private com.ibm.ws.webservices.engine.enumtype.Style enumtypeStyle = null;
    private com.ibm.ws.webservices.engine.enumtype.Use enumtypeUse = null;
    private String soapAction = null;
    private int numInParams = 0;
    private boolean hasOutParams = false;

    public OperationDesc() {
    }

    public OperationDesc(String name, ParameterDesc[] parameters, QName returnQName) {
        this.name = name;
        if (returnQName != null) {
            this.initReturnDesc();
            this.returnDesc.setQName(returnQName);
            this.returnDesc.setMode((byte)2);
            this.returnDesc.setIsReturn(true);
        }
        for (int i = 0; i < parameters.length; ++i) {
            this.addParameter(parameters[i]);
            if (parameters[i].getMode() == 1) continue;
            this.hasOutParams = true;
        }
    }

    public OperationDesc(String name, QName elementQName, ParameterDesc[] parameters, ParameterDesc returnDesc, FaultDesc[] faults, String soapAction) {
        int i;
        this.name = name;
        this.elementQName = elementQName;
        if (returnDesc != null) {
            this.returnDesc = returnDesc;
        }
        if (parameters != null) {
            for (i = 0; i < parameters.length; ++i) {
                this.addParameter(parameters[i]);
                if (parameters[i].getMode() == 1) continue;
                this.hasOutParams = true;
            }
        }
        if (faults != null) {
            for (i = 0; i < faults.length; ++i) {
                this.addFault(faults[i]);
            }
        }
        this.soapAction = soapAction;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        OperationDesc other = (OperationDesc)object;
        if (this.name != null && !this.name.equals(other.name) || this.name == null && other.name != null) {
            return false;
        }
        if (this.returnDesc != null && !this.returnDesc.equals(other.returnDesc) || this.returnDesc == null && other.returnDesc != null) {
            return false;
        }
        if (this.parameters != null && other.parameters == null || this.parameters == null && other.parameters != null) {
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters.size() != other.parameters.size()) {
                return false;
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if ((this.parameters.get(i) == null || this.parameters.get(i).equals(other.parameters.get(i))) && (this.parameters.get(i) != null || other.parameters.get(i) == null)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        if (this.name != null) {
            hc += this.name.hashCode();
        }
        if (this.returnDesc != null) {
            hc += this.returnDesc.hashCode();
        }
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.get(i) == null) continue;
                hc += this.parameters.get(i).hashCode();
            }
        }
        return hc;
    }

    private void initReturnDesc() {
        if (this.returnDesc == null) {
            this.returnDesc = new ParameterDesc();
            this.returnDesc.setMode((byte)2);
            this.returnDesc.setIsReturn(true);
            this.hasOutParams = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QName getReturnQName() {
        return this.returnDesc == null ? null : this.returnDesc.getQName();
    }

    public void setReturnQName(QName returnQName) {
        if (returnQName != null) {
            this.initReturnDesc();
            this.returnDesc.setQName(returnQName);
        }
    }

    public QName getReturnType() {
        return this.returnDesc == null ? null : this.returnDesc.getTypeQName();
    }

    public void setReturnType(QName returnType) {
        if (log.isDebugEnabled()) {
            log.debug("@" + Integer.toHexString(this.hashCode()) + "setReturnType(" + returnType + ")");
        }
        if (returnType != null) {
            this.initReturnDesc();
            this.returnDesc.setTypeQName(returnType);
        }
    }

    public Class getReturnClass() {
        return this.returnDesc == null ? null : this.returnDesc.getJavaType();
    }

    public void setReturnClass(Class returnClass) {
        if (returnClass != null) {
            this.initReturnDesc();
            this.returnDesc.setJavaType(returnClass);
            this.returnDesc.setJavaSigType(returnClass);
        }
    }

    public void removeReturn() {
        this.returnDesc = null;
    }

    public void removeParameters() {
        this.parameters = new ArrayList();
        this.numInParams = 0;
        this.hasOutParams = false;
    }

    public void removeFaults() {
        this.faults = null;
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName elementQName) {
        this.elementQName = elementQName;
    }

    public PortDesc getParent() {
        return this.parent;
    }

    public void setParent(PortDesc parent) {
        this.parent = parent;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void setStyle(com.ibm.ws.webservices.engine.enumtype.Style style) {
        if (log.isDebugEnabled()) {
            log.debug("OperationDesc.setStyle()" + style.toString());
        }
        this.enumtypeStyle = style;
    }

    public void setStyle(Style styleInput) {
        if (styleInput != null) {
            this.enumtypeStyle = com.ibm.ws.webservices.engine.enumtype.Style.getStyle(styleInput.toString());
        }
    }

    public com.ibm.ws.webservices.engine.enumtype.Style getStyle() {
        if (this.enumtypeStyle == null) {
            return com.ibm.ws.webservices.engine.enumtype.Style.DEFAULT;
        }
        return this.enumtypeStyle;
    }

    public void setUse(com.ibm.ws.webservices.engine.enumtype.Use useInput) {
        if (log.isDebugEnabled()) {
            log.debug("OperationDesc.setUse()  " + useInput.toString());
        }
        this.enumtypeUse = useInput;
    }

    public void setUse(Use useInput) {
        if (useInput != null) {
            this.enumtypeUse = com.ibm.ws.webservices.engine.enumtype.Use.getUse(useInput.toString());
        }
    }

    public com.ibm.ws.webservices.engine.enumtype.Use getUse() {
        if (this.enumtypeUse == null) {
            return com.ibm.ws.webservices.engine.enumtype.Use.DEFAULT;
        }
        return this.enumtypeUse;
    }

    public void addParameter(ParameterDesc param) {
        this.parameters.add(param);
        if (param.getMode() != 1) {
            this.hasOutParams = true;
        }
        if (param.getMode() == 1 || param.getMode() == 3) {
            param.setOrder(this.numInParams++);
        }
        if (log.isDebugEnabled()) {
            log.debug("added parameter >" + param + "<total parameters:" + this.getNumParams());
        }
    }

    public ParameterDesc getParameter(int i) {
        if (this.parameters.size() <= i) {
            return null;
        }
        return (ParameterDesc)this.parameters.get(i);
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    public int getNumInParams() {
        return this.numInParams;
    }

    public int getNumParams() {
        return this.parameters.size();
    }

    public int getNumInParams(boolean forBody) {
        int num = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 2 || (!forBody || param.isInHeader() || param.isMIMEType()) && (forBody || !param.isInHeader())) continue;
            ++num;
        }
        return num;
    }

    public int getNumOutParams(boolean forBody) {
        int num = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 1 || (!forBody || param.isOutHeader()) && (forBody || !param.isOutHeader())) continue;
            ++num;
        }
        return num;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method2) {
        this.method = method2;
    }

    public boolean isReturnHeader() {
        return this.returnDesc == null ? false : this.returnDesc.isOutHeader();
    }

    public void setReturnHeader(boolean value) {
        this.initReturnDesc();
        this.returnDesc.setOutHeader(value);
    }

    public ParameterDesc getParamByQName(QName qname) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (!param.getQName().equals(qname)) continue;
            return param;
        }
        ParameterDesc paramDesc = this.getInputAnyParam();
        if (paramDesc == null) {
            paramDesc = this.getOutputAnyParam();
        }
        return paramDesc;
    }

    public ParameterDesc getInputParamByQName(QName qname) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 2 || !param.getQName().equals(qname)) continue;
            return param;
        }
        return this.getInputAnyParam();
    }

    public ParameterDesc getOutputParamByQName(QName qname) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 1 || !param.getQName().equals(qname)) continue;
            return param;
        }
        ParameterDesc paramD = this.getOutputAnyParam();
        if (paramD != null) {
            return paramD;
        }
        if (this.returnDesc != null) {
            if (this.returnDesc.getQName() == null) {
                paramD = new ParameterDesc(this.returnDesc);
                paramD.setQName(qname);
            } else if (this.returnDesc.getQName().equals(qname)) {
                paramD = this.returnDesc;
            }
        }
        return paramD;
    }

    public ArrayList getOutParams() {
        ArrayList<ParameterDesc> result = new ArrayList<ParameterDesc>();
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            ParameterDesc desc = (ParameterDesc)i.next();
            if (desc.getMode() != 2) continue;
            result.add(desc);
        }
        return result;
    }

    public final ParameterDesc getInputAnyParam() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 2 || !Constants.equals(param.getQName(), Constants.XSD_ANY) && !Constants.equals(param.getTypeQName(), Constants.XSD_ANY)) continue;
            return param;
        }
        return null;
    }

    public final ParameterDesc getOutputAnyParam() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (param.getMode() == 1 || !Constants.equals(param.getQName(), Constants.XSD_ANY) && !Constants.equals(param.getTypeQName(), Constants.XSD_ANY)) continue;
            return param;
        }
        if (this.returnDesc != null && (Constants.equals(this.returnDesc.getQName(), Constants.XSD_ANY) || Constants.equals(this.returnDesc.getTypeQName(), Constants.XSD_ANY))) {
            return this.returnDesc;
        }
        return null;
    }

    public void addFault(FaultDesc fault) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        this.faults.add(fault);
    }

    public ArrayList getFaults() {
        return this.faults;
    }

    public FaultDesc getFaultByClass(Class cls) {
        if (this.faults == null || cls == null) {
            return null;
        }
        while (cls != null) {
            Iterator iterator = this.faults.iterator();
            while (iterator.hasNext()) {
                FaultDesc desc = (FaultDesc)iterator.next();
                if (!cls.getName().equals(desc.getClassName())) continue;
                return desc;
            }
            if ((cls = cls.getSuperclass()) == null || !cls.getName().startsWith("java.") && !cls.getName().startsWith("javax.")) continue;
            cls = null;
        }
        return null;
    }

    public FaultDesc getFaultByFaultCode(QName qname) {
        if (this.faults != null) {
            Iterator iterator = this.faults.iterator();
            while (iterator.hasNext()) {
                FaultDesc desc = (FaultDesc)iterator.next();
                if (!qname.equals(desc.getFaultCode())) continue;
                return desc;
            }
        }
        return null;
    }

    public ParameterDesc getReturnParamDesc() {
        return this.returnDesc;
    }

    public Set getHeaderParamQNames() {
        JAXRPCHandler.QNameSet opHeaderParams = new JAXRPCHandler.QNameSet();
        for (int i = 0; i < this.getNumParams(); ++i) {
            ParameterDesc param = this.getParameter(i);
            if (!param.isInHeader()) continue;
            opHeaderParams.add(param.getQName());
        }
        return opHeaderParams;
    }

    public boolean isOneway() {
        return this.returnDesc == null && !this.hasOutParams;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        int i;
        String text = "";
        text = text + indent + "name:        " + this.getName() + "\n";
        text = text + indent + "returnQName: " + this.getReturnQName() + "\n";
        text = text + indent + "returnType:  " + this.getReturnType() + "\n";
        text = text + indent + "returnClass: " + this.getReturnClass() + "\n";
        text = text + indent + "elementQName:" + this.getElementQName() + "\n";
        text = text + indent + "soapAction:  " + this.getSoapAction() + "\n";
        text = text + indent + "style:       " + this.getStyle().getName() + "\n";
        text = text + indent + "use:         " + this.getUse().getName() + "\n";
        text = text + indent + "numInParams: " + this.getNumInParams() + "\n";
        text = text + indent + "properties: \n";
        text = text + this.toStringConfigurable(indent + " ");
        text = text + indent + "method:" + this.getMethod() + "\n";
        for (i = 0; i < this.parameters.size(); ++i) {
            text = text + indent + " ParameterDesc[" + i + "]:\n";
            text = text + indent + ((ParameterDesc)this.parameters.get(i)).toString("  ") + "\n";
        }
        if (this.faults != null) {
            for (i = 0; i < this.faults.size(); ++i) {
                text = text + indent + " FaultDesc[" + i + "]:\n";
                text = text + indent + ((FaultDesc)this.faults.get(i)).toString("  ") + "\n";
            }
        }
        return text;
    }
}

