/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDParameter
extends WSDDElement {
    OperationDesc parent;
    ParameterDesc parameter = new ParameterDesc();

    public WSDDParameter(Element e, OperationDesc parent) throws WSDDException {
        super(e);
        String typeStr;
        String outHStr;
        String inHStr;
        this.parent = parent;
        String nameStr = e.getAttribute("qname");
        if (nameStr != null && !nameStr.equals("")) {
            this.parameter.setQName(XMLUtils.getQNameFromString(nameStr, e));
        } else {
            nameStr = e.getAttribute("name");
            if (nameStr != null && !nameStr.equals("")) {
                this.parameter.setQName(QNameTable.createQName(null, nameStr));
            }
        }
        String modeStr = e.getAttribute("mode");
        if (modeStr != null && !modeStr.equals("")) {
            this.parameter.setMode(ParameterDesc.modeFromString(modeStr));
        }
        if ((inHStr = e.getAttribute("inHeader")) != null) {
            this.parameter.setInHeader(JavaUtils.isTrueExplicitly(inHStr));
        }
        if ((outHStr = e.getAttribute("outHeader")) != null) {
            this.parameter.setOutHeader(JavaUtils.isTrueExplicitly(outHStr));
        }
        if ((typeStr = e.getAttribute("type")) != null && !typeStr.equals("")) {
            this.parameter.setTypeQName(XMLUtils.getQNameFromString(typeStr, e));
        }
    }

    public WSDDParameter() {
    }

    public WSDDParameter(ParameterDesc parameter) {
        this.parameter = parameter;
    }

    public void writeToContext(SerializationContext context) throws IOException {
        QName typeQName;
        byte mode;
        AttributesImpl attrs = new AttributesImpl();
        QName qname = this.parameter.getQName();
        if (qname != null) {
            if (qname.getNamespaceURI() != null && !qname.getNamespaceURI().equals("")) {
                attrs.addAttribute("", "qname", "qname", "CDATA", context.getSerializationWriter().qName2String(this.parameter.getQName()));
            } else {
                attrs.addAttribute("", "name", "name", "CDATA", this.parameter.getQName().getLocalPart());
            }
        }
        if ((mode = this.parameter.getMode()) != 1) {
            String modeStr = ParameterDesc.getModeAsString(mode);
            attrs.addAttribute("", "mode", "mode", "CDATA", modeStr);
        }
        if (this.parameter.isInHeader()) {
            attrs.addAttribute("", "inHeader", "inHeader", "CDATA", "true");
        }
        if (this.parameter.isOutHeader()) {
            attrs.addAttribute("", "outHeader", "outHeader", "CDATA", "true");
        }
        if ((typeQName = this.parameter.getTypeQName()) != null) {
            attrs.addAttribute("", "type", "type", "CDATA", context.getSerializationWriter().qName2String(typeQName));
        }
        context.getSerializationWriter().simpleElement(this.getElementName(), attrs, null);
    }

    public ParameterDesc getParameter() {
        return this.parameter;
    }

    public void setParameter(ParameterDesc parameter) {
        this.parameter = parameter;
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_PARAM;
    }
}

