/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDGen
extends WSDDElement {
    protected String wsdlFile = null;
    protected String wsdlContext = null;
    protected InputStream wsdlInputStream = null;
    protected Definition wsdlDefinition = null;
    protected Document wsdlTypesDoc = null;
    protected ImportResolver resolver = null;
    private ArrayList namespaces = new ArrayList();
    private ArrayList packages = new ArrayList();
    private HashMap namespaceMap = new HashMap();
    private MappingMetaData inputMapping = null;
    private boolean noDataBinding = false;

    public WSDDGen() {
    }

    public WSDDGen(Element e) throws WSDDException {
        this.wsdlFile = e.getAttribute("wsdl");
        Element[] nsPkg = this.getChildElements(e, "pair");
        for (int i = 0; i < nsPkg.length; ++i) {
            this.setNamespacePackagePair(nsPkg[i].getAttribute("namespace"), nsPkg[i].getAttribute("package"));
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "wsdl", "wsdl", "CDATA", this.wsdlFile);
        QName name = new QName("", "Gen");
        context.getSerializationWriter().startElement(name, attrs);
        for (int i = 0; i < this.namespaces.size(); ++i) {
            name = new QName("", "pair");
            attrs = new AttributesImpl();
            attrs.addAttribute("", "namespace", "namespace", "CDATA", (String)this.namespaces.get(i));
            attrs.addAttribute("", "package", "package", "CDATA", (String)this.packages.get(i));
            context.getSerializationWriter().startElement(name, attrs);
            context.getSerializationWriter().endElement();
        }
        context.getSerializationWriter().endElement();
    }

    protected QName getElementName() {
        return new QName("", "Gen");
    }

    public void setWSDLFile(String file) {
        this.wsdlFile = file;
    }

    public String getWSDLFile() {
        return this.wsdlFile;
    }

    public void setWSDLFile(String context, InputStream is) {
        this.wsdlContext = context;
        this.wsdlInputStream = is;
    }

    public void setWSDLFile(String context, Definition def, Document typesDoc) {
        this.wsdlContext = context;
        this.wsdlDefinition = def;
        this.wsdlTypesDoc = typesDoc;
    }

    public void setResolver(ImportResolver resolver) {
        this.resolver = resolver;
    }

    public void setNamespacePackagePair(String ns, String pkg) {
        if (ns != null && pkg != null) {
            this.namespaces.add(ns);
            this.packages.add(pkg);
            this.namespaceMap.put(ns, pkg);
        }
    }

    public void setInputMapping(MappingMetaData mmd) {
        this.inputMapping = mmd;
    }

    public WSDLQuery getWSDLQuery() throws Exception {
        WSDLQuery wsdlQuery = new WSDLQuery(this.namespaceMap);
        wsdlQuery.setNoDataBinding(this.noDataBinding);
        if (this.inputMapping != null) {
            wsdlQuery.setInputMapping(this.inputMapping);
        }
        if (this.resolver != null) {
            wsdlQuery.setResolver(this.resolver);
        }
        if (this.wsdlFile != null) {
            wsdlQuery.parse(this.wsdlFile);
        } else if (this.wsdlInputStream != null) {
            wsdlQuery.parse(this.wsdlContext, this.wsdlInputStream);
        } else {
            wsdlQuery.parse(this.wsdlContext, this.wsdlTypesDoc, this.wsdlDefinition);
        }
        return wsdlQuery;
    }

    public void setNoDataBinding(boolean value) {
        this.noDataBinding = value;
    }

    public boolean getNoDataBinding() {
        return this.noDataBinding;
    }
}

