/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configurable;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class ConfigurableImpl
implements Configurable {
    protected static Log log = LogFactory.getLog(ConfigurableImpl.class.getName());
    protected LockableHashtable options;

    public final void setOptionsDefault(Configured dephault) {
        this.setOptionsDefault(dephault.getOptions());
    }

    public final void setOptionsDefault(Map dephault) {
        if (this.options == null) {
            this.initOptions();
        }
        this.options.setParent(dephault);
    }

    public final void setOption(String name, Object value) {
        this.setOption(name, value, false);
    }

    public final void setOption(String name, Object value, boolean lock) {
        if (this.options == null) {
            this.initOptions();
        }
        if (this.isOptionBoolean(name)) {
            value = this.normalize(value);
        }
        this.options.put(name, value, lock);
    }

    public final void removeOption(String name) {
        if (this.options != null) {
            this.options.remove(name);
        }
    }

    public final boolean setOptionDefault(String name, Object value) {
        return this.setOptionDefault(name, value, false);
    }

    public final boolean setOptionDefault(String name, Object value, boolean lock) {
        boolean val;
        boolean bl = val = (this.options == null || this.options.get(name) == null) && value != null;
        if (val) {
            this.setOption(name, value, lock);
        }
        return val;
    }

    public final void setOptions(Map opts) {
        if (opts == null) {
            this.options = null;
        } else if (opts != this.options) {
            this.options = new LockableHashtable(opts);
            Set names = this.getOptionsBooleanNames();
            if (names != null) {
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    Object name = iter.next();
                    Object value = this.options.get(name);
                    if (value == null) {
                        this.options.put(name, Boolean.TRUE);
                        continue;
                    }
                    if (value instanceof Boolean) continue;
                    this.options.put(name, this.normalize(value));
                }
            }
        }
    }

    public final Object getOption(String name) {
        return this.options == null ? null : this.options.get(name);
    }

    public final Map getOptions() {
        return this.options;
    }

    public Set getOptionsBooleanNames() {
        return null;
    }

    private final boolean isOptionBoolean(String name) {
        Set options = this.getOptionsBooleanNames();
        return options == null ? false : options.contains(name);
    }

    protected final void initOptions() {
        this.options = new LockableHashtable();
        Set names = this.getOptionsBooleanNames();
        if (names != null) {
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                this.options.put(iter.next(), Boolean.TRUE);
            }
        }
    }

    private final Boolean normalize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return new Boolean(JavaUtils.isTrue(value));
    }
}

