/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.websphere.webservices.soap.SOAPException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.orderedset.OperationException;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.DetailEntry;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WebServicesFault
extends SOAPException {
    private static final String LS = JavaUtils.LS;
    protected static Log log = LogFactory.getLog(WebServicesFault.class.getName());
    protected QName faultCode;
    protected String faultString = "";
    protected String faultActor;
    protected Vector faultDetails;
    protected List subcodes = null;
    protected String nodeURI = null;
    protected String language = null;
    protected List reasons = null;
    private boolean soapPartFault = false;
    protected ArrayList faultHeaders = null;
    protected Exception userException;

    public static WebServicesFault makeFault(Throwable e) {
        if (e == null) {
            InternalException internalException = new InternalException("WebServicesFault.makeFault(Throwable) called with null argument.");
            log.error(Messages.getMessage("internalError00"), internalException);
            return new WebServicesFault(internalException);
        }
        if (e instanceof WebServicesFault) {
            return (WebServicesFault)e;
        }
        StringBuffer sb = new StringBuffer();
        Throwable unwrapped = WebServicesFault.getRootCause(e, sb);
        if (unwrapped == null) {
            unwrapped = e;
        }
        if (log.isDebugEnabled() && unwrapped != e) {
            log.debug("Unwrapping Exception: " + sb.toString(), e);
        }
        if (unwrapped instanceof WebServicesFault) {
            return (WebServicesFault)unwrapped;
        }
        if (unwrapped instanceof SOAPFaultException) {
            return new WebServicesFault((SOAPFaultException)unwrapped);
        }
        return new WebServicesFault(unwrapped.toString(), unwrapped);
    }

    public static WebServicesFault makeFault(String message, Throwable e) {
        if (message == null || message.trim().length() == 0) {
            return WebServicesFault.makeFault(e);
        }
        StringBuffer sb = new StringBuffer();
        e = WebServicesFault.getRootCause(e, sb);
        return new WebServicesFault(e.toString() + " " + message, e);
    }

    public static WebServicesFault makeUserFault(Exception e, QName qName) {
        if (log.isDebugEnabled()) {
            log.debug("MakeUserFault: ", e);
        }
        if (e instanceof SOAPFaultException) {
            return new WebServicesFault((SOAPFaultException)e);
        }
        WebServicesFault wsf = new WebServicesFault(e.toString(), e);
        wsf.userException = e;
        if (qName != null) {
            wsf.setFaultCode(qName);
        }
        return wsf;
    }

    public WebServicesFault(String code, String str, String actor, Element[] details) {
        super(str);
        this.setFaultCodeAsString(code);
        this.setFaultString(str);
        this.setFaultActor(actor);
        this.setFaultDetail(details);
    }

    public WebServicesFault(QName code, String str, String actor, Element[] details) {
        super(str);
        this.setFaultCode(code);
        this.setFaultString(str);
        this.setFaultActor(actor);
        this.setFaultDetail(details);
    }

    protected WebServicesFault(Exception target) {
        super("", target);
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException"));
        this.setFaultString(target.toString());
        this.initFromException(target);
    }

    public WebServicesFault(String faultString) {
        super(faultString);
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"));
        this.setFaultString(faultString);
    }

    public WebServicesFault() {
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"));
        this.setFaultString(this.toString());
        this.initFromException(this);
    }

    public WebServicesFault(String faultString, Throwable t) {
        super(faultString, t);
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"));
        this.setFaultString(faultString);
        this.initFromException(t);
    }

    public WebServicesFault(SOAPFaultException soapFault) {
        super(soapFault.getFaultString(), soapFault);
        this.setFaultCode(soapFault.getFaultCode());
        this.setFaultString(soapFault.getFaultString());
        this.setFaultActor(soapFault.getFaultActor());
        Detail detail = soapFault.getDetail();
        if (detail != null) {
            this.userException = soapFault;
            Iterator iter = detail.getDetailEntries();
            if (iter != null) {
                this.faultDetails = new Vector();
                while (iter.hasNext()) {
                    DetailEntry entry = (DetailEntry)iter.next();
                    this.faultDetails.add(entry);
                }
            }
        }
    }

    private void initFromException(Throwable target) {
        for (int i = 0; this.faultDetails != null && i < this.faultDetails.size(); ++i) {
            Element element = (Element)this.faultDetails.elementAt(i);
            if (!"stackTrace".equals(element.getLocalName())) continue;
            return;
        }
    }

    public void dump() {
        if (log.isDebugEnabled()) {
            log.debug(this.dumpToString());
        }
    }

    public String dumpToString() {
        String details = new String();
        if (this.faultDetails != null) {
            for (int i = 0; i < this.faultDetails.size(); ++i) {
                Element e = (Element)this.faultDetails.get(i);
                details = details + JavaUtils.LS + "\t" + e.getLocalName() + ": " + XMLUtils.getInnerXMLString(e);
            }
        }
        return "WebServicesFault" + JavaUtils.LS + " faultCode: " + this.faultCode + JavaUtils.LS + " faultString: " + this.faultString + JavaUtils.LS + " faultActor: " + this.faultActor + JavaUtils.LS + " faultDetail: " + details + JavaUtils.LS;
    }

    public void setFaultCode(QName code) {
        boolean deleteAnonToken = false;
        deleteAnonToken = MCUtils.isPropertyEnabled("com.ibm.websphere.webservices.disableSerializeAnonToken");
        if (log.isDebugEnabled()) {
            log.debug(MCUtils.getSettingMsg("com.ibm.websphere.webservices.disableSerializeAnonToken", deleteAnonToken));
            if (deleteAnonToken) {
                log.debug("Will remove the anonymous complexType token from " + code);
            }
        }
        if (code != null && code.getLocalPart().startsWith(">") && deleteAnonToken) {
            String namespace = "";
            String localPart = "";
            String prefix = "";
            localPart = code.getLocalPart().substring(1);
            namespace = code.getNamespaceURI();
            prefix = code.getPrefix();
            if (namespace.length() > 0 && localPart.length() > 0) {
                code = new QName(namespace, localPart, prefix);
            } else if (namespace.length() == 0 && localPart.length() > 0) {
                code = new QName(localPart);
            }
        }
        this.faultCode = code;
    }

    public void setFaultCodeAsString(String code) {
        int endCurly;
        if (code != null && code.startsWith("{") && (endCurly = code.indexOf("}")) > 0) {
            String namespace = code.substring(1, endCurly);
            String localPart = code.substring(endCurly + 1);
            this.faultCode = QNameTable.createQName(namespace, localPart);
            return;
        }
        this.faultCode = QNameTable.createQName("", code);
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String str) {
        this.faultString = str != null ? str : "";
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultActor(String actor) {
        this.faultActor = actor;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public void setFaultDetail(Element[] details) {
        if (details == null) {
            return;
        }
        this.faultDetails = new Vector(details.length);
        for (int loop = 0; loop < details.length; ++loop) {
            this.faultDetails.add(details[loop]);
        }
    }

    public void setFaultDetailString(String details) {
        this.faultDetails = new Vector();
        try {
            Document doc = XMLUtils.newDocument();
            Element element = doc.createElement("string");
            Text text = doc.createTextNode(details);
            element.appendChild(text);
            this.faultDetails.add(element);
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesFault.setFaultDetailString", "346", this);
            throw new InternalException(e);
        }
    }

    public void addFaultDetailString(String detail) {
        if (this.faultDetails == null) {
            this.faultDetails = new Vector();
        }
        try {
            Document doc = XMLUtils.newDocument();
            Element element = doc.createElement("string");
            Text text = doc.createTextNode(detail);
            element.appendChild(text);
            this.faultDetails.add(element);
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesFault.addFaultDetailString", "362", this);
            throw new InternalException(e);
        }
    }

    public Element[] getFaultDetails() {
        if (this.faultDetails == null) {
            return null;
        }
        Element[] result = new Element[this.faultDetails.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Element)this.faultDetails.elementAt(i);
        }
        return result;
    }

    public void output(SerializationContext context) throws Exception {
        SOAPFactory sf = new SOAPFactory();
        SOAPEnvelope envelope = sf.createSOAPEnvelope(true);
        SOAPFault fault = sf.createSOAPFault();
        fault.setFault(this);
        envelope.getBody().addChildElement((SOAPElement)fault);
        if (this.faultHeaders != null) {
            Iterator i = this.faultHeaders.iterator();
            while (i.hasNext()) {
                SOAPHeaderElement header = (SOAPHeaderElement)i.next();
                envelope.getHeader().addChildElement((SOAPElement)header);
            }
        }
        envelope.output(context);
    }

    public String toString() {
        return this.faultString;
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this.dumpToString());
        super.printStackTrace(ps);
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this.dumpToString());
        super.printStackTrace(pw);
    }

    public void addHeader(SOAPHeaderElement header) {
        if (this.faultHeaders == null) {
            this.faultHeaders = new ArrayList();
        }
        this.faultHeaders.add(header);
    }

    public void clearHeaders() {
        this.faultHeaders = null;
    }

    public Exception getUserException() {
        return this.userException;
    }

    public Exception getApplicationException() {
        return this.getUserException();
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable t = null;
        if (e != null && !(e instanceof WebServicesFault) && (t = WebServicesFault.unwrapCause(e)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Unwrapping Throwable: ", t);
            }
            e = WebServicesFault.getRootCause(t);
        }
        return e;
    }

    public static Throwable getRootCause(Throwable e, StringBuffer messages) {
        Throwable t = null;
        if (e != null) {
            if (messages.length() != 0) {
                messages.append(LS);
            }
            if (e instanceof WebServicesFault) {
                messages.append(((WebServicesFault)e).getFaultString());
            } else {
                messages.append(e.toString());
                t = WebServicesFault.unwrapCause(e);
                if (t != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unwrapping Throwable: ", t);
                    }
                    e = WebServicesFault.getRootCause(t, messages);
                }
            }
        }
        return e;
    }

    private static Throwable unwrapCause(Throwable e) {
        Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : (e instanceof JAXRPCException ? ((JAXRPCException)e).getLinkedCause() : (e instanceof SAXException ? ((SAXException)e).getException() : (e instanceof LifeCycleException || e instanceof ConfigurationException || e instanceof OperationException || e instanceof InternalException ? e.getCause() : null)));
        if (t == null && e.getCause() instanceof WebServicesFault) {
            t = e.getCause();
        }
        return t;
    }

    public void setSOAPPartFault(boolean isResponse) {
        this.soapPartFault = isResponse;
    }

    public boolean isSOAPPartFault() {
        return this.soapPartFault;
    }

    public boolean isUserException() {
        return this.userException != null;
    }

    public boolean isApplicationException() {
        return this.isUserException();
    }

    public String getFaultReturnCode() {
        String faultString = this.getFaultString();
        if (faultString == null) {
            return null;
        }
        String faultCode = null;
        int beginIdx = faultString.indexOf("(");
        int endIdx = faultString.indexOf(")");
        faultCode = faultString.substring(beginIdx + 1, endIdx).trim();
        return faultCode;
    }

    public String getFaultReason() {
        String faultString = this.getFaultString();
        if (faultString == null) {
            return null;
        }
        String faultReason = null;
        int endIdx = faultString.indexOf(")");
        faultReason = faultString.substring(endIdx + 1).trim();
        return faultReason;
    }

    public String getMessage() {
        Element[] faultDetails = this.getFaultDetails();
        if (faultDetails == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < faultDetails.length; ++i) {
            strBuffer.append(faultDetails[i]);
        }
        return strBuffer.toString();
    }

    public void setSOAP12_Subcodes(List subcodes) {
        this.subcodes = subcodes;
    }

    public List getSOAP12_Subcodes() {
        return this.subcodes;
    }

    public void setSOAP12_Node(String nodeURI) {
        this.nodeURI = nodeURI;
    }

    public String getSOAP12_Node() {
        return this.nodeURI;
    }

    public void setSOAP12_ReasonLanguage(String language) {
        this.language = language;
    }

    public String getSOAP12_ReasonLanguage() {
        return this.language;
    }

    public void setSOAP12_AdditionalReasons(List list) {
        this.reasons = list;
    }

    public List getSOAP12_AdditionalReasons() {
        return this.reasons;
    }
}

