/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.WsbndFactory;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WSBindingsFileAccessor {
    private static TraceComponent tc = Tr.register(WSBindingsFileAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final EObject theModuleBeingSearched;
    private final String moduleName;
    private final AppDeploymentInfo appDeploymentInfo;
    private final AppDeploymentTask task;
    private final String JMS_TRANSPORT_NAME = "jms";
    private final String HTTP_TRANSPORT_NAME = "http";
    private static final int MODTYPE_NOT_INITIIAZLIED = 1;
    private static final int MODTYPE_WEB = 2;
    private static final int MODTYPE_EJB = 3;
    private int moduleType = 1;
    private WSBinding wsb = null;
    private String pathToWebservicesBndXmiFile = null;

    public WSBindingsFileAccessor(EObject theModuleBeingSearched, String moduleName, AppDeploymentTask task, AppDeploymentInfo appDeploymentInfo) {
        this.theModuleBeingSearched = theModuleBeingSearched;
        this.moduleName = moduleName;
        this.task = task;
        this.appDeploymentInfo = appDeploymentInfo;
    }

    public WSBindingsFileAccessor(ModuleFile theModuleBeingSearched, AppDeploymentTask task) throws AppDeploymentException {
        this.theModuleBeingSearched = theModuleBeingSearched;
        this.moduleName = theModuleBeingSearched.getName();
        this.task = task;
        this.appDeploymentInfo = null;
        if (theModuleBeingSearched.isWARFile()) {
            this.pathToWebservicesBndXmiFile = "WEB-INF/ibm-webservices-bnd.xmi";
        } else if (theModuleBeingSearched.isEJBJarFile()) {
            this.pathToWebservicesBndXmiFile = "META-INF/ibm-webservices-bnd.xmi";
        } else {
            String message = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error(tc, "WSWS0020E", message);
            throw new AppDeploymentException(message, null);
        }
        try {
            this.wsb = WSModels.getWSBinding(theModuleBeingSearched.getLoadStrategy(), this.pathToWebservicesBndXmiFile);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getRouterModuleNames", "129", this);
            Object[] fillins = new Object[]{this.pathToWebservicesBndXmiFile, theModuleBeingSearched.getName(), ex};
            String message = MessageFormat.format(util.getMessage(task, "WSWS0011E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + message);
            }
            Tr.error(tc, "WSWS0011E", fillins);
            throw new AppDeploymentException(message, ex);
        }
    }

    String[] getRouterModuleNames() throws AppDeploymentException {
        boolean checkRouterModule;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRouterModuleNames: moduleName=" + this.moduleName);
        }
        String[] routerModuleNames = new String[]{null, null};
        Boolean enableEndpointOption = (Boolean)this.task.getAppDeploymentController().getAppOptions().get("enableEndpoint");
        boolean bl = enableEndpointOption == null ? true : (checkRouterModule = enableEndpointOption == false);
        if (checkRouterModule) {
            if (this.wsb != null) {
                EList routerModules = this.wsb.getRouterModules();
                if (routerModules.size() != 0) {
                    Iterator modules = routerModules.iterator();
                    while (modules.hasNext()) {
                        RouterModule mod = (RouterModule)modules.next();
                        String modName = null;
                        if (mod != null && (modName = mod.getName()) != null) {
                            if (mod.getTransport().equals("http")) {
                                routerModuleNames[0] = modName;
                            } else if (mod.getTransport().equals("jms")) {
                                routerModuleNames[1] = modName;
                            } else {
                                Object[] fillins = new Object[]{this.moduleName, mod.getTransport()};
                                String message = MessageFormat.format(util.getMessage(this.task, "WSWS0042E"), fillins);
                                Tr.error(tc, "WSWS0042E", fillins);
                                throw new AppDeploymentException(message, null);
                            }
                        }
                        if (mod != null && modName != null && (routerModuleNames[0] != null || routerModuleNames[1] != null)) continue;
                        Object[] fillins = new Object[]{this.pathToWebservicesBndXmiFile, this.moduleName};
                        String message = MessageFormat.format(util.getMessage(this.task, "WSWS0023E"), fillins);
                        Tr.error(tc, "WSWS0023E", fillins);
                        throw new AppDeploymentException(message, null);
                    }
                }
            } else {
                Object[] fillins = new Object[]{this.moduleName, this.pathToWebservicesBndXmiFile};
                String message = MessageFormat.format(util.getMessage(this.task, "WSWS0018E"), fillins);
                Tr.error(tc, "WSWS0018E", fillins);
                throw new AppDeploymentException(message, null);
            }
        }
        if (tc.isEntryEnabled()) {
            String names = "";
            for (int i = 0; i < routerModuleNames.length; ++i) {
                names = names + routerModuleNames[0] + " ";
            }
            Tr.exit(tc, "getRouterModuleNames: returning routerModuleNames=" + names);
        }
        return routerModuleNames;
    }

    public void setDefaultURLInfo(Map protocolToDefaultValueMap) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("setDefaultURLInfo(), the map being set contains:\n");
            Iterator iter = protocolToDefaultValueMap.keySet().iterator();
            while (iter.hasNext()) {
                String protocol = (String)iter.next();
                buf.append("\t protocol=").append(protocol);
                buf.append(" url=").append(protocolToDefaultValueMap.get(protocol));
            }
            String msg = buf.toString();
            Tr.debug(tc, msg);
        }
        if (this.wsb == null) {
            Tr.error(tc, "WSWS0018E", new Object[]{this.moduleName, "ibm-webservices-bnd.xmi"});
        } else {
            EList wsDescBindings = this.wsb.getWsdescBindings();
            if (wsDescBindings.size() > 0) {
                WSDescBinding firstBinding = (WSDescBinding)wsDescBindings.get(0);
                EList defaultPrefixes = firstBinding.getDefaultEndpointURIPrefixes();
                WsbndFactory wsbndFactory = WsbndFactory.eINSTANCE;
                while (defaultPrefixes.size() < 3) {
                    DefaultEndpointURIPrefix dummyPrefix = wsbndFactory.createDefaultEndpointURIPrefix();
                    dummyPrefix.setText("");
                    defaultPrefixes.add(dummyPrefix);
                }
                Iterator iter = protocolToDefaultValueMap.keySet().iterator();
                while (iter.hasNext()) {
                    DefaultEndpointURIPrefix p;
                    String protocol = (String)iter.next();
                    if (protocol.equals("HTTP")) {
                        p = (DefaultEndpointURIPrefix)defaultPrefixes.get(0);
                        p.setText((String)protocolToDefaultValueMap.get(protocol));
                        continue;
                    }
                    if (protocol.equals("JMS")) {
                        p = (DefaultEndpointURIPrefix)defaultPrefixes.get(1);
                        p.setText((String)protocolToDefaultValueMap.get(protocol));
                        continue;
                    }
                    if (!protocol.equals("EJB")) continue;
                    p = (DefaultEndpointURIPrefix)defaultPrefixes.get(2);
                    p.setText((String)protocolToDefaultValueMap.get(protocol));
                }
            }
        }
    }

    public Map getDefaultURLInfo() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultURLInfo", this);
        }
        HashMap<String, String> protocolToDefaultValueMap = new HashMap<String, String>();
        if (this.wsb == null) {
            Tr.error(tc, "WSWS0018E", new Object[]{this.moduleName, "ibm-webservices-bnd.xmi"});
        } else {
            EList wsDescBindings = this.wsb.getWsdescBindings();
            if (wsDescBindings.size() > 0) {
                String prefix;
                DefaultEndpointURIPrefix p;
                WSDescBinding firstBinding = (WSDescBinding)wsDescBindings.get(0);
                EList defaultPrefixes = firstBinding.getDefaultEndpointURIPrefixes();
                if (defaultPrefixes.size() > 1) {
                    p = (DefaultEndpointURIPrefix)defaultPrefixes.get(0);
                    prefix = p.getText();
                    protocolToDefaultValueMap.put("HTTP", prefix);
                } else {
                    protocolToDefaultValueMap.put("HTTP", "");
                }
                if (defaultPrefixes.size() > 2) {
                    p = (DefaultEndpointURIPrefix)defaultPrefixes.get(1);
                    prefix = p.getText();
                    protocolToDefaultValueMap.put("JMS", prefix);
                } else {
                    protocolToDefaultValueMap.put("JMS", "");
                }
                if (defaultPrefixes.size() > 3) {
                    p = (DefaultEndpointURIPrefix)defaultPrefixes.get(2);
                    prefix = p.getText();
                    protocolToDefaultValueMap.put("EJB", prefix);
                } else {
                    protocolToDefaultValueMap.put("EJB", "");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("getDefaultURLInfo(), the map being returned contains:\n");
            Iterator iter = protocolToDefaultValueMap.keySet().iterator();
            while (iter.hasNext()) {
                String protocol = (String)iter.next();
                buf.append("\t protocol=").append(protocol);
                buf.append(" url=").append(protocolToDefaultValueMap.get(protocol)).append("\n");
            }
            String msg = buf.toString();
            Tr.debug(tc, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultURLInfo");
        }
        return protocolToDefaultValueMap;
    }

    public ClientBinding getClientBinding() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientBinding: moduleName=" + this.moduleName);
        }
        if (this.appDeploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.error(tc, "internal.error", null);
            }
            return null;
        }
        Vector returnVector = new Vector();
        EObject refObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
        String pathToWebservicesBndXmiFile = null;
        pathToWebservicesBndXmiFile = this.isWebType(refObject) ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi";
        ModuleFile mfile = this.appDeploymentInfo.getModuleFileForDD(this.theModuleBeingSearched);
        ClientBinding clientBinding = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Open client binding for module=" + this.moduleName + ", using path: " + pathToWebservicesBndXmiFile);
            }
            clientBinding = WSModels.getWSClientBinding(mfile.getLoadStrategy(), pathToWebservicesBndXmiFile);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getRouterModuleNames", "129", this);
            Object[] fillins = new Object[]{pathToWebservicesBndXmiFile, util.formUriString(this.appDeploymentInfo, refObject), ex};
            String message = MessageFormat.format(util.getMessage(this.task, "WSWS0011E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + message);
            }
            Tr.error(tc, "WSWS0011E", fillins);
            throw new AppDeploymentException(message, ex);
        }
        if (clientBinding != null && tc.isEntryEnabled()) {
            Tr.debug(tc, "Opened client bind file: " + pathToWebservicesBndXmiFile);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientBinding: moduleName=" + this.moduleName);
        }
        return clientBinding;
    }

    public Vector getServerBindServices() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerBindServices: moduleName=" + this.moduleName);
        }
        if (this.appDeploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.error(tc, "internal.error", null);
            }
            return null;
        }
        Vector returnVector = new Vector();
        EObject refObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
        String pathToWebservicesBndXmiFile = null;
        pathToWebservicesBndXmiFile = this.isWebType(refObject) ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
        ModuleFile mfile = this.appDeploymentInfo.getModuleFileForDD(this.theModuleBeingSearched);
        WSBinding wsb = null;
        try {
            wsb = WSModels.getWSBinding(mfile.getLoadStrategy(), pathToWebservicesBndXmiFile);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getClientBinding", "318", this);
            Object[] fillins = new Object[]{pathToWebservicesBndXmiFile, util.formUriString(this.appDeploymentInfo, refObject), ex};
            String message = MessageFormat.format(util.getMessage(this.task, "WSWS0011E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + message);
            }
            Tr.error(tc, "WSWS0011E", fillins);
            throw new AppDeploymentException(message, ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerBindServices: moduleName=" + this.moduleName);
        }
        return returnVector;
    }

    public boolean isWebType(EObject refObject) throws AppDeploymentException {
        if (this.moduleType == 1) {
            if (this.appDeploymentInfo == null) {
                String message = "isWebType: appDeploymentInfo is null";
                if (tc.isEntryEnabled()) {
                    Tr.error(tc, "WSWS0020E", message);
                }
                throw new AppDeploymentException(message, null);
            }
            if (refObject == null) {
                refObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
            }
            if (refObject instanceof WebApp) {
                this.moduleType = 2;
            } else if (refObject instanceof EJBJar) {
                this.moduleType = 3;
            } else {
                String message = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
                Tr.error(tc, "WSWS0020E", message);
                throw new AppDeploymentException(message, null);
            }
        }
        return this.moduleType == 2;
    }

    public WSBinding getServerBinding() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerBinding: moduleName=" + this.moduleName);
        }
        if (this.appDeploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.error(tc, "internal.error", null);
            }
            return null;
        }
        Vector returnVector = new Vector();
        EObject refObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
        String pathToWebservicesBndXmiFile = null;
        pathToWebservicesBndXmiFile = this.isWebType(refObject) ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
        ModuleFile mfile = this.appDeploymentInfo.getModuleFileForDD(this.theModuleBeingSearched);
        WSBinding serverBinding = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Open server binding for module=" + this.moduleName + ", using path: " + pathToWebservicesBndXmiFile);
            }
            serverBinding = WSModels.getWSBinding(mfile.getLoadStrategy(), pathToWebservicesBndXmiFile);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getServerBinding", "405", this);
            Object[] fillins = new Object[]{pathToWebservicesBndXmiFile, util.formUriString(this.appDeploymentInfo, refObject), ex};
            String message = MessageFormat.format(util.getMessage(this.task, "WSWS0011E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + message);
            }
            Tr.error(tc, "WSWS0011E", fillins);
            throw new AppDeploymentException(message, ex);
        }
        if (serverBinding != null && tc.isEntryEnabled()) {
            Tr.debug(tc, "Opened server bind file: " + pathToWebservicesBndXmiFile);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerBinding: moduleName=" + this.moduleName);
        }
        return serverBinding;
    }
}

