/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.management.application.client.MapModulesToServers;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

class MapModulesToServersAccessor {
    private final int URI_COLUMN = 1;
    private final int SERVER_COLUMN = 2;
    private final String[][] taskData;
    private final Map moduleNameToServerNameMap = new HashMap();
    private AppDeploymentController appController;
    private static TraceComponent tc = Tr.register(MapModulesToServersAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    MapModulesToServersAccessor(AppDeploymentController controller) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Constructor");
        }
        this.appController = controller;
        MapModulesToServers mapModulesToServersTask = (MapModulesToServers)controller.getTaskByName("MapModulesToServers", false);
        this.taskData = mapModulesToServersTask.getTaskData();
        if (tc.isDebugEnabled()) {
            String message = "Constructor: MapModulesToservers' taskData is:\n" + DeployUtils.taskDataToString(this.taskData);
            Tr.debug(tc, message);
        }
        if (this.taskData != null) {
            for (int i = 1; i < this.taskData.length; ++i) {
                String uri = this.taskData[i][1];
                String[] pieces = util.separateUriString(uri);
                this.moduleNameToServerNameMap.put(pieces[0], this.taskData[i][2]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Constructor");
        }
    }

    void verifyThatAnEJBJARAndItsRouterAreInTheSameServer(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        Vector ejbJars;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyThatAnEJBJARAndItsRouterAreInTheSameServer");
        }
        if ((ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD")) != null) {
            Iterator iterator = ejbJars.iterator();
            while (iterator.hasNext()) {
                EObject refObject = (EObject)iterator.next();
                String moduleURIOfEJBJAR = util.formUriString(appDeploymentInfo, refObject);
                WSDeploymentDescriptorAccessor ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task);
                if (!ddAccessor.isModuleWebServiceEnabled(task)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "verifyThatAnEJBJARAndItsRouterAreInTheSameServer: the module " + moduleURIOfEJBJAR + " is not Web Services enabled");
                    continue;
                }
                String[] pieces = util.separateUriString(moduleURIOfEJBJAR);
                String moduleNameOfEJBJAr = pieces[0];
                String serverStringOfEJBJAR = (String)this.moduleNameToServerNameMap.get(moduleNameOfEJBJAr);
                ModuleFile mfile = appDeploymentInfo.getModuleFileForDD(refObject);
                WSBindingsFileAccessor bindingsAccessor = new WSBindingsFileAccessor(mfile, task);
                String[] routerModuleNames = bindingsAccessor.getRouterModuleNames();
                for (int i = 0; i < routerModuleNames.length; ++i) {
                    if (routerModuleNames[i] == null) continue;
                    String serverStringOfRouterWAR = (String)this.moduleNameToServerNameMap.get(routerModuleNames[i]);
                    if (serverStringOfRouterWAR == null) {
                        Object[] fillins = new Object[]{routerModuleNames[i]};
                        String message = MessageFormat.format(util.getMessage(task, "WSWS0012E"), fillins);
                        Tr.error(tc, "WSWS0012E", fillins);
                        throw new AppDeploymentException(message, null);
                    }
                    if (this.isTargetTheSame(serverStringOfEJBJAR.trim(), serverStringOfRouterWAR.trim())) continue;
                    Object[] fillins = new Object[]{moduleURIOfEJBJAR, serverStringOfEJBJAR, routerModuleNames[i], serverStringOfRouterWAR};
                    String message = MessageFormat.format(util.getMessage(task, "WSWS0024E"), fillins);
                    Tr.error(tc, "WSWS0024E", fillins);
                    throw new AppDeploymentException(message, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyThatAnEJBJARAndItsRouterAreInTheSameServer");
        }
    }

    private boolean isTargetTheSame(String targetsEJBJar, String targetsRouterWar) {
        boolean isSame;
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTargetTheSame", new Object[]{targetsEJBJar, targetsRouterWar});
            }
            isSame = true;
            if (!targetsEJBJar.equals(targetsRouterWar)) {
                String[] targetsWar;
                String[] targetsJar = targetsEJBJar.split("\\+");
                if (targetsJar.length > (targetsWar = targetsRouterWar.split("\\+")).length) {
                    isSame = false;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "!isSame, more targets in EJB");
                    }
                } else {
                    int i;
                    ArrayList<String> targetsJarInList = new ArrayList<String>();
                    for (int i2 = 0; i2 < targetsJar.length; ++i2) {
                        targetsJarInList.add(this.sortTargetOrder(targetsJar[i2]));
                    }
                    ArrayList<String> targetsWarInList = new ArrayList<String>();
                    for (i = 0; i < targetsWar.length; ++i) {
                        targetsWarInList.add(this.sortTargetOrder(targetsWar[i]));
                    }
                    for (i = 0; i < targetsJarInList.size(); ++i) {
                        if (targetsWarInList.contains(targetsJarInList.get(i))) {
                            targetsWarInList.remove(targetsJarInList.get(i));
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "removed matching target:" + targetsJarInList.get(i));
                            continue;
                        }
                        isSame = false;
                        if (!tc.isEntryEnabled()) break;
                        Tr.debug(tc, "!isSame, target:" + targetsJarInList.get(i));
                        break;
                    }
                    if (isSame && targetsWarInList.size() > 0) {
                        try {
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "RouterWar has more targets: " + targetsWarInList.size());
                            }
                            ConfigService cfgService = null;
                            cfgService = this.appController.getConfigService();
                            if (cfgService == null && tc.isEntryEnabled()) {
                                Tr.debug(tc, "cfgService is null...");
                            }
                            Session session = new Session();
                            if (tc.isEntryEnabled() && session == null) {
                                Tr.debug(tc, "session is null...");
                            }
                            Hashtable<String, String> patternTable = new Hashtable<String, String>();
                            patternTable.put("_Websphere_Config_Data_Type", "Server");
                            Hashtable scopeTable = new Hashtable();
                            block5: for (int i3 = 0; i3 < targetsWarInList.size() && isSame; ++i3) {
                                ObjectName targetON = new ObjectName((String)targetsWarInList.get(i3));
                                if (targetON.getKeyProperty("server") == null || targetON.getKeyProperty("node") == null || targetON.getKeyProperty("cell") == null) {
                                    isSame = false;
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "!isSame, missing server, node or cell:" + targetsJarInList.get(i3));
                                    }
                                    break;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "target in war: " + targetsWarInList.get(i3));
                                }
                                patternTable.put("_Websphere_Config_Data_Display_Name", targetON.getKeyProperty("server"));
                                ObjectName patternON = new ObjectName("WebSphere", patternTable);
                                ObjectName[] serverONs = cfgService.queryConfigObjects(session, null, patternON, null);
                                if (serverONs.length == 0) {
                                    isSame = false;
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "!isSame, serverONs.length is 0");
                                    }
                                    break;
                                }
                                String configId = "cells/" + targetON.getKeyProperty("cell") + "/nodes/" + targetON.getKeyProperty("node") + "/";
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "configId: " + configId);
                                }
                                for (int j = 0; j < serverONs.length; ++j) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "keyProperty: " + serverONs[j].getKeyProperty("_Websphere_Config_Data_Id"));
                                    }
                                    if (serverONs[j].getKeyProperty("_Websphere_Config_Data_Id").indexOf(configId) <= 0) continue;
                                    String serverType = (String)cfgService.getAttribute(session, serverONs[j], "serverType");
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "serverType: " + serverType);
                                    }
                                    if (serverType.equals("WEB_SERVER")) continue;
                                    isSame = false;
                                    if (!tc.isEntryEnabled()) continue block5;
                                    Tr.debug(tc, "!isSame, serverType not WEB_SERVER:" + serverType);
                                    continue block5;
                                }
                            }
                        }
                        catch (Exception ex1) {
                            isSame = false;
                            if (!tc.isEntryEnabled()) break block26;
                            Tr.debug(tc, "!isSame due to Exception:" + ex1);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "isSame: " + isSame);
        }
        return isSame;
    }

    private String sortTargetOrder(String target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sortTargetOrder", new Object[]{target});
        }
        StringBuffer buffer = new StringBuffer();
        try {
            ObjectName targetON = new ObjectName(target);
            buffer.append("WebSphere:");
            if (targetON.getKeyProperty("cell") != null) {
                buffer.append("cell=" + targetON.getKeyProperty("cell"));
            }
            if (targetON.getKeyProperty("node") != null) {
                buffer.append(",");
                buffer.append("node=" + targetON.getKeyProperty("node"));
            }
            if (targetON.getKeyProperty("server") != null) {
                buffer.append(",");
                buffer.append("server=" + targetON.getKeyProperty("server"));
            }
            if (targetON.getKeyProperty("cluster") != null) {
                buffer.append(",");
                buffer.append("cluster=" + targetON.getKeyProperty("cluster"));
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sortTargetOrder", new Object[]{buffer.toString()});
        }
        return buffer.toString();
    }
}

