/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class CopyWSDLFilesToRouterWAR {
    private EARFile earFile;
    private ResourceBundle bundle;
    private static TraceComponent tc = Tr.register(CopyWSDLFilesToRouterWAR.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public CopyWSDLFilesToRouterWAR(EARFile input, ResourceBundle b) {
        this.earFile = input;
        this.bundle = b;
    }

    public void copyFiles() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFiles");
        }
        List ejbJars = this.earFile.getEJBJarFiles();
        List wars = this.earFile.getWARFiles();
        Iterator iter = ejbJars.iterator();
        while (iter.hasNext()) {
            ModuleFile module = (ModuleFile)iter.next();
            String moduleName = module.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copyFiles: working on module " + moduleName);
            }
            WebServices wsdesc = null;
            List jaxrpcPortComponents = null;
            JAXRPCMetaDataWrapper wrapper = null;
            if (module.isEJBJarFile()) {
                JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper(module, module.getArchiveClassLoader());
                wrapper = helper.loadJAXRPCMetaData();
            }
            if (wrapper != null && wrapper.containsJAXRPCServices()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copyFiles: module " + moduleName + " is Web Service enabled");
                }
                wsdesc = wrapper.getWebServices();
                jaxrpcPortComponents = wrapper.getJaxrpcPortComponents();
                String targetModuleName = this.getNameOfRouterWarForEJBModule(module, wars);
                if (targetModuleName == null) continue;
                ModuleFile moduleFile = module;
                String tmpDirForModule = DeployUtils.createWorkingDirectory(null);
                this.extractModulesFilesToTmpDir(moduleName, moduleFile, tmpDirForModule);
                String platformSourceDir = tmpDirForModule + File.separator + "META-INF/wsdl".replace('/', File.separatorChar);
                this.deepCopyDirToModule(platformSourceDir, "WEB-INF/wsdl", targetModuleName);
                DeployUtils.deleteWorkingDirectory(tmpDirForModule);
                continue;
            }
            if (wsdesc == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "copyFiles: module " + moduleName + "is Web NOT Service enabled");
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "copyFiles: module " + moduleName + " had no JAX-RPC port components");
        }
    }

    private void extractModulesFilesToTmpDir(String moduleURI, ModuleFile moduleFile, String tmpDirForModule) throws AppDeploymentException {
        try {
            moduleFile.extractTo(tmpDirForModule, 10);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.copyFiles", "403", this);
            Exception exceptionToLog = ex instanceof SaveFailureException ? ((SaveFailureException)ex).getNestedException() : ex;
            Object[] fillins = new Object[]{moduleURI, exceptionToLog};
            String message = AppUtils.getMessage(this.bundle, "WSWS0005E", fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extractModulesFilesToTmpDir: " + message);
            }
            Tr.error(tc, "WSWS0005E", fillins);
            throw new AppDeploymentException(message, exceptionToLog);
        }
    }

    private String getNameOfRouterWarForEJBModule(ModuleFile module, List wars) {
        String EJBmoduleName = module.getURI();
        String warModuleName = null;
        org.eclipse.jst.j2ee.commonarchivecore.internal.File routerModuleForThisEJB = null;
        String targetModuleName = null;
        WSBinding wsb = null;
        try {
            wsb = WSModels.getWSBinding(module.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.getNameOfRouterWarForEJBModule", "552", this);
        }
        if (wsb != null) {
            EList routerModules = wsb.getRouterModules();
            for (int i = 0; i < routerModules.size(); ++i) {
                RouterModule routerWar = (RouterModule)routerModules.get(i);
                if (!"http".equals(routerWar.getTransport())) continue;
                warModuleName = routerWar.getName();
                break;
            }
            if (warModuleName != null) {
                Iterator iterator = wars.iterator();
                while (iterator.hasNext()) {
                    WARFile element = (WARFile)iterator.next();
                    String nameOfModuleBeingTested = element.getURI();
                    if (!nameOfModuleBeingTested.equals(warModuleName)) continue;
                    routerModuleForThisEJB = element;
                    break;
                }
                if (routerModuleForThisEJB == null) {
                    return null;
                }
                targetModuleName = routerModuleForThisEJB.getURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getNameOfRouterWarForEJBModule: for EJB module " + EJBmoduleName + " the router WAR is " + targetModuleName);
                }
                return targetModuleName;
            }
        }
        return null;
    }

    private void copyFileToModule(File fileToBeCopied, String targetModuleName, String pathInTargetModule) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyFileToModule: fileToBecopie=" + fileToBeCopied + " targetModuleName=" + targetModuleName + " pathInTargetModule=" + pathInTargetModule);
        }
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(fileToBeCopied);
        }
        catch (FileNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.copyFiles", "706", this);
            Object[] fillins = new Object[]{fileToBeCopied, ex};
            String message = AppUtils.getMessage(this.bundle, "WSWS0015E", fillins);
            Tr.error(tc, "WSWS0015E", fillins);
            throw new AppDeploymentException(message, ex);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyFiles: about to save the wsdl file \"" + pathInTargetModule + "\" into module " + targetModuleName);
        }
        CopyWSDLFilesToRouterWAR.saveAsFile(this.earFile, targetModuleName, pathInTargetModule, iStream);
        try {
            iStream.close();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.copyFiles", "437", this);
            Tr.warning(tc, "WSWS0028W", iStream);
        }
    }

    private void deepCopyDirToModule(String sourceDir, String targetDir, String targetModule) throws AppDeploymentException {
        File sourceFile;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deepCopyDirToModule:  sourceDir=" + sourceDir + " targetDir=" + targetDir + " targetModule=" + targetModule);
        }
        if (!(sourceFile = new File(sourceDir)).exists()) {
            return;
        }
        File[] contents = sourceFile.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            String pathInTargetModule = targetDir + "/" + contents[i].getName();
            if (contents[i].isFile()) {
                this.copyFileToModule(contents[i], targetModule, pathInTargetModule);
            }
            if (!contents[i].isDirectory()) continue;
            this.deepCopyDirToModule(contents[i].getPath(), pathInTargetModule, targetModule);
        }
    }

    private static String saveAsFile(EARFile archive, String moduleUri, String fileUriInModule, InputStream in) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAsFile");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleUri: " + moduleUri + ", fileUri: " + fileUriInModule);
        }
        String tempDir = null;
        if (in == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "inputStream is null");
            }
        } else {
            if (archive == null) {
                return null;
            }
            Archive foundArchive = null;
            if (moduleUri == null || moduleUri.trim().equals("")) {
                foundArchive = archive;
            } else {
                Iterator allArchiveFiles = archive.getArchiveFiles().iterator();
                while (allArchiveFiles.hasNext() && !(foundArchive = (Archive)allArchiveFiles.next()).getURI().equals(moduleUri)) {
                    foundArchive = null;
                }
            }
            if (foundArchive != null) {
                Exception error;
                block37: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "found matching archive: " + foundArchive);
                    }
                    ArchiveInit.init();
                    CommonarchiveFactory archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                    error = null;
                    tempDir = System.getProperty("java.io.tmpdir");
                    if (!tempDir.endsWith(File.separator)) {
                        tempDir = tempDir + File.separator;
                    }
                    File archiveName = new File(archive.getURI());
                    tempDir = tempDir + archiveName.getName();
                    if (moduleUri != null && !moduleUri.equals("")) {
                        tempDir = tempDir + "_" + moduleUri;
                    }
                    if (fileUriInModule != null && !fileUriInModule.equals("")) {
                        String convertFileUri = fileUriInModule.replace('/', '_');
                        convertFileUri = convertFileUri.replace('\\', '_');
                        tempDir = tempDir + "_" + convertFileUri;
                    }
                    tempDir = tempDir + "_" + System.currentTimeMillis();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "temp dirname: " + tempDir);
                    }
                    String fileUri = tempDir;
                    if (fileUriInModule != null && !fileUriInModule.equals("")) {
                        fileUri = fileUri + File.separator + fileUriInModule;
                    }
                    File dir = new File(fileUri);
                    dir = new File(dir.getParent());
                    FileOutputStream out = null;
                    try {
                        if (dir.exists()) {
                            AppUtils.deleteDirTree(dir);
                        }
                        dir.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "save file location: " + fileUri);
                        }
                        if ((out = new FileOutputStream(fileUri)) != null) {
                            int byte_read = 0;
                            byte[] buffer = new byte[1024];
                            while ((byte_read = in.read(buffer)) != -1) {
                                out.write(buffer, 0, byte_read);
                            }
                            out.close();
                            out = null;
                            ReadOnlyDirectory readDir = archiveFactory.openReadOnlyDirectory(tempDir);
                            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = readDir.getFileInSelfOrSubdirectory(fileUriInModule);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "file in readDir: " + file);
                            }
                            if (file != null && foundArchive.isDuplicate(fileUriInModule)) {
                                FileIterator iter = foundArchive.getFilesForSave();
                                while (iter.hasNext()) {
                                    org.eclipse.jst.j2ee.commonarchivecore.internal.File removeFile = iter.next();
                                    if (!removeFile.getURI().equals(fileUriInModule)) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, ".... Removing existing file");
                                    }
                                    foundArchive.remove(removeFile);
                                    break;
                                }
                            }
                            if (file != null) {
                                foundArchive.addCopy(file);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not able to create the input stream as a file");
                        }
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.saveAsFile", "505");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "File IO exception: " + ex);
                        }
                        error = ex;
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ex) {
                            FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.saveAsFile", "516");
                            if (!tc.isDebugEnabled()) break block37;
                            Tr.debug(tc, "Error closing save file: " + out + ", " + ex);
                        }
                    }
                }
                if (error != null) {
                    throw new AppDeploymentException(error.toString(), error);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not able to find matching module: " + moduleUri);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAsFile");
        }
        return tempDir;
    }
}

