/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.WSConstants;
import com.ibm.ws.webservices.deploy.DeployUtils;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class BindingChoices
extends AppDeploymentTask {
    private static TraceComponent tc = Tr.register(BindingChoices.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String TaskName = "WebServicesPublishWSDLInfo";
    static final long serialVersionUID = 7397502426348235435L;
    public static final int TOTAL_COLUMNS = 6;
    public static final String MODULE_COLUMN_NAME = "module";
    public static final String USER_INPUT_COLUMN_NAME = "webservices.bindingChoices.UrlFragmentColumnName";
    public static final String PROTOCOL_TYPE_COLUMN_NAME = "Protocol";
    public static final String USE_APPLY_FIELD_FLAG_COLUMN_NAME = "use apply field";
    public static final String LABEL_FOR_APPLY_TEXT_FIELD_COLUMN_NAME = "label for Text Field";
    public static final String DEFAULT_VALUE_FOR_APPLY_TEXT_FIELD_COLUMN_NAME = "Default Value for ApplyField";
    public static final int MODULE = 0;
    public static final int PROTOCOL_TYPE = 1;
    public static final int USER_INPUT = 2;
    public static final int USE_APPLY_FIELD_FLAG = 3;
    public static final int LABEL_FOR_APPLY_TEXT_FIELD = 4;
    public static final int DEFAULT_VALUE_FOR_APPLY_TEXT_FIELD = 5;
    private static final String JAVA_COLON_COMP = "java:comp";
    private static final String JMS_QUEUE = "jms:/queue";
    private static final String JMS_TOPIC = "jms:/topic";
    private static final String JMS_JNDI = "jms:jndi:";

    public BindingChoices(AppDeploymentController flowController) {
        super(flowController);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BindingChoices.ctor()");
        }
        this.name = TaskName;
        this.colNames = new String[6];
        this.colNames[0] = MODULE_COLUMN_NAME;
        this.colNames[1] = PROTOCOL_TYPE_COLUMN_NAME;
        this.colNames[2] = USER_INPUT_COLUMN_NAME;
        this.colNames[3] = USE_APPLY_FIELD_FLAG_COLUMN_NAME;
        this.colNames[4] = LABEL_FOR_APPLY_TEXT_FIELD_COLUMN_NAME;
        this.colNames[5] = DEFAULT_VALUE_FOR_APPLY_TEXT_FIELD_COLUMN_NAME;
        this.mutables = new boolean[6];
        this.mutables[0] = false;
        this.mutables[1] = false;
        this.mutables[2] = true;
        this.mutables[3] = false;
        this.mutables[4] = false;
        this.mutables[5] = false;
        this.requiredColumns = new boolean[6];
        this.requiredColumns[0] = false;
        this.requiredColumns[1] = false;
        this.requiredColumns[2] = false;
        this.requiredColumns[3] = false;
        this.requiredColumns[4] = false;
        this.requiredColumns[5] = false;
        this.hiddenColumns = new boolean[6];
        this.hiddenColumns[0] = false;
        this.hiddenColumns[1] = false;
        this.hiddenColumns[2] = false;
        this.hiddenColumns[3] = true;
        this.hiddenColumns[4] = true;
        this.hiddenColumns[5] = true;
        this.hasHiddenColumns = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BindingChoices.ctor()");
        }
    }

    public String[] validate() {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingChoices.validate(), at the beginning: the taskData contains\n:" + DeployUtils.taskDataToString(this.getTaskData()));
        }
        Vector<String> errorMessages = new Vector<String>();
        this.taskValidateErrorMessages = null;
        for (i = 0; this.taskData != null && i < this.taskData.length; ++i) {
            if (this.taskData[i][1].equals("JMS")) {
                Object[] fillins;
                if (!BindingChoices.isGoodJMSUrlSyntax(this.taskData[i][2])) {
                    fillins = new Object[]{this.taskData[i][2]};
                    String error = MessageFormat.format(util.getMessage(this, "WSWS0054E"), fillins);
                    errorMessages.addElement(error);
                    continue;
                }
                if (!BindingChoices.isProprietaryJmsUrlString(this.taskData[i][2])) continue;
                fillins = new Object[]{this.taskData[i][2]};
                String warning = MessageFormat.format(util.getMessage(this, "WSWS0061W"), fillins);
                Tr.warning(tc, warning);
                continue;
            }
            if (!this.taskData[i][1].equals("EJB") || BindingChoices.isGoodEJBUrlSyntax(this.taskData[i][2])) continue;
            String names = "";
            for (int j = 0; j < WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length; ++j) {
                names = j == WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length - 1 ? names + " and " + WSConstants.VALID_EJB_URL_PROPERTY_NAMES[j] : names + WSConstants.VALID_EJB_URL_PROPERTY_NAMES[j] + ",";
            }
            String example = "";
            if (WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length > 0) {
                example = WSConstants.VALID_EJB_URL_PROPERTY_NAMES[0] + "=someValue";
            }
            if (WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length > 1) {
                example = example + "&" + WSConstants.VALID_EJB_URL_PROPERTY_NAMES[1] + "=someValue";
            }
            Object[] fillins = new String[]{this.taskData[i][2], names, example};
            String error = MessageFormat.format(util.getMessage(this, "WSWS0049E"), fillins);
            errorMessages.addElement(error);
        }
        this.buildErrorMessages(errorMessages);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
            if (this.taskValidateErrorMessages != null && this.taskValidateErrorMessages.length > 0) {
                for (i = 0; i < this.taskValidateErrorMessages.length; ++i) {
                    Tr.exit(tc, "validate taskValidateErrorMessages[" + i + "]=" + this.taskValidateErrorMessages[i]);
                }
            }
        }
        return this.taskValidateErrorMessages;
    }

    public static boolean isGoodJMSUrlSyntax(String jmsUrlString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGoodJMSUrlSyntax, URL string: " + jmsUrlString);
        }
        boolean result = true;
        if (jmsUrlString != null && jmsUrlString.length() > 0) {
            if (jmsUrlString.startsWith(JMS_JNDI)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected new spec-compliant JMS URL string.");
                }
            } else if (BindingChoices.isProprietaryJmsUrlString(jmsUrlString)) {
                int qmarkIndex;
                String remainder;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected proprietary JMS URL string.");
                }
                if ((remainder = jmsUrlString.substring((qmarkIndex = jmsUrlString.indexOf("?")) + 1)).indexOf(":") != -1) {
                    StringTokenizer st = new StringTokenizer(remainder, "&|");
                    while (st.hasMoreElements()) {
                        int index;
                        String propValuePair = st.nextToken();
                        StringTokenizer st2 = new StringTokenizer(propValuePair, "=");
                        String property = st2.nextToken();
                        String value = st2.nextToken();
                        if (!property.equals("destination") && !property.equals("connectionFactory") || (index = value.indexOf(JAVA_COLON_COMP)) == -1) continue;
                        result = false;
                        break;
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Doesn't appear to be a JMS URL string.");
                }
                result = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGoodJMSUrlSyntax, result=" + (result ? "true" : "false"));
        }
        return result;
    }

    public static boolean isProprietaryJmsUrlString(String s) {
        return s.startsWith("jms:") && !s.startsWith(JMS_JNDI);
    }

    public static boolean isGoodEJBUrlSyntax(String ejbUrlString) {
        String delimiters = "&|";
        String valueSeparator = "=";
        if ((ejbUrlString = ejbUrlString.trim()).length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGoodEJBUrlSyntax(" + ejbUrlString + ") returning true");
            }
            return true;
        }
        ejbUrlString = DeployUtils.stripDelimitersFromFrontOfEJBURLPropertyString(ejbUrlString);
        StringTokenizer outerTokenizer = new StringTokenizer(ejbUrlString, delimiters);
        while (outerTokenizer.hasMoreTokens()) {
            String property = outerTokenizer.nextToken();
            int indexOfFirstEqual = property.indexOf(61);
            if (indexOfFirstEqual == -1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGoodEJBUrlSyntax(" + ejbUrlString + ") returning false");
                }
                return false;
            }
            int indexOfLastEqual = property.lastIndexOf(61);
            if (indexOfLastEqual != indexOfFirstEqual) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGoodEJBUrlSyntax(" + ejbUrlString + ") returning false");
                }
                return false;
            }
            StringTokenizer innerTokenizer = new StringTokenizer(property, valueSeparator);
            String propertyName = innerTokenizer.nextToken();
            boolean propertyNameIsValid = false;
            for (int i = 0; i < WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length; ++i) {
                if (!propertyName.equals(WSConstants.VALID_EJB_URL_PROPERTY_NAMES[i])) continue;
                propertyNameIsValid = true;
                break;
            }
            if (propertyNameIsValid) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGoodEJBUrlSyntax(" + ejbUrlString + ") returning false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGoodEJBUrlSyntax(" + ejbUrlString + ") returning true");
        }
        return true;
    }
}

